/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.web;

import com.checkmarx.sonar.dto.CxFullCredentials;
import com.checkmarx.sonar.dto.RestEndpointContext;
import com.checkmarx.sonar.sensor.utils.CxConfigHelper;
import com.checkmarx.sonar.web.HttpHelper;
import com.checkmarx.sonar.web.ProxyParams;
import com.cx.restclient.CxSASTClient;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.sast.dto.Project;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;

public class CxConfigRestEndPoint
implements WebService {
    private static final String COMPONENT_KEY_PARAM = "component";
    private static final String CXVERSION = "SASTVERSION";
    private static final String CREDENTIALS_PARAM = "credentials";
    private static final String IS_SUCCESSFUL = "isSuccessful";
    private static final String ERROR_MESSAGE = "errorMsg";
    private Logger logger = LoggerFactory.getLogger(CxConfigRestEndPoint.class);
    private CxSASTClient shraga;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final String PROJECTS = "projects";
    private static final String PROJECT_PATH = "/project";

    public void define(WebService.Context context) {
        WebService.NewController controller = context.createController("api/checkmarx");
        controller.setDescription("Checkmarx plugin web service");
        WebService.NewAction testConnection = controller.createAction("connect").setPost(true).setDescription("Entry point").setInternal(true).setHandler(new RequestHandler(){

            public void handle(Request request, Response response) {
                try {
                    URLConnection urlConn;
                    CxFullCredentials cxFullCredentials = CxConfigRestEndPoint.this.getCredentialsFromRequest(request);
                    CxConfigRestEndPoint.this.setPasswordIfMissing(cxFullCredentials, request);
                    CxConfigRestEndPoint.this.validateCredentials(cxFullCredentials);
                    URL url = new URL(cxFullCredentials.getCxServerUrl());
                    Proxy proxy = HttpHelper.getProxy();
                    if (proxy != null) {
                        CxConfigRestEndPoint.this.logger.info("Using proxy to connect to SAST server");
                        urlConn = url.openConnection(proxy);
                    } else {
                        urlConn = url.openConnection();
                    }
                    if (url.getProtocol().equalsIgnoreCase("https")) {
                        ((HttpsURLConnection)urlConn).setSSLSocketFactory(CxConfigRestEndPoint.getSSLSocketFactory());
                        ((HttpsURLConnection)urlConn).setHostnameVerifier(CxConfigRestEndPoint.getHostnameVerifier());
                    }
                    CxScanConfig config = new CxScanConfig(cxFullCredentials.getCxServerUrl().trim(), cxFullCredentials.getCxUsername(), cxFullCredentials.getCxPassword(), "Sonar", true);
                    ProxyParams proxyParam = HttpHelper.getProxyParam();
                    if (proxyParam != null) {
                        String proxyHost = proxyParam.getHost();
                        ProxyConfig proxyConfig = new ProxyConfig(proxyHost, proxyParam.getPort(), proxyParam.getUser(), proxyParam.getPssd(), proxyHost.toLowerCase().startsWith("https"));
                        config.setProxyConfig(proxyConfig);
                    }
                    CxConfigRestEndPoint.this.shraga = new CxSASTClient(config, CxConfigRestEndPoint.this.logger);
                    CxConfigRestEndPoint.this.shraga.login();
                    urlConn.connect();
                    CxConfigRestEndPoint.this.sendSuccess(response);
                }
                catch (Exception e) {
                    CxConfigRestEndPoint.this.sendError(response, "Login failed.", e);
                }
            }
        });
        testConnection.createParam(CREDENTIALS_PARAM).setDescription("cx credentials").setRequired(true);
        testConnection.createParam(COMPONENT_KEY_PARAM).setDescription("Current component key").setRequired(true);
        controller.createAction(PROJECTS).setPost(true).setDescription("Return projects of default Checkmarx server (the server that was configured by SonarQube administrator).").setInternal(true).setHandler(new RequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Request request, Response response) {
                CxConfigRestEndPoint.this.logger.info("Retrieving Cx server projects.");
                try (JsonWriter js = response.newJsonWriter();){
                    String projects = CxConfigRestEndPoint.this.getProjects();
                    js.beginObject().prop(CxConfigRestEndPoint.PROJECTS, projects).prop(CxConfigRestEndPoint.IS_SUCCESSFUL, true).endObject();
                }
            }
        });
        controller.createAction("clean_connection").setPost(true).setDescription("Close connection of default Checkmarx server (the server that was configured by SonarQube administrator).").setInternal(true).setHandler(new RequestHandler(){

            public void handle(Request request, Response response) {
                CxConfigRestEndPoint.this.logger.info("Logging out of Checkmarx.");
                try {
                    CxConfigRestEndPoint.this.shraga.close();
                    CxConfigRestEndPoint.this.sendSuccess(response);
                }
                catch (Exception e) {
                    CxConfigRestEndPoint.this.sendError(response, "Logging out of Checkmarx failed.", e);
                }
            }
        });
        WebService.NewAction getCredentials = controller.createAction(CREDENTIALS_PARAM).setInternal(true).setHandler(this::getCredentials);
        getCredentials.createParam(COMPONENT_KEY_PARAM).setRequired(true);
        WebService.NewAction updateCredentials = controller.createAction("update_credentials").setInternal(true).setPost(true).setHandler(this::updateCredentials);
        updateCredentials.createParam(COMPONENT_KEY_PARAM).setRequired(true);
        updateCredentials.createParam(CREDENTIALS_PARAM).setRequired(true);
        controller.done();
    }

    private static SSLSocketFactory getSSLSocketFactory() throws CxClientException {
        SSLContext sslContext;
        TrustAllStrategy acceptingTrustStrategy = new TrustAllStrategy();
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)acceptingTrustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new CxClientException("Fail to set trust all certificate, 'SSLConnectionSocketFactory'", (Throwable)e);
        }
        return sslContext.getSocketFactory();
    }

    private static HostnameVerifier getHostnameVerifier() throws CxClientException {
        return (hostname, session) -> true;
    }

    private void getCredentials(Request request, Response response) {
        try {
            RestEndpointContext context = this.getRestEndpointContext(request);
            CxConfigHelper configHelper = new CxConfigHelper(this.logger);
            CxFullCredentials credentials = configHelper.getCredentialsWithoutPassword(context);
            byte[] jsonBytes = this.objectMapper.writeValueAsBytes((Object)credentials);
            OutputStream output = response.stream().setMediaType("application/json").output();
            output.write(jsonBytes);
            output.close();
        }
        catch (Exception e) {
            this.sendError(response, "Error getting credentials.", e);
        }
    }

    private void updateCredentials(Request request, Response response) {
        try {
            CxConfigHelper configHelper = new CxConfigHelper(this.logger);
            RestEndpointContext context = this.getRestEndpointContext(request);
            CxFullCredentials credentials = this.getCredentialsFromRequest(request);
            configHelper.updateCredentials(context, credentials);
            this.sendSuccess(response);
        }
        catch (Exception e) {
            this.sendError(response, "Error updating connection config.", e);
        }
    }

    private CxFullCredentials getCredentialsFromRequest(Request request) throws IOException {
        String credentialsJson = (String)request.getParam(CREDENTIALS_PARAM).getValue();
        if (!StringUtils.isNotEmpty((CharSequence)credentialsJson)) {
            throw new IOException("No credentials provided");
        }
        CxFullCredentials result = (CxFullCredentials)this.objectMapper.readValue(credentialsJson, CxFullCredentials.class);
        return result;
    }

    private void sendSuccess(Response response) {
        try (JsonWriter js1 = response.newJsonWriter();){
            js1.beginObject().prop(IS_SUCCESSFUL, true).endObject();
        }
        catch (Exception e) {
            this.sendError(response, "success message failed.", e);
        }
    }

    private void sendError(Response response, String message, Exception exception) {
        this.logger.error(message, (Throwable)exception);
        try (JsonWriter js1 = response.newJsonWriter();){
            js1.beginObject().prop(IS_SUCCESSFUL, false).prop(ERROR_MESSAGE, message).endObject();
        }
        catch (Exception e) {
            this.sendError(response, "failed to show message", e);
        }
    }

    private void setPasswordIfMissing(CxFullCredentials credentialsFromRequest, Request request) throws URISyntaxException, IOException {
        if (credentialsFromRequest != null && credentialsFromRequest.getCxPassword() == null) {
            RestEndpointContext context = this.getRestEndpointContext(request);
            CxConfigHelper configHelper = new CxConfigHelper(this.logger);
            String password = configHelper.getPassword(context);
            credentialsFromRequest.setCxPassword(password);
        }
    }

    private RestEndpointContext getRestEndpointContext(Request request) throws URISyntaxException {
        RestEndpointContext result = new RestEndpointContext();
        String refererString = (String)request.header("Referer").get();
        URI refererUri = new URI(refererString);
        String componentKey = (String)request.getParam(COMPONENT_KEY_PARAM).getValue();
        result.setComponentKey(componentKey);
        String contextPath = "";
        String urlPath = refererUri.getPath();
        if (!urlPath.startsWith("/static") && !urlPath.startsWith(PROJECT_PATH)) {
            String prefix = urlPath.contains(PROJECT_PATH) ? PROJECT_PATH : "/static";
            contextPath = urlPath.substring(0, urlPath.indexOf(prefix));
        }
        String baseUrl = String.format("%s://%s%s", refererUri.getScheme(), refererUri.getAuthority(), contextPath);
        result.setSonarBaseUrl(baseUrl);
        Cookie[] requiredCookies = this.getRequiredCookies(request, refererUri);
        result.setRequiredCookies(requiredCookies);
        Header[] headers = this.getRequiredHeaders(request);
        result.setRequiredHeaders(headers);
        return result;
    }

    private Cookie[] getRequiredCookies(Request request, URI srcUri) {
        String COOKIE_HEADER = "Cookie";
        String COOKIE_SEPARATOR = "; ";
        String SESSION_COOKIE_NAME = "JWT-SESSION";
        String XSRF_TOKEN_COOKIE_NAME = "XSRF-TOKEN";
        ArrayList<BasicClientCookie> result = new ArrayList<BasicClientCookie>();
        String rawCookies = (String)request.header("Cookie").get();
        for (String rawCookie : rawCookies.split("; ")) {
            HttpCookie srcCookie;
            List<HttpCookie> cookies = HttpCookie.parse(rawCookie);
            if (cookies.size() <= 0 || !(srcCookie = cookies.get(0)).getName().equals("JWT-SESSION") && !srcCookie.getName().equals("XSRF-TOKEN")) continue;
            BasicClientCookie cookieCopy = new BasicClientCookie(srcCookie.getName(), srcCookie.getValue());
            cookieCopy.setDomain(srcUri.getHost());
            result.add(cookieCopy);
        }
        return result.toArray(new Cookie[0]);
    }

    private Header[] getRequiredHeaders(Request request) {
        String REQUIRED_HEADER_NAME = "x-xsrf-token";
        String headerValue = request.header("x-xsrf-token").orElse("");
        BasicHeader requiredHeader = new BasicHeader("x-xsrf-token", headerValue);
        return new Header[]{requiredHeader};
    }

    private void validateCredentials(CxFullCredentials cxFullCredentials) throws IOException {
        if (cxFullCredentials == null) {
            throw new IOException("No credentials provided");
        }
        if (cxFullCredentials.getCxServerUrl() == null || cxFullCredentials.getCxServerUrl().equals("")) {
            throw new IOException("Checkmarx server URL was not provided.");
        }
        if (cxFullCredentials.getCxUsername() == null || cxFullCredentials.getCxUsername().equals("")) {
            throw new IOException("Checkmarx server username was not provided.");
        }
        if (cxFullCredentials.getCxPassword() == null || cxFullCredentials.getCxPassword().equals("")) {
            throw new IOException("Checkmarx server password was not provided.");
        }
    }

    private String getProjects() throws IOException, CxClientException {
        List allProjects = this.shraga.getAllProjects();
        LinkedList<String> projectNames = new LinkedList<String>();
        for (Project project : allProjects) {
            String teamName = this.shraga.getTeamNameById(project.getTeamId());
            projectNames.add(teamName + "\\" + project.getName());
        }
        return this.convertToJsonArray(projectNames);
    }

    private String convertToJsonArray(List<String> listToConvert) {
        JSONArray jsonArray = new JSONArray(listToConvert);
        return jsonArray.toString();
    }

    static {
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
    }
}

