/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.settings;

import com.checkmarx.sonar.dto.RestEndpointContext;
import com.checkmarx.sonar.sensor.utils.CxConfigHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.sonar.api.batch.sensor.SensorContext;

public class PropertyApiClient {
    private SensorContext sensorContext;
    private RestEndpointContext endpointContext;
    private final Logger logger;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public PropertyApiClient(SensorContext sensorContext, Logger logger) {
        this.sensorContext = sensorContext;
        this.logger = logger;
    }

    public PropertyApiClient(RestEndpointContext endpointContext, Logger logger) {
        this.endpointContext = endpointContext;
        this.logger = logger;
    }

    public String getProperty(String name) throws IOException {
        String requestUrl = CxConfigHelper.getPropertyUrl(this.getSonarBaseUrl(), name, this.getComponentKey());
        this.logger.debug("Getting property: {}", (Object)requestUrl);
        HttpGet request = new HttpGet(requestUrl);
        String msgVal = "";
        JsonNode root = null;
        String value = null;
        try {
            HttpResponse response = this.getResponse((HttpUriRequest)request);
            msgVal = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
            root = this.objectMapper.readTree(msgVal);
            value = root.at("/settings/0/value").textValue();
        }
        catch (Exception e) {
            this.logger.error("Fail to get property from: " + requestUrl + ", Response value: " + msgVal, (Throwable)e);
        }
        return value;
    }

    private String getSonarUrl() {
        String url = StringUtils.isNotEmpty((CharSequence)System.getenv("cx.sonarUrl")) ? System.getenv("cx.sonarUrl") : System.getProperty("cx.sonarUrl");
        return StringUtils.isNotEmpty((CharSequence)url) ? url.trim() : this.getSonarBaseUrl();
    }

    public void setProperty(String name, String value) throws IOException {
        String requestUrl = String.format("%s/%s", this.getSonarUrl(), "api/settings/set");
        this.logger.info("Setting property: {} at {}", (Object)name, (Object)requestUrl);
        HttpPost request = new HttpPost(requestUrl);
        NameValuePair[] params = new NameValuePair[]{new BasicNameValuePair("component", this.getComponentKey()), new BasicNameValuePair("key", name), new BasicNameValuePair("value", value)};
        UrlEncodedFormEntity body = new UrlEncodedFormEntity(Arrays.asList(params));
        request.setEntity((HttpEntity)body);
        HttpResponse response = this.getResponse((HttpUriRequest)request);
        this.throwOnFailure(response, name);
    }

    public void deleteProperty(String name) throws IOException {
        String requestUrl = CxConfigHelper.getPropertyUrl(this.getSonarBaseUrl(), name, this.getComponentKey());
        this.logger.info("Deleting property: {}", (Object)requestUrl);
        HttpDelete request = new HttpDelete(requestUrl);
        HttpResponse response = this.getResponse((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() != Response.Status.NO_CONTENT.getStatusCode()) {
            requestUrl = CxConfigHelper.resetPropertyUrl(this.getSonarBaseUrl(), name, this.getComponentKey());
            response = this.getResponse((HttpUriRequest)new HttpPost(requestUrl));
        }
        this.throwOnFailure(response, name);
    }

    private String getComponentKey() {
        if (this.sensorContext != null) {
            return (String)this.sensorContext.config().get("sonar.projectKey").get();
        }
        return this.endpointContext.getComponentKey();
    }

    private String getSonarBaseUrl() {
        if (this.sensorContext != null) {
            return (String)this.sensorContext.config().get("sonar.host.url").get();
        }
        return this.endpointContext.getSonarBaseUrl();
    }

    private HttpResponse getResponse(HttpUriRequest request) throws IOException {
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.addAuthHeaders(request, (CookieStore)cookieStore);
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();
        return client.execute(request);
    }

    private void addAuthHeaders(HttpUriRequest request, CookieStore cookieStore) {
        block13: {
            try {
                if (this.sensorContext != null) {
                    if (this.sensorContext.config().get("sonar.token").isPresent()) {
                        this.logger.info("Sonar server token is provided in sonar.token");
                        String auth = (String)this.sensorContext.config().get("sonar.token").get() + ":";
                        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
                        String authHeader = "Basic " + new String(encodedAuth);
                        request.setHeader("Authorization", authHeader);
                    } else if (this.sensorContext.config().get("sonar.login").isPresent() && !this.sensorContext.config().get("sonar.password").isPresent()) {
                        this.logger.info("Sonar server token is provided");
                        String auth = (String)this.sensorContext.config().get("sonar.login").get() + ":";
                        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
                        String authHeader = "Basic " + new String(encodedAuth);
                        request.setHeader("Authorization", authHeader);
                    } else if (this.sensorContext.config().get("sonar.login").isPresent() && this.sensorContext.config().get("sonar.password").isPresent()) {
                        this.logger.info("Sonar server credentials are provided");
                        String auth = (String)this.sensorContext.config().get("sonar.login").get() + ":" + (String)this.sensorContext.config().get("sonar.password").get();
                        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
                        String authHeader = "Basic " + new String(encodedAuth);
                        request.setHeader("Authorization", authHeader);
                    }
                    break block13;
                }
                if (this.endpointContext == null) break block13;
                String host = this.getSonarUrl();
                try {
                    if (StringUtils.isNotEmpty((CharSequence)host)) {
                        host = new URL(this.getSonarUrl()).getHost();
                    }
                }
                catch (Exception e) {
                    this.logger.error("Fail to set cookies host for override URL: " + host, (Throwable)e);
                }
                request.setHeaders(this.endpointContext.getRequiredHeaders());
                for (Cookie cookie : this.endpointContext.getRequiredCookies()) {
                    if (StringUtils.isNotEmpty((CharSequence)host)) {
                        ((BasicClientCookie)cookie).setDomain(host);
                        this.logger.info("Updated cookie domain to: " + host);
                    }
                    cookieStore.addCookie(cookie);
                }
            }
            catch (Exception e) {
                this.logger.error("Fail to add authentication headers", (Throwable)e);
            }
        }
    }

    private void throwOnFailure(HttpResponse response, String propertyName) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        this.logger.info("Response code for '" + propertyName + "': " + statusCode);
        if (statusCode != Response.Status.NO_CONTENT.getStatusCode()) {
            throw new IOException(String.format("Error setting property: %s, HTTP status code: %d", propertyName, statusCode));
        }
    }
}

