/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.settings;

import com.checkmarx.sonar.dto.CxFullCredentials;
import com.checkmarx.sonar.sensor.encryption.AesUtil;
import com.checkmarx.sonar.sensor.encryption.SecretKeyStore;
import com.checkmarx.sonar.sensor.utils.CxConfigHelper;
import com.checkmarx.sonar.settings.PropertyApiClient;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class CredentialMigration {
    private static final String LEGACY_CREDENTIALS_KEY = "checkmarx.server.credentials.secured";
    private static final String IV = "F27D5C9927726BCEFE7510B1BDD3D137";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Logger logger;
    private PropertyApiClient client;

    public CredentialMigration(PropertyApiClient client, Logger logger) {
        this.client = client;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureLatestFormat() throws IOException {
        String encryptedLegacyCredentials = null;
        try {
            encryptedLegacyCredentials = this.client.getProperty(LEGACY_CREDENTIALS_KEY);
        }
        catch (Exception e) {
            this.logger.debug("No sonar authentication was given.");
        }
        if (StringUtils.isNotEmpty((CharSequence)encryptedLegacyCredentials)) {
            this.logger.info("Found credentials in legacy format. Starting the migration.");
            try {
                SecretKeyStore keyStore = new SecretKeyStore();
                SecretKey key = keyStore.getSecretKey();
                AesUtil util = new AesUtil();
                String legacyCredentials = util.decrypt(key, IV, encryptedLegacyCredentials);
                JsonNode root = this.objectMapper.readTree(legacyCredentials);
                CxFullCredentials credentialsToSave = new CxFullCredentials();
                credentialsToSave.setCxServerUrl(root.get("cxServerUrl").textValue());
                credentialsToSave.setCxUsername(root.get("cxUsername").textValue());
                String plainPassword = root.get("cxPassword").textValue();
                String encryptedPassword = CxConfigHelper.encrypt(plainPassword);
                credentialsToSave.setCxPassword(encryptedPassword);
                String credentialsJson = this.objectMapper.writeValueAsString((Object)credentialsToSave);
                this.client.setProperty("checkmarx.server.credentials", credentialsJson);
            }
            catch (Exception e) {
                this.logger.error("Fail to migrate credentials, message: " + e.getMessage());
                return;
            }
            finally {
                try {
                    this.client.deleteProperty(LEGACY_CREDENTIALS_KEY);
                }
                catch (Exception ex) {
                    this.logger.error("Failed to delete legacy credentials");
                }
            }
            this.logger.info("Migration completed successfully.");
        } else {
            this.logger.info("Checkmarx credentials migration not needed");
        }
    }
}

