/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.utils;

import com.checkmarx.sonar.dto.CxFullCredentials;
import com.checkmarx.sonar.dto.CxSensorSettings;
import com.checkmarx.sonar.dto.RestEndpointContext;
import com.checkmarx.sonar.sensor.dto.ProjectDetails;
import com.checkmarx.sonar.sensor.encryption.AesUtil;
import com.checkmarx.sonar.sensor.encryption.SecretKeyStore;
import com.checkmarx.sonar.sensor.version.PluginVersionProvider;
import com.checkmarx.sonar.settings.CredentialMigration;
import com.checkmarx.sonar.settings.PropertyApiClient;
import com.checkmarx.sonar.web.HttpHelper;
import com.checkmarx.sonar.web.ProxyParams;
import com.cx.restclient.CxSASTClient;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.exception.CxClientException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.config.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CxConfigHelper {
    public static final String SONAR_HOST_URL = "sonar.host.url";
    public static final String SONAR_PROJECT_KEY = "sonar.projectKey";
    public static final String SONAR_LOGIN_KEY = "sonar.login";
    public static final String SONAR_PASSWORD_KEY = "sonar.password";
    public static final String SONAR_TOKEN_KEY = "sonar.token";
    private static final String VALUE = "value";
    private static final String ENCODING = StandardCharsets.UTF_8.name();
    public static final String SETTINGS_API_PATH = "api/settings";
    public static final String SETTINGS_API_SET_PATH = "api/settings/set";
    public static final String SETTINGS_API_GET_PATH = "api/settings/values";
    public static final String SETTINGS_API_RESET_PATH = "api/settings/reset";
    private Logger log;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private PluginVersionProvider versionProvider = new PluginVersionProvider();

    public CxConfigHelper(Logger log) {
        this.log = log;
    }

    public CxFullCredentials getCxFullCredentials(SensorContext context) {
        try {
            PropertyApiClient client = new PropertyApiClient(context, this.log);
            CredentialMigration migration = new CredentialMigration(client, this.log);
            migration.ensureLatestFormat();
            CxFullCredentials credentials = null;
            String credentialsJson = client.getProperty("checkmarx.server.credentials");
            if (StringUtils.isNotEmpty((CharSequence)credentialsJson)) {
                credentials = (CxFullCredentials)this.objectMapper.readValue(credentialsJson, CxFullCredentials.class);
                String plaintextPassword = this.decrypt(credentials.getCxPassword());
                credentials.setCxPassword(plaintextPassword);
            } else {
                this.logErrorAndNotifyContext("NOTE: Checkmarx scan is canceled;\nError while retrieving Checkmarx settings from Sonar database.\nPlease make sure Checkmarx credentials are configured. Can be configured by admin at: Project Page > Administration > Checkmarx\n", context);
            }
            return credentials;
        }
        catch (IOException e) {
            this.logErrorAndNotifyContext("NOTE: Checkmarx scan is canceled;\nError while getting credentials: " + e.getMessage(), context);
            return null;
        }
    }

    public CxFullCredentials getCredentialsWithoutPassword(RestEndpointContext context) throws IOException {
        PropertyApiClient client = new PropertyApiClient(context, this.log);
        CredentialMigration migration = new CredentialMigration(client, this.log);
        migration.ensureLatestFormat();
        CxFullCredentials result = this.getStoredCredentials(client);
        result.setCxPassword(null);
        return result;
    }

    private CxFullCredentials getStoredCredentials(PropertyApiClient client) throws IOException {
        String credentialsJson = client.getProperty("checkmarx.server.credentials");
        this.log.info("Stored credentials json returned.");
        CxFullCredentials result = StringUtils.isNotEmpty((CharSequence)credentialsJson) ? (CxFullCredentials)this.objectMapper.readValue(credentialsJson, CxFullCredentials.class) : new CxFullCredentials();
        this.log.info("Stored credentials username: " + result.getCxUsername() + ", encrypted password: " + result.getCxPassword());
        return result;
    }

    public String getSonarProperty(SensorContext context, String propertyName) {
        this.log.info("Resolving Cx setting: {}", (Object)propertyName);
        Configuration config = context.config();
        String propertyValue = this.getSonarPropertyHttp(propertyName, config);
        if (propertyValue == null) {
            this.logErrorAndNotifyContext("NOTE: Checkmarx scan is canceled;\nError while retrieving Checkmarx settings from sonar Database.\nPlease make sure Checkmarx credentials are configured.", context);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)propertyValue)) {
            this.logErrorAndNotifyContext("NOTE: Checkmarx scan is canceled;\nCheckmarx settings were not configured.\n Can be configured by admin at: Project Page > Administration > Checkmarx\n", context);
            return null;
        }
        propertyValue = this.getPropertyValue(propertyValue);
        return propertyValue;
    }

    public CxScanConfig getScanConfig(CxFullCredentials cxFullCredentials, SensorContext context) {
        CxScanConfig scanConfig = new CxScanConfig();
        scanConfig.setCxOrigin("Sonar");
        scanConfig.setSastEnabled(true);
        scanConfig.setSynchronous(Boolean.valueOf(true));
        scanConfig.setDisableCertificateValidation(true);
        scanConfig.setUrl(cxFullCredentials.getCxServerUrl());
        scanConfig.setUsername(cxFullCredentials.getCxUsername());
        scanConfig.setPassword(cxFullCredentials.getCxPassword());
        scanConfig.setPresetId(Integer.valueOf(1));
        String cxProject = this.getSonarProperty(context, "checkmarx.server.project_name");
        String pluginVersion = this.getPluginVersion();
        this.log.info("plugin Version: {}", (Object)pluginVersion);
        scanConfig.setPluginVersion(pluginVersion);
        try {
            ProjectDetails projectDetails = this.getProjectAndTeamDetails(cxProject, cxFullCredentials);
            scanConfig.setProjectName(projectDetails.getProjectName());
            scanConfig.setTeamId(projectDetails.getTeamId());
            scanConfig.setTeamPath(projectDetails.getTeamName());
        }
        catch (IOException e) {
            this.logErrorAndNotifyContext("NOTE: Checkmarx scan is canceled;\nError while retrieving team ID for project:" + cxProject, context);
            return scanConfig;
        }
        return scanConfig;
    }

    private String getPluginVersion() {
        String version = null;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/checkmarx.com/com.checkmarx.sonar.cxplugin/pom.xml");
            if (is != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                doc.getDocumentElement().normalize();
                NodeList versionList = doc.getElementsByTagName("version");
                this.log.info("version List: {}", (Object)versionList.getLength());
                if (versionList.getLength() > 0) {
                    Element versionElement = (Element)versionList.item(0);
                    version = versionElement.getTextContent();
                    this.log.info("version Element: {}", (Object)version);
                }
            } else {
                this.log.error("pom.xml not found in the classpath");
            }
        }
        catch (Exception e) {
            this.log.error("Error while reading plugin version", (Throwable)e);
        }
        return version;
    }

    private String getPropertyValue(String responseJson) {
        CxSensorSettings settings = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)responseJson)) {
                settings = (CxSensorSettings)this.objectMapper.readValue(responseJson, CxSensorSettings.class);
                return settings.getFirstSettingValue();
            }
        }
        catch (Exception tryNextLogic) {
            this.log.debug("Fail to retrieve property value using Json");
        }
        String value = null;
        try {
            int valueIdx = responseJson.indexOf(VALUE);
            if (valueIdx >= 0) {
                value = responseJson.substring(valueIdx + 8, responseJson.length() - 4);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            this.log.debug("Fail to retrieve property value");
        }
        return value;
    }

    private ProjectDetails getProjectAndTeamDetails(String cxProject, CxFullCredentials cxFullCredentials) throws IOException {
        this.log.info("Team/Project path: " + cxProject);
        int lastIndex = Math.max(cxProject.lastIndexOf("\\"), cxProject.lastIndexOf("/"));
        String teamName = cxProject.substring(1, lastIndex);
        teamName = "/" + teamName;
        ProjectDetails projectDetails = new ProjectDetails();
        projectDetails.setTeamName(teamName);
        projectDetails.setTeamId(this.getTeamId(teamName, cxFullCredentials));
        projectDetails.setProjectName(cxProject.substring(lastIndex + 1));
        return projectDetails;
    }

    private void logErrorAndNotifyContext(String message, SensorContext context) {
        this.log.error(this.versionProvider.appendVersionToMsg(message));
        context.newAnalysisError().message(this.versionProvider.appendVersionToMsg(message)).save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSonarPropertyHttp(String propertyName, Configuration config) {
        String string;
        block19: {
            HttpResponse response;
            block15: {
                String string2;
                block18: {
                    String auth;
                    CloseableHttpClient client;
                    String propertyHttpURL;
                    block16: {
                        String string3;
                        block17: {
                            block13: {
                                String string4;
                                block14: {
                                    String sonarURL = (String)config.get(SONAR_HOST_URL).get();
                                    String projectName = (String)config.get(SONAR_PROJECT_KEY).get();
                                    propertyHttpURL = CxConfigHelper.getPropertyUrl(sonarURL, propertyName, projectName);
                                    response = null;
                                    client = HttpClientBuilder.create().build();
                                    HttpGet request = new HttpGet(propertyHttpURL);
                                    response = client.execute((HttpUriRequest)request);
                                    if (!this.isOk(response)) break block13;
                                    string4 = CxConfigHelper.createStringFromResponse(response);
                                    if (response == null) break block14;
                                    HttpClientUtils.closeQuietly((HttpResponse)response);
                                }
                                return string4;
                            }
                            if (response.getStatusLine().getStatusCode() != 401 && response.getStatusLine().getStatusCode() != 403) break block15;
                            this.log.info("Forced authentication is enabled: Sonar credentials must be provided");
                            auth = null;
                            if (config.get(SONAR_TOKEN_KEY).isPresent()) {
                                this.log.info("sonar.token present");
                                String token = (String)config.get(SONAR_TOKEN_KEY).get();
                                auth = token + ":";
                                auth = new String(Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1)));
                            } else if (config.get(SONAR_LOGIN_KEY).isPresent() && !config.get(SONAR_PASSWORD_KEY).isPresent()) {
                                String token = (String)config.get(SONAR_LOGIN_KEY).get();
                                auth = token + ":";
                                auth = new String(Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1)));
                            } else if (config.get(SONAR_LOGIN_KEY).isPresent() && config.get(SONAR_PASSWORD_KEY).isPresent()) {
                                String user = (String)config.get(SONAR_LOGIN_KEY).get();
                                String pass = (String)config.get(SONAR_PASSWORD_KEY).get();
                                auth = user + ":" + pass;
                                auth = new String(Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1)));
                            }
                            if (!StringUtils.isEmpty(auth)) break block16;
                            this.log.error("No authentication input was provided.");
                            string3 = "";
                            if (response == null) break block17;
                            HttpClientUtils.closeQuietly((HttpResponse)response);
                        }
                        return string3;
                    }
                    HttpGet retRequest = new HttpGet(propertyHttpURL);
                    String authHeader = "Basic " + auth;
                    retRequest.setHeader("Authorization", authHeader);
                    this.log.debug("Executing Sonar auth-request, URL: " + propertyHttpURL);
                    HttpResponse retResponse = client.execute((HttpUriRequest)retRequest);
                    if (!this.isOk(retResponse)) break block15;
                    string2 = CxConfigHelper.createStringFromResponse(retResponse);
                    if (response == null) break block18;
                    HttpClientUtils.closeQuietly((HttpResponse)response);
                }
                return string2;
            }
            try {
                string = "";
                if (response == null) break block19;
            }
            catch (IOException e) {
                block20: {
                    try {
                        this.log.warn("Error occured while retrieving property value for property: " + propertyName);
                        string = null;
                        if (response == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            HttpClientUtils.closeQuietly(response);
                        }
                        throw throwable;
                    }
                    HttpClientUtils.closeQuietly((HttpResponse)response);
                }
                return string;
            }
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        return string;
    }

    private boolean isOk(HttpResponse response) {
        try {
            int code = response.getStatusLine().getStatusCode();
            if (code != 200) {
                HttpEntity entity = response.getEntity();
                String resStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                this.log.debug("Failed request, Code: '" + code + "', Body: '" + resStr + "'.");
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static String createStringFromResponse(HttpResponse response) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuilder result = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    private String getTeamId(String teamName, CxFullCredentials cxFullCredentials) throws IOException {
        String teamId;
        Logger logger = LoggerFactory.getLogger(CxConfigHelper.class);
        CxScanConfig config = new CxScanConfig(cxFullCredentials.getCxServerUrl().trim(), cxFullCredentials.getCxUsername(), cxFullCredentials.getCxPassword(), "Sonar", true);
        try {
            ProxyParams proxyParam = HttpHelper.getProxyParam();
            if (proxyParam != null) {
                String proxyHost = proxyParam.getHost();
                ProxyConfig proxyConfig = new ProxyConfig(proxyHost, proxyParam.getPort(), proxyParam.getUser(), proxyParam.getPssd(), proxyHost.toLowerCase().startsWith("https"));
                config.setProxyConfig(proxyConfig);
            }
            CxSASTClient shraga = new CxSASTClient(config, logger);
            shraga.login();
            teamId = shraga.getTeamIdByName(teamName);
        }
        catch (CxClientException | IOException e) {
            throw new IOException("Error in getTeamIdByName, teamName:" + teamName);
        }
        return teamId;
    }

    public String getPassword(RestEndpointContext context) throws IOException {
        PropertyApiClient client = new PropertyApiClient(context, this.log);
        CxFullCredentials credentials = this.getStoredCredentials(client);
        String plaintextPassword = null;
        String encryptedPassword = credentials.getCxPassword();
        if (StringUtils.isNotEmpty((CharSequence)encryptedPassword)) {
            plaintextPassword = this.decrypt(encryptedPassword);
        }
        return plaintextPassword;
    }

    public void updateCredentials(RestEndpointContext context, CxFullCredentials credentials) throws IOException {
        PropertyApiClient client = new PropertyApiClient(context, this.log);
        CxFullCredentials storedCredentials = this.getStoredCredentials(client);
        storedCredentials.setCxServerUrl(credentials.getCxServerUrl());
        storedCredentials.setCxUsername(credentials.getCxUsername());
        this.log.info("Updating username: " + credentials.getCxUsername());
        if (StringUtils.isNotEmpty((CharSequence)credentials.getCxPassword())) {
            String encryptedPassword = CxConfigHelper.encrypt(credentials.getCxPassword());
            this.log.debug("Updating encrypted password: " + encryptedPassword);
            storedCredentials.setCxPassword(encryptedPassword);
        }
        String credentialsJson = this.objectMapper.writeValueAsString((Object)storedCredentials);
        client.setProperty("checkmarx.server.credentials", credentialsJson);
    }

    public static String resetPropertyUrl(String sonarBaseUrl, String propertyName, String componentKey) {
        String result = null;
        try {
            result = String.format("%s/%s?keys=%s&component=%s", CxConfigHelper.resolveSonarUrl(sonarBaseUrl), SETTINGS_API_RESET_PATH, URLEncoder.encode(propertyName, ENCODING), URLEncoder.encode(componentKey, ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static String getPropertyUrl(String sonarBaseUrl, String propertyName, String componentKey) {
        String result = null;
        try {
            result = String.format("%s/%s?keys=%s&component=%s", CxConfigHelper.resolveSonarUrl(sonarBaseUrl), SETTINGS_API_GET_PATH, URLEncoder.encode(propertyName, ENCODING), URLEncoder.encode(componentKey, ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    private static String resolveSonarUrl(String sonarBaseUrl) {
        String url = StringUtils.isNotEmpty((CharSequence)System.getenv("cx.sonarUrl")) ? System.getenv("cx.sonarUrl") : System.getProperty("cx.sonarUrl");
        return StringUtils.isNotEmpty((CharSequence)url) ? url.trim() : sonarBaseUrl;
    }

    public static String encrypt(String plaintext) throws IOException {
        SecretKeyStore keyStore = new SecretKeyStore();
        SecretKey key = keyStore.getSecretKey();
        AesUtil util = new AesUtil();
        String iv = AesUtil.random(16);
        return iv + util.encrypt(key, iv, plaintext);
    }

    private String decrypt(String cryptoText) throws IOException {
        int IV_LENGTH_IN_CHARS = 32;
        try {
            SecretKeyStore keyStore = new SecretKeyStore();
            SecretKey key = keyStore.getSecretKey();
            String iv = cryptoText.substring(0, 32);
            String workload = cryptoText.substring(32);
            AesUtil util = new AesUtil();
            return util.decrypt(key, iv, workload);
        }
        catch (Exception e) {
            throw new IOException("Decryption error.", e);
        }
    }
}

