/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.execution;

import com.checkmarx.sonar.cxrules.CXProgrammingLanguage;
import com.checkmarx.sonar.logger.CxLogger;
import com.checkmarx.sonar.measures.SastMetrics;
import com.checkmarx.sonar.sensor.dto.CxReportToSonarReport;
import com.checkmarx.sonar.sensor.dto.CxResultToSonarResult;
import com.checkmarx.sonar.sensor.dto.FileQueries;
import com.checkmarx.sonar.sensor.dto.SastSeverity;
import com.checkmarx.sonar.sensor.execution.CxSonarFilePathUtil;
import com.checkmarx.sonar.sensor.execution.FileIssueLocationsCreator;
import com.checkmarx.sonar.sensor.execution.FileMetricsCounter;
import com.checkmarx.sonar.sensor.execution.FileQueriesCollector;
import com.cx.restclient.sast.dto.CxXMLResults;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.measures.Metric;

public class SastResultsCollector {
    private CxLogger logger = new CxLogger(SastResultsCollector.class);
    private ObjectMapper mapper = new ObjectMapper();
    private ActiveRules activeRules;
    private Iterable<InputFile> mainFiles;
    private Double remediationEffortPerVulnerability = 1.0E-9;
    private FileMetricsCounter currFileSumVulnerabilityCounter;
    private FileMetricsCounter currFileNewVulnerabilityCounter;
    private FileQueriesCollector currFileQueriesCollector;

    public void collectVulnerabilitiesAndSaveToMetrics(SensorContext context, CxReportToSonarReport cxReport) {
        this.init(context);
        int mainFileSize = 0;
        for (InputFile file : this.mainFiles) {
            ++mainFileSize;
            this.currFileSumVulnerabilityCounter = new FileMetricsCounter();
            this.currFileNewVulnerabilityCounter = new FileMetricsCounter();
            this.currFileQueriesCollector = new FileQueriesCollector();
            FileIssueLocationsCreator fileLocationsCreator = new FileIssueLocationsCreator(file);
            if (!file.isEmpty() && file.isFile()) {
                List<CxResultToSonarResult> resultsForCurrFile = CxSonarFilePathUtil.findResultsByFilePath(cxReport, file.toString());
                if (resultsForCurrFile == null) continue;
                for (CxResultToSonarResult result : resultsForCurrFile) {
                    SastSeverity sastSeverity;
                    ActiveRule rule;
                    if (!this.checkValidity(result, rule = this.findRuleAndHandleErrors(this.activeRules, result.getQuery()), sastSeverity = this.getSastSeverity(result))) continue;
                    List<NewIssueLocation> flowLocationsInFile = fileLocationsCreator.createFlowLocations(result, context);
                    NewIssueLocation issueLocation = fileLocationsCreator.createIssueLocation(result, context);
                    context.newIssue().forRule(rule.ruleKey()).overrideSeverity(sastSeverity.getSonarSeverity()).gap(this.remediationEffortPerVulnerability).at(issueLocation).addFlow(flowLocationsInFile).save();
                    this.updateCurrFileVulnerabilities(result);
                    this.updateQueryToCurrFile(result);
                }
            } else {
                this.logger.warn("File '" + file.toString() + "' is empty or not file type");
            }
            this.saveCxCustomMetrics(context, file);
            this.saveCxQueriesMeasure(context, file);
        }
        this.logger.info("[CHECKMARX] Main files size: " + mainFileSize);
    }

    private boolean checkValidity(CxResultToSonarResult result, ActiveRule rule, SastSeverity sastSeverity) {
        if ("1".equals(result.getResultData().getState())) {
            return false;
        }
        if (rule == null) {
            return false;
        }
        return !SastSeverity.SAST_INFO.equals((Object)sastSeverity) && sastSeverity != null;
    }

    private void init(SensorContext context) {
        this.mainFiles = this.getMainFiles(context);
        this.activeRules = context.activeRules();
        this.setRemediationEffortPerVulnerability(context);
    }

    private Iterable<InputFile> getMainFiles(SensorContext context) {
        FileSystem fs = context.fileSystem();
        if (fs == null) {
            this.logger.error("File system was not provided.");
            return new ArrayList<InputFile>();
        }
        Iterable mainFiles = fs.inputFiles(fs.predicates().hasType(InputFile.Type.MAIN));
        if (mainFiles == null) {
            this.logger.info("File system has no Main folder.");
            return new ArrayList<InputFile>();
        }
        return mainFiles;
    }

    private SastSeverity getSastSeverity(CxResultToSonarResult result) {
        SastSeverity sastSeverity = SastSeverity.fromName(result.getResultData().getSeverity());
        if (sastSeverity == null) {
            int index = result.getQuery().getSeverityIndex() != null ? Integer.valueOf(result.getQuery().getSeverityIndex()) : null;
            sastSeverity = SastSeverity.fromId(index);
        }
        return sastSeverity;
    }

    private void setRemediationEffortPerVulnerability(SensorContext context) {
        String remediationEffortInSonarDb = context.config().get("checkmarx.server.remediation").orElse(null);
        if (remediationEffortInSonarDb != null && !remediationEffortInSonarDb.equals("0")) {
            try {
                this.remediationEffortPerVulnerability = Double.valueOf(remediationEffortInSonarDb);
            }
            catch (Exception e) {
                this.logger.error("Failed to set remediation effort, error: " + e.getMessage());
            }
        }
    }

    private ActiveRule findRuleAndHandleErrors(ActiveRules activeRules, CxXMLResults.Query query) {
        CXProgrammingLanguage language = CXProgrammingLanguage.fromLanguageName(query.getLanguage());
        if (language == null) {
            this.logger.error("Unknown language: " + query.getLanguage() + "for query: " + query.getName());
            return null;
        }
        Collection rules = activeRules.findByRepository(language.getSonarRuleRepository());
        ActiveRule rule = null;
        for (ActiveRule currRule : rules) {
            if (!currRule.ruleKey().rule().equals("checkmarx_" + query.getId())) continue;
            rule = currRule;
            break;
        }
        if (rule == null) {
            this.logger.info("Rule: checkmarx_" + query.getId() + " is not active or not existing. It will not appear in Checkmarx scan results.");
            this.logger.info("If rule exists in " + language.getSonarRuleRepository() + " rule repository, you can update it to your quality profile.");
        }
        return rule;
    }

    private void updateQueryToCurrFile(CxResultToSonarResult nonIssueResult) {
        SastSeverity severity = SastSeverity.fromName(nonIssueResult.getResultData().getSeverity());
        if (severity == null) {
            this.logger.error("Result for query " + nonIssueResult.getQuery().getName() + " has no severity. Checkmarx result may be incomplete.");
            return;
        }
        switch (severity) {
            case SAST_CRITICAL: {
                this.currFileQueriesCollector.addCriticalQuery(nonIssueResult.getQuery().getName());
                break;
            }
            case SAST_HIGH: {
                this.currFileQueriesCollector.addHighQuery(nonIssueResult.getQuery().getName());
                break;
            }
            case SAST_MEDIUM: {
                this.currFileQueriesCollector.addMediumQuery(nonIssueResult.getQuery().getName());
                break;
            }
            case SAST_LOW: {
                this.currFileQueriesCollector.addLowQuery(nonIssueResult.getQuery().getName());
                break;
            }
        }
    }

    private void updateCurrFileVulnerabilities(CxResultToSonarResult result) {
        SastSeverity severity = SastSeverity.fromName(result.getResultData().getSeverity());
        if (severity == null) {
            this.logger.error("Result for query " + result.getQuery().getName() + " has no severity. Checkmarx result may be incomplete.");
            return;
        }
        boolean isNew = "New".equals(result.getResultData().getStatus());
        switch (severity) {
            case SAST_CRITICAL: {
                this.currFileSumVulnerabilityCounter.incrementCritical();
                if (!isNew) break;
                this.currFileNewVulnerabilityCounter.incrementCritical();
                break;
            }
            case SAST_HIGH: {
                this.currFileSumVulnerabilityCounter.incrementHigh();
                if (!isNew) break;
                this.currFileNewVulnerabilityCounter.incrementHigh();
                break;
            }
            case SAST_MEDIUM: {
                this.currFileSumVulnerabilityCounter.incrementMedium();
                if (!isNew) break;
                this.currFileNewVulnerabilityCounter.incrementMedium();
                break;
            }
            case SAST_LOW: {
                this.currFileSumVulnerabilityCounter.incrementLow();
                if (!isNew) break;
                this.currFileNewVulnerabilityCounter.incrementLow();
                break;
            }
        }
    }

    private void saveCxCustomMetrics(SensorContext context, InputFile file) {
        try {
            this.addSumVulnerabilitiesMetrics(context, file);
            this.addNewVulnerabilitiesMetrics(context, file);
        }
        catch (Exception e) {
            String errMsg = "Error saving Checkmarx vulnerabilities to to file: " + file.absolutePath() + "\nError: " + e.getMessage() + "\nPresented scan measures and report might be incomplete.";
            this.logger.error(errMsg);
            context.newAnalysisError().onFile(file).message(errMsg);
        }
    }

    private void addSumVulnerabilitiesMetrics(SensorContext context, InputFile file) {
        if (this.currFileSumVulnerabilityCounter.getSumVulnerabilities() > 0) {
            this.addMetric(context, file, SastMetrics.SAST_TOTAL_VULNERABILITIES, this.currFileSumVulnerabilityCounter.getSumVulnerabilities());
            if (this.currFileSumVulnerabilityCounter.getCritical() != 0) {
                this.addMetric(context, file, SastMetrics.SAST_CRITICAL_VULNERABILITIES, this.currFileSumVulnerabilityCounter.getCritical());
            }
            if (this.currFileSumVulnerabilityCounter.getHigh() != 0) {
                this.addMetric(context, file, SastMetrics.SAST_HIGH_VULNERABILITIES, this.currFileSumVulnerabilityCounter.getHigh());
            }
            if (this.currFileSumVulnerabilityCounter.getMedium() != 0) {
                this.addMetric(context, file, SastMetrics.SAST_MEDIUM_VULNERABILITIES, this.currFileSumVulnerabilityCounter.getMedium());
            }
            if (this.currFileSumVulnerabilityCounter.getLow() != 0) {
                this.addMetric(context, file, SastMetrics.SAST_LOW_VULNERABILITIES, this.currFileSumVulnerabilityCounter.getLow());
            }
        }
    }

    private void addNewVulnerabilitiesMetrics(SensorContext context, InputFile file) {
        if (this.currFileNewVulnerabilityCounter.getSumVulnerabilities() != 0) {
            this.addMetric(context, file, SastMetrics.SAST_TOTAL_NEW_VULNERABILITIES, this.currFileNewVulnerabilityCounter.getSumVulnerabilities());
            if (this.currFileNewVulnerabilityCounter.getCritical() != 0) {
                this.addMetric(context, file, SastMetrics.SAST_NEW_CRITICAL_VULNERABILITIES, this.currFileNewVulnerabilityCounter.getCritical());
            }
            if (this.currFileNewVulnerabilityCounter.getHigh() != 0) {
                this.addMetric(context, file, SastMetrics.SAST_NEW_HIGH_VULNERABILITIES, this.currFileNewVulnerabilityCounter.getHigh());
            }
            if (this.currFileNewVulnerabilityCounter.getMedium() != 0) {
                this.addMetric(context, file, SastMetrics.SAST_NEW_MEDIUM_VULNERABILITIES, this.currFileNewVulnerabilityCounter.getMedium());
            }
            if (this.currFileNewVulnerabilityCounter.getLow() != 0) {
                this.addMetric(context, file, SastMetrics.SAST_NEW_LOW_VULNERABILITIES, this.currFileNewVulnerabilityCounter.getLow());
            }
        }
    }

    private void addMetric(SensorContext context, InputFile inputFile, Metric<Integer> metric, int value) {
        context.newMeasure().forMetric(metric).on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(value)).save();
    }

    private void saveCxQueriesMeasure(SensorContext context, InputFile file) {
        FileQueries fileQueries = this.currFileQueriesCollector.getAsFileQueriesObject();
        String json = "";
        try {
            json = this.mapper.writeValueAsString((Object)fileQueries);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error parsing Checkmarx queries du to exception: " + e.getMessage());
            this.logger.error("Details report may be incomplete.");
        }
        context.newMeasure().forMetric(SastMetrics.SAST_SCAN_QUERIES).on((InputComponent)file).withValue((Serializable)((Object)json)).save();
    }
}

