/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.execution;

import com.checkmarx.sonar.cxportalservice.osa.OsaScanClient;
import com.checkmarx.sonar.cxportalservice.osa.model.CVE;
import com.checkmarx.sonar.cxportalservice.osa.model.GetOpenSourceSummaryResponse;
import com.checkmarx.sonar.cxportalservice.osa.model.LastOsaScanStatus;
import com.checkmarx.sonar.cxportalservice.osa.model.Library;
import com.checkmarx.sonar.cxportalservice.osa.model.OsaLatestScansData;
import com.checkmarx.sonar.cxportalservice.osa.model.OsaScan;
import com.checkmarx.sonar.dto.CxFullCredentials;
import com.checkmarx.sonar.measures.OsaMetrics;
import com.checkmarx.sonar.sensor.dto.OsaReportData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class OsaResultsCollector {
    private OsaScanClient osaScanClient;
    private ObjectMapper mapper = new ObjectMapper();
    private Logger logger = Loggers.get(OsaResultsCollector.class);

    public void collectOsaVulnerabilitiesAndSaveToMetrics(SensorContext context, CxFullCredentials cxFullCredentials, long projectId) {
        this.logger.info("Extracting Checkmarx Osa results.");
        OsaLatestScansData osaLatestScansData = null;
        OsaScan lastOsaScan = null;
        GetOpenSourceSummaryResponse openSourceSummaryResponse = null;
        try {
            this.osaScanClient = new OsaScanClient(cxFullCredentials);
            osaLatestScansData = this.osaScanClient.getLastOsaScan(projectId);
            lastOsaScan = osaLatestScansData.getLastSuccessfulOsaScan();
            openSourceSummaryResponse = this.osaScanClient.getOpenSourceSummary(String.valueOf(lastOsaScan.getId()));
        }
        catch (Exception e) {
            String errMsg = "Error while extracting Checkmarx OSA results from server: " + e.getMessage() + "\n Checkmarx Osa measures and report will not be presented.";
            this.logger.error(errMsg);
            context.newAnalysisError().message(errMsg).save();
            return;
        }
        try {
            this.addScanStatusToMeasure(context, osaLatestScansData.isLastScanSuccessful());
            this.addVulnerabilitiesToMetrics(context, openSourceSummaryResponse);
        }
        catch (Exception e) {
            String errMsg = "Error while Checkmarx OSA results to Sonar database: " + e.getMessage() + "\n Checkmarx Osa measures and report will not be presented.";
            this.logger.error(errMsg);
            context.newAnalysisError().message(errMsg).save();
            return;
        }
        try {
            String osaDetailsJson = this.createOsaDetailsJson(osaLatestScansData, openSourceSummaryResponse);
            this.addReportDataToMeasure(context, osaDetailsJson);
        }
        catch (Exception e) {
            String errMsg = "Error while saving Checkmarx OSA results to Sonar database: " + e.getMessage() + "\n Checkmarx report will not be presented.";
            this.logger.error(errMsg);
            context.newAnalysisError().message(errMsg).save();
        }
        this.osaScanClient.close();
    }

    private void addVulnerabilitiesToMetrics(SensorContext context, GetOpenSourceSummaryResponse openSourceSummaryResponse) {
        this.addMetric(context, OsaMetrics.OSA_HIGH_VULNERABILITIES, openSourceSummaryResponse.getHighCount());
        this.addMetric(context, OsaMetrics.OSA_MEDIUM_VULNERABILITIES, openSourceSummaryResponse.getMediumCount());
        this.addMetric(context, OsaMetrics.OSA_LOW_VULNERABILITIES, openSourceSummaryResponse.getLowCount());
        this.addMetric(context, OsaMetrics.OSA_TOTAL_VULNERABILITIES, openSourceSummaryResponse.getHighCount() + openSourceSummaryResponse.getMediumCount() + openSourceSummaryResponse.getLowCount());
    }

    private void addMetric(SensorContext context, Metric<Integer> metric, int value) {
        context.newMeasure().forMetric(metric).on((InputComponent)context.module()).withValue((Serializable)Integer.valueOf(value)).save();
    }

    private String createOsaDetailsJson(OsaLatestScansData lastOsaScanData, GetOpenSourceSummaryResponse openSourceSummaryResponse) {
        OsaScan lastOsaScan = lastOsaScanData.getLastSuccessfulOsaScan();
        List<CVE> cves = this.getCompleteCves(lastOsaScan);
        String scanStart = "";
        String scanEnd = "";
        try {
            scanStart = this.formatScanDate(lastOsaScan.getStartAnalyzeTime());
            scanEnd = this.formatScanDate(lastOsaScan.getEndAnalyzeTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        OsaReportData osaReportData = new OsaReportData();
        osaReportData.setStartAnalyzeTime(scanStart);
        osaReportData.setEndAnalyzeTime(scanEnd);
        osaReportData.setAllCves(cves);
        osaReportData.setFiles(openSourceSummaryResponse.getTotalLibreries());
        osaReportData.setFailureMsg(lastOsaScanData.getFailureMsg());
        try {
            return this.mapper.writeValueAsString((Object)osaReportData);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    private List<CVE> getCompleteCves(OsaScan osaScan) {
        List<CVE> cves = this.osaScanClient.getScanResultCVEs(osaScan.getId());
        List<Library> libraries = this.osaScanClient.getScanResultLibraries(osaScan.getId());
        this.setCVEsLibraryName(cves, libraries);
        this.formatCVEsDates(cves);
        return cves;
    }

    private void setCVEsLibraryName(List<CVE> cveList, List<Library> libraryList) {
        for (CVE cve : cveList) {
            String libraryName = this.getLibraryNameFromList(cve.getLibraryId(), libraryList);
            cve.setLibraryName(libraryName);
        }
    }

    private String getLibraryNameFromList(String libraryId, List<Library> libraryList) {
        for (Library library : libraryList) {
            if (!library.getId().equals(libraryId)) continue;
            return library.getName();
        }
        return null;
    }

    private void formatCVEsDates(List<CVE> cveList) {
        for (CVE cve : cveList) {
            String[] timeParts = cve.getPublishDate().split("T");
            String[] partsOfTimePart = timeParts[0].split("-");
            String metricSimpleTime = partsOfTimePart[2] + "-" + partsOfTimePart[1] + "-" + partsOfTimePart[0];
            cve.setPublishDate(metricSimpleTime);
        }
    }

    private String formatScanDate(String dateToFormat) throws ParseException {
        String oldPattern = "yyyy-mm-dd'T'hh:mm:ss";
        Locale locale = Locale.ENGLISH;
        SimpleDateFormat oldDateFormat = new SimpleDateFormat(oldPattern, locale);
        Date date = oldDateFormat.parse(dateToFormat);
        String displayDatePattern = "dd/MM/yy HH:mm";
        return new SimpleDateFormat(displayDatePattern, locale).format(date);
    }

    private void addReportDataToMeasure(SensorContext context, String osaDetailsJson) {
        context.newMeasure().on((InputComponent)context.module()).forMetric(OsaMetrics.OSA_SCAN_DETAILS).withValue((Serializable)((Object)("\"" + osaDetailsJson + "\""))).save();
    }

    private void addScanStatusToMeasure(SensorContext context, Boolean isSuccess) {
        context.newMeasure().on((InputComponent)context.module()).forMetric(OsaMetrics.OSA_LAST_SCAN_STATUS).withValue((Serializable)((Object)LastOsaScanStatus.fromBoolean(isSuccess).getPresentationValue())).save();
    }
}

