/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.execution;

import com.checkmarx.sonar.sensor.dto.FileQueries;
import com.checkmarx.sonar.sensor.dto.QueryData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FileQueriesCollector {
    private HashMap<String, Integer> criticalVulnerabilityQueries = new HashMap();
    private HashMap<String, Integer> highVulnerabilityQueries = new HashMap();
    private HashMap<String, Integer> mediumVulnerabilityQueries = new HashMap();
    private HashMap<String, Integer> lowVulnerabilityQueries = new HashMap();

    void addCriticalQuery(String queryName) {
        if (this.criticalVulnerabilityQueries.get(queryName) != null) {
            this.criticalVulnerabilityQueries.put(queryName, this.criticalVulnerabilityQueries.get(queryName) + 1);
        } else {
            this.criticalVulnerabilityQueries.put(queryName, 1);
        }
    }

    void addHighQuery(String queryName) {
        if (this.highVulnerabilityQueries.get(queryName) != null) {
            this.highVulnerabilityQueries.put(queryName, this.highVulnerabilityQueries.get(queryName) + 1);
        } else {
            this.highVulnerabilityQueries.put(queryName, 1);
        }
    }

    void addMediumQuery(String queryName) {
        if (this.mediumVulnerabilityQueries.get(queryName) != null) {
            this.mediumVulnerabilityQueries.put(queryName, this.mediumVulnerabilityQueries.get(queryName) + 1);
        } else {
            this.mediumVulnerabilityQueries.put(queryName, 1);
        }
    }

    void addLowQuery(String queryName) {
        if (this.lowVulnerabilityQueries.get(queryName) != null) {
            this.lowVulnerabilityQueries.put(queryName, this.lowVulnerabilityQueries.get(queryName) + 1);
        } else {
            this.lowVulnerabilityQueries.put(queryName, 1);
        }
    }

    public HashMap<String, Integer> getCriticalVulnerabilityQueries() {
        return this.criticalVulnerabilityQueries;
    }

    public HashMap<String, Integer> getHighVulnerabilityQueries() {
        return this.highVulnerabilityQueries;
    }

    public HashMap<String, Integer> getMediumVulnerabilityQueries() {
        return this.mediumVulnerabilityQueries;
    }

    public HashMap<String, Integer> getLowVulnerabilityQueries() {
        return this.lowVulnerabilityQueries;
    }

    FileQueries getAsFileQueriesObject() {
        return new FileQueries(this.getAsQueryDataList(this.criticalVulnerabilityQueries), this.getAsQueryDataList(this.highVulnerabilityQueries), this.getAsQueryDataList(this.mediumVulnerabilityQueries), this.getAsQueryDataList(this.lowVulnerabilityQueries));
    }

    private List<QueryData> getAsQueryDataList(HashMap<String, Integer> vulnerabilityNonIssues) {
        LinkedList<QueryData> toRet = new LinkedList<QueryData>();
        Iterator<Map.Entry<String, Integer>> iterator = vulnerabilityNonIssues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> o;
            Map.Entry<String, Integer> pair = o = iterator.next();
            toRet.add(new QueryData(pair.getKey(), pair.getValue()));
        }
        return toRet;
    }
}

