/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.execution;

import com.checkmarx.sonar.logger.CxLogger;
import com.checkmarx.sonar.sensor.dto.CxResultToSonarResult;
import com.checkmarx.sonar.sensor.execution.CodeHighlightsUtil;
import com.checkmarx.sonar.sensor.execution.CxSonarFilePathUtil;
import com.cx.restclient.sast.dto.CxXMLResults;
import java.util.LinkedList;
import java.util.List;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;

class FileIssueLocationsCreator {
    private CxLogger logger = new CxLogger(FileIssueLocationsCreator.class);
    private InputFile file;
    private static final String LINE = " line: ";
    private static final String SEMI_COLON_FILE = " ; file: ";

    FileIssueLocationsCreator(InputFile file) {
        this.file = file;
    }

    List<NewIssueLocation> createFlowLocations(CxResultToSonarResult result, SensorContext context) {
        LinkedList<NewIssueLocation> allLocationsInFile = new LinkedList<NewIssueLocation>();
        try {
            NewIssueLocation firstLocationInFile = null;
            List resultsNodes = result.getResultData().getPath().getPathNode();
            int nodeLoopEndIdx = 0;
            int nodeLoopStartIdx = resultsNodes.size() - 1;
            if (!CxSonarFilePathUtil.isCxPathAndSonarPathTheSame(((CxXMLResults.Query.Result.Path.PathNode)resultsNodes.get(0)).getFileName(), this.file.absolutePath())) {
                this.logger.debug("Creating highlight for the first location in file:");
                String msg = " ; Origin - file: " + ((CxXMLResults.Query.Result.Path.PathNode)resultsNodes.get(0)).getFileName() + LINE + ((CxXMLResults.Query.Result.Path.PathNode)resultsNodes.get(0)).getLine();
                for (CxXMLResults.Query.Result.Path.PathNode node : result.getResultData().getPath().getPathNode()) {
                    if (!CxSonarFilePathUtil.isCxPathAndSonarPathTheSame(node.getFileName(), this.file.absolutePath()) || (firstLocationInFile = this.createLocationFromPathNode(node, context)) == null) continue;
                    nodeLoopEndIdx = resultsNodes.indexOf(node) + 1;
                    if (!CxSonarFilePathUtil.isCxPathAndSonarPathTheSame(((CxXMLResults.Query.Result.Path.PathNode)resultsNodes.get(nodeLoopEndIdx)).getFileName(), this.file.absolutePath())) {
                        msg = msg + " ; Next location: " + ((CxXMLResults.Query.Result.Path.PathNode)resultsNodes.get(nodeLoopEndIdx)).getName() + SEMI_COLON_FILE + ((CxXMLResults.Query.Result.Path.PathNode)resultsNodes.get(nodeLoopEndIdx)).getFileName() + LINE + ((CxXMLResults.Query.Result.Path.PathNode)resultsNodes.get(nodeLoopEndIdx)).getLine();
                        ++nodeLoopEndIdx;
                    }
                    firstLocationInFile.message(node.getName() + msg);
                    break;
                }
            }
            this.logger.debug("Creating highlight for locations:");
            boolean isPrevNodeInFile = true;
            boolean isCurrNodeInFile = CxSonarFilePathUtil.isCxPathAndSonarPathTheSame(((CxXMLResults.Query.Result.Path.PathNode)resultsNodes.get(nodeLoopStartIdx)).getFileName(), this.file.absolutePath());
            this.iterateFromEndToStart(nodeLoopStartIdx, nodeLoopEndIdx, resultsNodes, isCurrNodeInFile, isPrevNodeInFile, allLocationsInFile, context);
            this.addFileLocation(firstLocationInFile, allLocationsInFile);
        }
        catch (Exception e) {
            this.logger.warn("Could not highlight locations for vulnerability: " + result.getQuery().getName() + " on file: " + this.file.absolutePath());
            this.logger.warn("due to exception: " + e.getMessage());
        }
        return allLocationsInFile;
    }

    private void addFileLocation(NewIssueLocation firstLocationInFile, List<NewIssueLocation> allLocationsInFile) {
        if (firstLocationInFile != null) {
            allLocationsInFile.add(firstLocationInFile);
        }
    }

    private void iterateFromEndToStart(int nodeLoopStartIdx, int nodeLoopEndIdx, List<CxXMLResults.Query.Result.Path.PathNode> resultsNodes, boolean isCurrNodeInFile, boolean isPrevNodeInFile, List<NewIssueLocation> allLocationsInFile, SensorContext context) {
        for (int i = nodeLoopStartIdx; i >= nodeLoopEndIdx; --i) {
            boolean isNextNodeInFile = i <= 0 || CxSonarFilePathUtil.isCxPathAndSonarPathTheSame(resultsNodes.get(i - 1).getFileName(), this.file.absolutePath());
            CxXMLResults.Query.Result.Path.PathNode currNode = resultsNodes.get(i);
            if (isCurrNodeInFile) {
                NewIssueLocation defaultIssueLocation = this.createLocationFromPathNode(currNode, context);
                if (defaultIssueLocation == null) {
                    isCurrNodeInFile = isNextNodeInFile;
                    continue;
                }
                String msgPrev = isNextNodeInFile ? "" : " ; Previous location: " + resultsNodes.get(i - 1).getName() + SEMI_COLON_FILE + resultsNodes.get(i - 1).getFileName() + LINE + resultsNodes.get(i - 1).getLine();
                String msgNext = isPrevNodeInFile ? "" : " ; Next location: " + resultsNodes.get(i + 1).getName() + SEMI_COLON_FILE + resultsNodes.get(i + 1).getFileName() + LINE + resultsNodes.get(i + 1).getLine();
                String msg = currNode.getName() + msgPrev + msgNext;
                allLocationsInFile.add(defaultIssueLocation.message(msg));
                isPrevNodeInFile = true;
            } else {
                isPrevNodeInFile = false;
            }
            isCurrNodeInFile = isNextNodeInFile;
        }
    }

    NewIssueLocation createIssueLocation(CxResultToSonarResult result, SensorContext context) {
        CodeHighlightsUtil.Highlight highlightLine = CodeHighlightsUtil.getHighlightForPathNode(this.file, result.getNodeToMarkOnFile());
        if (highlightLine == null) {
            highlightLine = new CodeHighlightsUtil.Highlight(1, -1, -1);
        }
        NewIssue defaultIssueLocation = context.newIssue();
        return defaultIssueLocation.newLocation().on((InputComponent)this.file).at(this.file.selectLine(highlightLine.getLine())).message("Checkmarx Vulnerability : " + result.getQuery().getName());
    }

    private NewIssueLocation createLocationFromPathNode(CxXMLResults.Query.Result.Path.PathNode node, SensorContext context) {
        CodeHighlightsUtil.Highlight highlight = CodeHighlightsUtil.getHighlightForPathNode(this.file, node);
        if (highlight == null) {
            return null;
        }
        this.logger.debug("File " + this.file.toString() + ", " + highlight.toString());
        NewIssue defaultIssueLocation = context.newIssue();
        if (highlight.getStart() == -1) {
            if (highlight.getLine() <= 1) {
                return defaultIssueLocation.newLocation().on((InputComponent)this.file);
            }
            return defaultIssueLocation.newLocation().on((InputComponent)this.file).at(this.file.selectLine(highlight.getLine()));
        }
        return defaultIssueLocation.newLocation().on((InputComponent)this.file).at(this.file.newRange(this.file.newPointer(highlight.getLine(), highlight.getStart()), this.file.newPointer(highlight.getLine(), highlight.getEnd())));
    }
}

