/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.execution;

import com.checkmarx.sonar.sensor.dto.CxReportToSonarReport;
import com.checkmarx.sonar.sensor.dto.CxResultToSonarResult;
import java.util.List;
import java.util.Map;

class CxSonarFilePathUtil {
    CxSonarFilePathUtil() {
    }

    static List<CxResultToSonarResult> findResultsByFilePath(CxReportToSonarReport cxReport, String sonarFilePath) {
        String formattedSonarFilePath = CxSonarFilePathUtil.toCxFilePathFormat(sonarFilePath);
        List<CxResultToSonarResult> toRet = cxReport.getResultsMappedByFileDir().get(formattedSonarFilePath);
        if (toRet == null) {
            for (Map.Entry<String, List<CxResultToSonarResult>> entry : cxReport.getResultsMappedByFileDir().entrySet()) {
                String cxFilePath = entry.getKey();
                if (formattedSonarFilePath.length() == cxFilePath.length() || !CxSonarFilePathUtil.isUnequalLengthPathsRepresentsTheSamePath(formattedSonarFilePath, cxFilePath)) continue;
                toRet = entry.getValue();
                break;
            }
        }
        return toRet;
    }

    static boolean isCxPathAndSonarPathTheSame(String cxFilePath, String sonarFilePath) {
        String formattedSonarFilePath = CxSonarFilePathUtil.toCxFilePathFormat(sonarFilePath);
        if (sonarFilePath.equals(cxFilePath)) {
            return true;
        }
        if (cxFilePath.length() == formattedSonarFilePath.length()) {
            return false;
        }
        return CxSonarFilePathUtil.isUnequalLengthPathsRepresentsTheSamePath(formattedSonarFilePath, cxFilePath);
    }

    private static String toCxFilePathFormat(String sonarFilePath) {
        return sonarFilePath.replace("\\", "/");
    }

    private static boolean isUnequalLengthPathsRepresentsTheSamePath(String pathA, String pathB) {
        String shortPath;
        String longPath;
        if (pathA.length() > pathB.length()) {
            longPath = pathA;
            shortPath = pathB;
        } else {
            longPath = pathB;
            shortPath = pathA;
        }
        String endOfLongPath = longPath.substring(longPath.length() - shortPath.length(), longPath.length());
        return endOfLongPath.equalsIgnoreCase(shortPath);
    }
}

