/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.execution;

import com.checkmarx.sonar.dto.CxFullCredentials;
import com.checkmarx.sonar.logger.CxLogger;
import com.checkmarx.sonar.sensor.dto.CxReportToSonarReport;
import com.checkmarx.sonar.sensor.dto.CxResultToSonarResult;
import com.checkmarx.sonar.sensor.dto.SastReportData;
import com.cx.restclient.sast.dto.CxXMLResults;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class CxResultsAdapter {
    private static CxLogger logger = new CxLogger(CxResultsAdapter.class);

    public static CxReportToSonarReport adaptCxXmlResultsForSonar(CxXMLResults results) {
        HashMap<String, List<CxResultToSonarResult>> resultHashMap = new HashMap<String, List<CxResultToSonarResult>>();
        for (CxXMLResults.Query query : results.getQuery()) {
            for (CxXMLResults.Query.Result result : query.getResult()) {
                CxXMLResults.Query.Result.Path.PathNode markNode = CxResultsAdapter.retrieveNodeToMarkInResultFile(result);
                if (markNode != null) {
                    List<CxResultToSonarResult> resultsForFile = resultHashMap.get(markNode.getFileName());
                    if (resultsForFile == null) {
                        resultsForFile = new LinkedList<CxResultToSonarResult>();
                        resultHashMap.put(markNode.getFileName(), resultsForFile);
                    }
                    resultsForFile.add(new CxResultToSonarResult(query, result, markNode));
                    continue;
                }
                logger.error("Location was not found for query: " + query.getName() + ". Checkmarx results might be incomplete.");
            }
        }
        return new CxReportToSonarReport(resultHashMap);
    }

    public static SastReportData adaptCxXmlResultsToCxDetailReport(CxXMLResults results, CxFullCredentials cxFullCredentials) {
        SastReportData sastReportData = new SastReportData();
        if (results.getLinesOfCodeScanned() != null) {
            sastReportData.setNumOfCodeLines(Long.valueOf(results.getLinesOfCodeScanned()));
        }
        if (results.getFilesScanned() != null) {
            sastReportData.setNumOfFiles(Long.valueOf(results.getFilesScanned()));
        }
        CxResultsAdapter.setStartEndDateTime(sastReportData, results);
        String viewerUri = cxFullCredentials.getCxServerUrl() + "/CxWebClient/ViewerMain.aspx?scanId=" + results.getScanId() + "&ProjectID=" + results.getProjectId();
        sastReportData.setViewerUri(viewerUri);
        return sastReportData;
    }

    private static CxXMLResults.Query.Result.Path.PathNode retrieveNodeToMarkInResultFile(CxXMLResults.Query.Result result) {
        List nodes = result.getPath().getPathNode();
        for (int i = nodes.size() - 1; i > -1; --i) {
            CxXMLResults.Query.Result.Path.PathNode currNode = (CxXMLResults.Query.Result.Path.PathNode)nodes.get(i);
            if (currNode.getFileName() == null || "0".equals(currNode.getLine())) continue;
            return currNode;
        }
        return null;
    }

    private static void setStartEndDateTime(SastReportData sastReportData, CxXMLResults results) {
        try {
            Date scanStartDate = CxResultsAdapter.createStartDate(results.getScanStart());
            Date scanTimeDate = CxResultsAdapter.createTimeDate(results.getScanTime());
            Date scanEndDate = CxResultsAdapter.createEndDate(scanStartDate, scanTimeDate);
            String scanStartDateFormatted = CxResultsAdapter.formatToDisplayDate(scanStartDate);
            String scanEndDateFormatted = CxResultsAdapter.formatToDisplayDate(scanEndDate);
            sastReportData.setScanStart(scanStartDateFormatted);
            sastReportData.setScanFinish(scanEndDateFormatted);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private static String formatToDisplayDate(Date date) {
        String displayDatePattern = "dd/MM/yy HH:mm";
        Locale locale = Locale.ENGLISH;
        return new SimpleDateFormat(displayDatePattern, locale).format(date);
    }

    private static Date createStartDate(String scanStart) throws ParseException {
        String oldPattern = "EEEE, MMMM dd, yyyy hh:mm:ss a";
        Locale locale = Locale.ENGLISH;
        SimpleDateFormat oldDateFormat = new SimpleDateFormat(oldPattern, locale);
        return oldDateFormat.parse(scanStart);
    }

    private static Date createTimeDate(String scanTime) throws ParseException {
        String oldPattern = "HH'h':mm'm':ss's'";
        SimpleDateFormat oldTimeFormat = new SimpleDateFormat(oldPattern);
        oldTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return oldTimeFormat.parse(scanTime);
    }

    private static Date createEndDate(Date scanStartDate, Date scanTimeDate) {
        long time = scanStartDate.getTime() + scanTimeDate.getTime();
        return new Date(time);
    }
}

