/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.encryption;

import com.checkmarx.sonar.sensor.encryption.AesUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.crypto.SecretKey;

public class SecretKeyStore {
    private static final String KY_ALIAS = "CxCredentials";
    private static final String CONFIG_FILE = "project.properties";
    private static final String KEY_STORE_TYPE = "JCEKS";
    private static final String STORED_P = "RksdGtdBvkJmetJ-ieQX95FtN8Ozac";
    private static final char[] PASD = "RksdGtdBvkJmetJ-ieQX95FtN8Ozac".toCharArray();
    private static final int KEY_SIZE = 128;
    private static final String KEYSTORE_FILENAME = "keystore.bin";
    private Properties applicationProperties;

    public SecretKey getSecretKey() throws IOException {
        SecretKey result;
        try {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
            try (InputStream storeFile = this.getClass().getClassLoader().getResourceAsStream(KEYSTORE_FILENAME);){
                keyStore.load(storeFile, PASD);
            }
            KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)keyStore.getEntry(KY_ALIAS, this.getProtection());
            result = entry.getSecretKey();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
            throw new IOException("Error getting secret key.", e);
        }
        return result;
    }

    private void createKeyStoreFile(String passphrase, String salt, int iterationCount, String targetDir) throws IOException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
            keyStore.load(null, null);
            AesUtil encryptor = new AesUtil();
            SecretKey key = encryptor.generateKey(passphrase, salt, iterationCount, 128);
            KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(key);
            keyStore.setEntry(KY_ALIAS, entry, this.getProtection());
            File fileToCreate = new File(targetDir, KEYSTORE_FILENAME);
            try (FileOutputStream output = new FileOutputStream(fileToCreate);){
                keyStore.store(output, PASD);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException("Error creating KeyStore.", e);
        }
    }

    public static void main(String[] args) throws IOException {
        int EXPECTED_ARGS_LENGTH = 4;
        if (args.length < 4) {
            throw new IllegalArgumentException(String.format("%d arguments expected.", 4));
        }
        SecretKeyStore store = new SecretKeyStore();
        store.createKeyStoreFile(args[0], args[1], Integer.parseInt(args[2]), args[3]);
    }

    private KeyStore.PasswordProtection getProtection() {
        return new KeyStore.PasswordProtection(PASD);
    }
}

