/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.encryption;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class AesUtil {
    public static final int IV_LENGTH_IN_BYTES = 16;
    private static final String KEY_FACTORY_TYPE = "PBKDF2WithHmacSHA1";
    private final Cipher cipher;

    public AesUtil() {
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw this.fail(e);
        }
    }

    public String encrypt(SecretKey key, String iv, String plaintext) {
        byte[] encrypted = this.doFinal(1, key, iv, plaintext.getBytes(StandardCharsets.UTF_8));
        return AesUtil.base64(encrypted);
    }

    public String decrypt(SecretKey key, String iv, String ciphertext) {
        byte[] decrypted = this.doFinal(2, key, iv, AesUtil.base64(ciphertext));
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    private byte[] doFinal(int encryptMode, SecretKey key, String iv, byte[] bytes) {
        try {
            this.cipher.init(encryptMode, (Key)key, new IvParameterSpec(AesUtil.hex(iv)));
            return this.cipher.doFinal(bytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw this.fail(e);
        }
    }

    public SecretKey generateKey(String passphrase, String salt, int iterationCount, int keySize) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(KEY_FACTORY_TYPE);
            PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), AesUtil.hex(salt), iterationCount, keySize);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
            return key;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw this.fail(e);
        }
    }

    public static String random(int length) {
        byte[] salt = new byte[length];
        new SecureRandom().nextBytes(salt);
        return AesUtil.hex(salt);
    }

    public static String base64(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] base64(String str) {
        return Base64.decodeBase64((String)str);
    }

    public static String hex(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    public static byte[] hex(String str) {
        try {
            return Hex.decodeHex((char[])str.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalStateException(e);
        }
    }

    private IllegalStateException fail(Exception e) {
        return new IllegalStateException(e);
    }
}

