/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.dto;

import org.sonar.api.batch.rule.Severity;

public enum SastSeverity {
    SAST_CRITICAL(4, "Critical", Severity.BLOCKER),
    SAST_HIGH(3, "High", Severity.CRITICAL),
    SAST_MEDIUM(2, "Medium", Severity.MAJOR),
    SAST_LOW(1, "Low", Severity.MINOR),
    SAST_INFO(0, "Info", Severity.INFO);

    int value;
    String cxName;
    Severity severity;

    private SastSeverity(int value, String cxName, Severity severity) {
        this.value = value;
        this.cxName = cxName;
        this.severity = severity;
    }

    public int getValue() {
        return this.value;
    }

    public String getCxName() {
        return this.cxName;
    }

    public Severity getSonarSeverity() {
        return this.severity;
    }

    public static SastSeverity fromId(int id) {
        for (SastSeverity type : SastSeverity.values()) {
            if (type.getValue() != id) continue;
            return type;
        }
        return null;
    }

    public static SastSeverity fromName(String name) {
        for (SastSeverity type : SastSeverity.values()) {
            if (!type.getCxName().equals(name)) continue;
            return type;
        }
        return null;
    }
}

