/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor.dto;

import com.checkmarx.sonar.cxportalservice.osa.model.CVE;
import com.checkmarx.sonar.sensor.dto.OsaSeverity;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OsaReportData {
    @JsonProperty(value="startAnalyzeTime")
    private String startAnalyzeTime;
    @JsonProperty(value="endAnalyzeTime")
    private String endAnalyzeTime;
    @JsonProperty(value="files")
    private int files;
    @JsonProperty(value="highVulnerabilityCves")
    private List<CVE> highVulnerabilityCves;
    @JsonProperty(value="mediumVulnerabilityCves")
    private List<CVE> mediumVulnerabilityCves;
    @JsonProperty(value="lowVulnerabilityCves")
    private List<CVE> lowVulnerabilityCves;
    @JsonProperty(value="failureMsg")
    private String failureMsg;

    public String getStartAnalyzeTime() {
        return this.startAnalyzeTime;
    }

    public void setStartAnalyzeTime(String startAnalyzeTime) {
        this.startAnalyzeTime = startAnalyzeTime;
    }

    public String getEndAnalyzeTime() {
        return this.endAnalyzeTime;
    }

    public void setEndAnalyzeTime(String endAnalyzeTime) {
        this.endAnalyzeTime = endAnalyzeTime;
    }

    public int getFiles() {
        return this.files;
    }

    public void setFiles(int files) {
        this.files = files;
    }

    public List<CVE> getHighVulnerabilityCves() {
        return this.highVulnerabilityCves;
    }

    public void setHighVulnerabilityCves(List<CVE> highVulnerabilityCves) {
        this.highVulnerabilityCves = highVulnerabilityCves;
    }

    public List<CVE> getMediumVulnerabilityCves() {
        return this.mediumVulnerabilityCves;
    }

    public void setMediumVulnerabilityCves(List<CVE> mediumVulnerabilityCves) {
        this.mediumVulnerabilityCves = mediumVulnerabilityCves;
    }

    public List<CVE> getLowVulnerabilityCves() {
        return this.lowVulnerabilityCves;
    }

    public void setLowVulnerabilityCves(List<CVE> lowVulnerabilityCves) {
        this.lowVulnerabilityCves = lowVulnerabilityCves;
    }

    public String getFailureMsg() {
        return this.failureMsg;
    }

    public void setFailureMsg(String failureMsg) {
        this.failureMsg = failureMsg;
    }

    public void setAllCves(List<CVE> cveList) {
        LinkedList<CVE> high = new LinkedList<CVE>();
        LinkedList<CVE> medium = new LinkedList<CVE>();
        LinkedList<CVE> low = new LinkedList<CVE>();
        for (CVE cve : cveList) {
            OsaSeverity osaSeverity = OsaSeverity.fromId(cve.getSeverity().getId());
            if (osaSeverity == null) continue;
            switch (osaSeverity) {
                case OSA_HIGH: {
                    high.add(cve);
                    break;
                }
                case OSA_MEDIUM: {
                    medium.add(cve);
                    break;
                }
                case OSA_LOW: {
                    low.add(cve);
                }
            }
        }
        this.setHighVulnerabilityCves(high);
        this.setMediumVulnerabilityCves(medium);
        this.setLowVulnerabilityCves(low);
    }
}

