/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.sensor;

import com.checkmarx.sonar.cxportalservice.sast.exception.CxRestLoginException;
import com.checkmarx.sonar.dto.CxFullCredentials;
import com.checkmarx.sonar.measures.SastMetrics;
import com.checkmarx.sonar.sensor.dto.CxReportToSonarReport;
import com.checkmarx.sonar.sensor.dto.SastReportData;
import com.checkmarx.sonar.sensor.execution.CxResultsAdapter;
import com.checkmarx.sonar.sensor.execution.SastResultsCollector;
import com.checkmarx.sonar.sensor.utils.CxConfigHelper;
import com.checkmarx.sonar.sensor.version.PluginVersionProvider;
import com.checkmarx.sonar.web.HttpHelper;
import com.checkmarx.sonar.web.ProxyParams;
import com.cx.restclient.CxClientDelegator;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.sast.dto.CxXMLResults;
import com.cx.restclient.sast.dto.SASTResults;
import com.cx.restclient.sast.utils.SASTUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;

public class CheckmarxSensor
implements Sensor {
    private Logger logger = LoggerFactory.getLogger(CheckmarxSensor.class);
    private PluginVersionProvider versionProvider = new PluginVersionProvider();
    private ObjectMapper mapper = new ObjectMapper();
    private SastResultsCollector sastResultsCollector = new SastResultsCollector();
    private CxClientDelegator shraga = null;

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Import Checkmarx scan results to SonarQube").global();
    }

    public void execute(SensorContext context) {
        this.logger.info(this.versionProvider.appendVersionToMsg("Retrieving Checkmarx scan results for current module"));
        this.logger.info("Getting Checkmarx configuration data from sonar Database.");
        Double version = 9.0;
        try {
            String[] sastVersionSplit;
            CxConfigHelper configHelper = new CxConfigHelper(this.logger);
            String cxProject = configHelper.getSonarProperty(context, "checkmarx.server.project_name");
            if (StringUtils.isEmpty((CharSequence)cxProject)) {
                this.logger.info("Checkmarx analysis isn't configured, skipping step.");
                return;
            }
            CxFullCredentials cxCredentials = configHelper.getCxFullCredentials(context);
            if (cxCredentials == null) {
                throw new CxRestLoginException("Missing Checkmarx credentials");
            }
            CxScanConfig config = configHelper.getScanConfig(cxCredentials, context);
            this.logger.info("Connecting to {}", (Object)config.getUrl());
            ProxyParams proxyParam = HttpHelper.getProxyParam();
            this.shraga = proxyParam == null ? new CxClientDelegator(config, this.logger) : new CxClientDelegator(proxyParam.getHost() + ":" + proxyParam.getPort(), proxyParam.getUser(), proxyParam.getPssd(), "Sonar", true, this.logger);
            this.shraga.init();
            SASTResults latestSASTResults = this.shraga.getLatestScanResults().getSastResults();
            if (config.getCxVersion() != null && config.getCxVersion().getVersion() != null && (version = Double.valueOf(Double.parseDouble((sastVersionSplit = config.getCxVersion().getVersion().split("\\."))[0] + "." + sastVersionSplit[1]))) >= 9.7) {
                this.logger.info("Checkmarx Critical vulnerabilities: " + latestSASTResults.getCritical());
                this.logger.info("Checkmarx New-Critical vulnerabilities: " + latestSASTResults.getNewCritical());
            }
            this.logger.info("Checkmarx High vulnerabilities: " + latestSASTResults.getHigh());
            this.logger.info("Checkmarx New-High vulnerabilities: " + latestSASTResults.getNewHigh());
            this.logger.info("Checkmarx Medium vulnerabilities: " + latestSASTResults.getMedium());
            this.logger.info("Checkmarx New-Medium vulnerabilities: " + latestSASTResults.getNewMedium());
            this.logger.info("Checkmarx Low vulnerabilities: " + latestSASTResults.getLow());
            this.logger.info("Checkmarx New-Low vulnerabilities: " + latestSASTResults.getNewLow());
            this.logger.info("Checkmarx scan link: " + latestSASTResults.getSastScanLink());
            CxXMLResults cxXMLResults = this.convertToXMLResult(latestSASTResults.getRawXMLReport());
            CxReportToSonarReport cxReportToSonarReport = CxResultsAdapter.adaptCxXmlResultsForSonar(cxXMLResults);
            this.sastResultsCollector.collectVulnerabilitiesAndSaveToMetrics(context, cxReportToSonarReport);
            this.notifyComputeSatMeasuresSonarProjectHaveSastResults(context);
            SastReportData sastReportData = CxResultsAdapter.adaptCxXmlResultsToCxDetailReport(cxXMLResults, cxCredentials);
            this.saveSastForDetailReport(context, sastReportData);
            this.logger.info("Sast results retrieval finished.");
        }
        catch (Exception e) {
            this.logger.error("---------------------------------------------------------------------------------------\n");
            this.logger.error("Sast results retrieval failed due to exception: " + e.getMessage() + "\n");
            this.logger.error(this.versionProvider.appendVersionToMsg(""));
            this.logger.error("---------------------------------------------------------------------------------------");
            e.printStackTrace();
        }
    }

    private void notifyComputeSatMeasuresSonarProjectHaveSastResults(SensorContext context) {
        Iterable<InputFile> mainfiles = this.getMainFiles(context);
        for (InputFile file : mainfiles) {
            context.newMeasure().on((InputComponent)file).forMetric(SastMetrics.SONAR_PROJECT_HAVE_SAST_RESULTS).withValue((Serializable)Integer.valueOf(1)).save();
        }
    }

    private Iterable<InputFile> getMainFiles(SensorContext context) {
        FileSystem fs = context.fileSystem();
        if (fs == null) {
            return new ArrayList<InputFile>();
        }
        Iterable mainFiles = fs.inputFiles(fs.predicates().hasType(InputFile.Type.MAIN));
        if (mainFiles == null) {
            return new ArrayList<InputFile>();
        }
        return mainFiles;
    }

    private void saveSastForDetailReport(SensorContext context, SastReportData sastReportData) throws JsonProcessingException {
        String scanDetails = this.mapper.writeValueAsString((Object)sastReportData);
        context.newMeasure().on((InputComponent)context.module()).forMetric(SastMetrics.SAST_SCAN_DETAILS).withValue((Serializable)((Object)scanDetails)).save();
        this.logger.info("Scan report details: " + scanDetails);
    }

    private CxXMLResults convertToXMLResult(byte[] cxReport) throws IOException, JAXBException, CxClientException {
        return SASTUtils.convertToXMLResult((byte[])cxReport);
    }

    static {
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
    }
}

