/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.measures;

import com.checkmarx.sonar.measures.SastMetrics;
import org.sonar.api.ce.measure.Component;
import org.sonar.api.ce.measure.Measure;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.measures.Metric;

public class ComputeSastMeasures
implements MeasureComputer {
    public MeasureComputer.MeasureComputerDefinition define(MeasureComputer.MeasureComputerDefinitionContext def) {
        return def.newDefinitionBuilder().setInputMetrics(new String[]{SastMetrics.SONAR_PROJECT_HAVE_SAST_RESULTS.key(), SastMetrics.SAST_CRITICAL_VULNERABILITIES.key(), SastMetrics.SAST_HIGH_VULNERABILITIES.key(), SastMetrics.SAST_MEDIUM_VULNERABILITIES.key(), SastMetrics.SAST_LOW_VULNERABILITIES.key(), SastMetrics.SAST_TOTAL_VULNERABILITIES.key(), SastMetrics.SAST_NEW_CRITICAL_VULNERABILITIES.key(), SastMetrics.SAST_NEW_HIGH_VULNERABILITIES.key(), SastMetrics.SAST_NEW_MEDIUM_VULNERABILITIES.key(), SastMetrics.SAST_NEW_LOW_VULNERABILITIES.key(), SastMetrics.SAST_TOTAL_NEW_VULNERABILITIES.key(), SastMetrics.SAST_SCAN_DETAILS.key()}).setOutputMetrics(new String[]{SastMetrics.SONAR_PROJECT_HAVE_SAST_RESULTS.key(), SastMetrics.SAST_CRITICAL_VULNERABILITIES.key(), SastMetrics.SAST_HIGH_VULNERABILITIES.key(), SastMetrics.SAST_MEDIUM_VULNERABILITIES.key(), SastMetrics.SAST_LOW_VULNERABILITIES.key(), SastMetrics.SAST_TOTAL_VULNERABILITIES.key(), SastMetrics.SAST_NEW_CRITICAL_VULNERABILITIES.key(), SastMetrics.SAST_NEW_HIGH_VULNERABILITIES.key(), SastMetrics.SAST_NEW_MEDIUM_VULNERABILITIES.key(), SastMetrics.SAST_NEW_LOW_VULNERABILITIES.key(), SastMetrics.SAST_TOTAL_NEW_VULNERABILITIES.key(), SastMetrics.SAST_SCAN_DETAILS.key()}).build();
    }

    public void compute(MeasureComputer.MeasureComputerContext context) {
        if (context.getComponent().getType() != Component.Type.FILE && this.isResult(context)) {
            int sumCritical = this.sumMetric(SastMetrics.SAST_CRITICAL_VULNERABILITIES, context);
            int sumHigh = this.sumMetric(SastMetrics.SAST_HIGH_VULNERABILITIES, context);
            int sumMedium = this.sumMetric(SastMetrics.SAST_MEDIUM_VULNERABILITIES, context);
            int sumLow = this.sumMetric(SastMetrics.SAST_LOW_VULNERABILITIES, context);
            int sumNewCritical = this.sumMetric(SastMetrics.SAST_NEW_CRITICAL_VULNERABILITIES, context);
            int sumNewHigh = this.sumMetric(SastMetrics.SAST_NEW_HIGH_VULNERABILITIES, context);
            int sumNewMedium = this.sumMetric(SastMetrics.SAST_NEW_MEDIUM_VULNERABILITIES, context);
            int sumNewLow = this.sumMetric(SastMetrics.SAST_NEW_LOW_VULNERABILITIES, context);
            context.addMeasure(SastMetrics.SONAR_PROJECT_HAVE_SAST_RESULTS.key(), this.sumMetric(SastMetrics.SONAR_PROJECT_HAVE_SAST_RESULTS, context));
            context.addMeasure(SastMetrics.SAST_CRITICAL_VULNERABILITIES.key(), sumCritical);
            context.addMeasure(SastMetrics.SAST_HIGH_VULNERABILITIES.key(), sumHigh);
            context.addMeasure(SastMetrics.SAST_MEDIUM_VULNERABILITIES.key(), sumMedium);
            context.addMeasure(SastMetrics.SAST_LOW_VULNERABILITIES.key(), sumLow);
            context.addMeasure(SastMetrics.SAST_TOTAL_VULNERABILITIES.key(), sumCritical + sumHigh + sumMedium + sumLow);
            context.addMeasure(SastMetrics.SAST_NEW_CRITICAL_VULNERABILITIES.key(), sumNewCritical);
            context.addMeasure(SastMetrics.SAST_NEW_HIGH_VULNERABILITIES.key(), sumNewHigh);
            context.addMeasure(SastMetrics.SAST_NEW_MEDIUM_VULNERABILITIES.key(), sumNewMedium);
            context.addMeasure(SastMetrics.SAST_NEW_LOW_VULNERABILITIES.key(), sumNewLow);
            context.addMeasure(SastMetrics.SAST_TOTAL_NEW_VULNERABILITIES.key(), sumNewCritical + sumNewHigh + sumNewMedium + sumNewLow);
        }
    }

    private boolean isResult(MeasureComputer.MeasureComputerContext context) {
        for (Measure child : context.getChildrenMeasures(SastMetrics.SONAR_PROJECT_HAVE_SAST_RESULTS.key())) {
            if (child.getIntValue() <= 0) continue;
            return true;
        }
        return false;
    }

    private int sumMetric(Metric<Integer> integerMetric, MeasureComputer.MeasureComputerContext context) {
        int toRet = 0;
        for (Measure child : context.getChildrenMeasures(integerMetric.key())) {
            toRet += child.getIntValue();
        }
        return toRet;
    }
}

