/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.cxrules;

import com.checkmarx.sonar.cxrules.CXProgrammingLanguage;
import com.checkmarx.sonar.logger.CxLogger;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionXmlLoader;

public class CxRulesDefinition
implements RulesDefinition {
    private CxLogger logger = new CxLogger(CxRulesDefinition.class);

    public void define(RulesDefinition.Context context) {
        for (CXProgrammingLanguage language : CXProgrammingLanguage.values()) {
            this.logger.info("Creating rule repository for: " + language.getName() + " language.");
            RulesDefinition.NewRepository repository = context.createRepository("checkmarx.rules." + language.getName().toLowerCase(), language.getSonarName()).setName("Checkmarx");
            try {
                InputStream rulesXml = this.getClass().getResourceAsStream(this.getLanguageRulesPath(language));
                if (rulesXml != null) {
                    RulesDefinitionXmlLoader rulesLoader = new RulesDefinitionXmlLoader();
                    rulesLoader.load(repository, rulesXml, StandardCharsets.UTF_8.name());
                } else {
                    this.logger.error("Could not load rules xml for: " + language.getName() + " language.");
                }
            }
            catch (Exception e) {
                this.logger.error("Could create rules repository for: " + language.getName() + " language.");
                e.printStackTrace();
            }
            repository.done();
        }
    }

    private String getLanguageRulesPath(CXProgrammingLanguage language) {
        return "/com/checkmarx/sonar/rules/" + language.getName().toLowerCase() + "-rules.xml";
    }
}

