/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.cxrules;

public enum CXProgrammingLanguage {
    CPP("CPP", "cpp", 4),
    GO("GO", "go", 131072),
    GROOVY("Groovy", "grvy", 32768),
    JAVA("Java", "java", 2),
    JAVASCRIPT("JavaScript", "js", 8),
    OBJECTIVE_C("Objc", "objc", 4096),
    PERL("Perl", "perl", 2048),
    PHP("PHP", "php", 512),
    PLSQL("PLSQL", "plsql", 8192),
    PYTHON("Python", "py", 16384),
    VB6("VB6", "vb", 256),
    CSHARP("csharp", "cs", 1),
    VBNET("vbnet", "vbnet", 32),
    APEX("Apex", "apex", 16),
    KOTLIN("Kotlin", "kotlin", 524288);

    private String name;
    private String sonarName;
    private int languageId;
    private String sonarRuleRepository;

    private CXProgrammingLanguage(String name, String sonarName, int languageId) {
        this.name = name;
        this.sonarName = sonarName;
        this.languageId = languageId;
        this.sonarRuleRepository = "checkmarx.rules." + this.name.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public String getSonarName() {
        return this.sonarName;
    }

    public int getLanguageId() {
        return this.languageId;
    }

    public String getSonarRuleRepository() {
        return this.sonarRuleRepository;
    }

    public static CXProgrammingLanguage fromLanguageName(String languageName) {
        for (CXProgrammingLanguage language : CXProgrammingLanguage.values()) {
            if (!language.getName().toLowerCase().equals(languageName.toLowerCase())) continue;
            return language;
        }
        return null;
    }
}

