/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.cxpropfiles;

import com.checkmarx.sonar.cxpropfilesUtil.CxProfileData;
import com.checkmarx.sonar.cxpropfilesUtil.CxProfileParserUtil;
import com.checkmarx.sonar.cxpropfilesUtil.CxRuleData;
import com.checkmarx.sonar.cxrules.CXProgrammingLanguage;
import com.checkmarx.sonar.logger.CxLogger;
import java.io.InputStream;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;

public class CxPythonProfile
implements BuiltInQualityProfilesDefinition {
    private CxLogger logger = new CxLogger(CxPythonProfile.class);

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        String profilePath = String.format("com/checkmarx/sonar/profiles/%s-profile.xml", CXProgrammingLanguage.PYTHON.getName().toLowerCase());
        try (InputStream profileFile = this.getClass().getClassLoader().getResourceAsStream(profilePath);){
            if (profileFile == null) {
                this.logger.warn("Profile file not found: " + profilePath);
                return;
            }
            CxProfileData profileData = CxProfileParserUtil.parseProfile(profileFile);
            BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile = context.createBuiltInQualityProfile(profileData.getName(), profileData.getLanguage());
            if (profileData.getRules().isEmpty()) {
                this.logger.warn("No rules found in the profile: " + profileData.getName());
            } else {
                for (CxRuleData rule : profileData.getRules()) {
                    profile.activateRule(rule.getRepositoryKey(), rule.getKey());
                }
            }
            profile.done();
        }
        catch (Exception e) {
            this.logger.error("Failed to define built-in quality profile: " + profilePath);
            e.printStackTrace();
        }
    }
}

