/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sonar.cxportalservice.osa;

import com.checkmarx.sonar.cxportalservice.osa.model.AuthenticationRequest;
import com.checkmarx.sonar.cxportalservice.osa.model.CVE;
import com.checkmarx.sonar.cxportalservice.osa.model.GetOpenSourceSummaryResponse;
import com.checkmarx.sonar.cxportalservice.osa.model.Library;
import com.checkmarx.sonar.cxportalservice.osa.model.OsaLatestScansData;
import com.checkmarx.sonar.cxportalservice.osa.model.OsaScan;
import com.checkmarx.sonar.cxportalservice.osa.model.ScanStatus;
import com.checkmarx.sonar.dto.CxFullCredentials;
import com.checkmarx.sonar.logger.CxLogger;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class OsaScanClient
implements Closeable {
    private static final String ROOT_PATH = "CxRestAPI/";
    private static final String AUTHENTICATION_PATH = "auth/login";
    private static final String ANALYZE_SUMMARY_PATH = "osa/reports";
    private static final String LIBRARIES_PATH = "osa/libraries";
    private static final String CVES_PATH = "osa/vulnerabilities";
    private static final String FAILED_TO_CONNECT_CX_SERVER_ERROR = "connection to checkmarx server failed";
    private static final String CX_COOKIE = "cxCookie";
    private static final String CSRF_COOKIE = "CXCSRFToken";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String CX_ORIGIN_HEADER = "cxOrigin";
    private static final String CX_ORIGIN_VALUE = "Sonar";
    private static final String OSA_SCANS_PATH = "osa/scans";
    private static final int ITEMS_PER_PAGE = 10;
    private CxLogger logger = new CxLogger(OsaScanClient.class);
    private AuthenticationRequest authenticationRequest;
    private Client client;
    private WebTarget root;
    private ObjectMapper mapper = new ObjectMapper();
    private Map<String, NewCookie> cookies;

    public OsaScanClient(CxFullCredentials cxFullCredentials) {
        this.authenticationRequest = new AuthenticationRequest(cxFullCredentials.getCxUsername(), cxFullCredentials.getCxPassword());
        this.client = ((ClientBuilder)ClientBuilder.newBuilder().register(MultiPartFeature.class)).build();
        this.root = this.client.target(cxFullCredentials.getCxServerUrl().trim()).path(ROOT_PATH);
        this.cookies = this.login();
    }

    public Map<String, NewCookie> login() {
        Invocation invocation = this.root.path(AUTHENTICATION_PATH).request().header(CX_ORIGIN_HEADER, (Object)CX_ORIGIN_VALUE).buildPost(Entity.entity((Object)this.authenticationRequest, (String)"application/json"));
        this.logger.info("Authenticating client");
        Response response = this.invokeRequest(invocation);
        this.validateResponse(response, Response.Status.OK, "fail to perform login");
        return response.getCookies();
    }

    public OsaLatestScansData getLastOsaScan(long projectId) {
        this.logger.info("Sending request to get last osa scan.");
        Invocation invocation = this.getOsaScansInvocation(String.valueOf(projectId));
        Response response = this.invokeRequest(invocation);
        this.validateResponse(response, Response.Status.OK, "fail to get last osa scan data");
        CollectionType responseType = this.mapper.getTypeFactory().constructCollectionType(List.class, OsaScan.class);
        try {
            List osaScanList = (List)this.mapper.readValue((String)response.readEntity(String.class), (JavaType)responseType);
            Boolean isLastFinishedScanSucceed = null;
            String scanErrMsg = null;
            for (OsaScan osaScan : osaScanList) {
                if (this.isScanFailed(osaScan)) {
                    isLastFinishedScanSucceed = Boolean.FALSE;
                    scanErrMsg = osaScan.getState().getFailureReason();
                }
                if (!this.isScanSucceeded(osaScan)) continue;
                if (isLastFinishedScanSucceed == null) {
                    isLastFinishedScanSucceed = Boolean.TRUE;
                }
                return new OsaLatestScansData(isLastFinishedScanSucceed, scanErrMsg, osaScan);
            }
        }
        catch (IOException e) {
            throw new WebApplicationException(e.getMessage());
        }
        throw new WebApplicationException("No Osa scan to show");
    }

    public GetOpenSourceSummaryResponse getOpenSourceSummary(String scanId) throws WebApplicationException {
        this.logger.info("Sending request for open source summery.");
        Invocation invocation = this.getOsaSummeryRequestInvocation(scanId);
        Response response = this.invokeRequest(invocation);
        this.validateResponse(response, Response.Status.OK, "fail get OSA scan summary results");
        return (GetOpenSourceSummaryResponse)response.readEntity(GetOpenSourceSummaryResponse.class);
    }

    public List<Library> getScanResultLibraries(String scanId) {
        LinkedList<Library> libraryList = new LinkedList<Library>();
        int lastListSize = 10;
        int currentPage = 1;
        while (lastListSize == 10) {
            Invocation invocation = this.getPageRequestInvocation(LIBRARIES_PATH, currentPage, scanId);
            this.logger.info("sending request for libraries page number " + currentPage);
            Response response = this.invokeRequest(invocation);
            this.validateResponse(response, Response.Status.OK, "fail get OSA scan libraries");
            try {
                List libraryPage = (List)this.mapper.readValue((String)response.readEntity(String.class), (TypeReference)new TypeReference<List<Library>>(){});
                if (libraryPage == null) break;
                libraryList.addAll(libraryPage);
                lastListSize = libraryPage.size();
            }
            catch (IOException e) {
                this.logger.error("failed to parse Libraries: " + e.getMessage());
                lastListSize = 0;
            }
            ++currentPage;
        }
        return libraryList;
    }

    public List<CVE> getScanResultCVEs(String scanId) {
        LinkedList<CVE> cvesList = new LinkedList<CVE>();
        int lastListSize = 10;
        int currentPage = 1;
        while (lastListSize == 10) {
            Invocation invocation = this.getPageRequestInvocation(CVES_PATH, currentPage, scanId);
            this.logger.info("sending request for CVE's page number " + currentPage);
            Response response = this.invokeRequest(invocation);
            this.validateResponse(response, Response.Status.OK, "fail get OSA scan CVE's");
            try {
                List cvePage = (List)this.mapper.readValue((String)response.readEntity(String.class), (TypeReference)new TypeReference<List<CVE>>(){});
                if (cvePage == null) break;
                lastListSize = cvePage.size();
                cvesList.addAll(cvePage);
            }
            catch (IOException e) {
                this.logger.error("failed to parse CVE's");
                lastListSize = 0;
            }
            ++currentPage;
        }
        return cvesList;
    }

    private Invocation getOsaSummeryRequestInvocation(String scanId) {
        return this.root.path(ANALYZE_SUMMARY_PATH).queryParam("scanId", new Object[]{scanId}).request().header(CX_ORIGIN_HEADER, (Object)CX_ORIGIN_VALUE).cookie((Cookie)this.cookies.get(CX_COOKIE)).header(ACCEPT_HEADER, (Object)"application/json").cookie(CSRF_COOKIE, this.cookies.get(CSRF_COOKIE).getValue()).header(CSRF_COOKIE, (Object)this.cookies.get(CSRF_COOKIE).getValue()).buildGet();
    }

    private Invocation getOsaScansInvocation(String projectId) {
        return this.root.path(OSA_SCANS_PATH).queryParam("projectId", new Object[]{projectId}).queryParam("page", new Object[]{1}).queryParam("itemPerPage", new Object[]{20}).request().header(CX_ORIGIN_HEADER, (Object)CX_ORIGIN_VALUE).cookie((Cookie)this.cookies.get(CX_COOKIE)).header(ACCEPT_HEADER, (Object)"application/json").cookie(CSRF_COOKIE, this.cookies.get(CSRF_COOKIE).getValue()).header(CSRF_COOKIE, (Object)this.cookies.get(CSRF_COOKIE).getValue()).buildGet();
    }

    private Invocation getPageRequestInvocation(String path, int pageNumber, String scanId) {
        return this.root.path(path).queryParam("scanId", new Object[]{scanId}).queryParam("page", new Object[]{pageNumber}).queryParam("itemsPerPage", new Object[]{10}).request().header(CX_ORIGIN_HEADER, (Object)CX_ORIGIN_VALUE).cookie((Cookie)this.cookies.get(CX_COOKIE)).cookie(CSRF_COOKIE, this.cookies.get(CSRF_COOKIE).getValue()).header(CSRF_COOKIE, (Object)this.cookies.get(CSRF_COOKIE).getValue()).buildGet();
    }

    private Response invokeRequest(Invocation invocation) {
        try {
            return invocation.invoke();
        }
        catch (ProcessingException exc) {
            return this.ThrowFailedToConnectCxServerError();
        }
    }

    private boolean isScanFailed(OsaScan osaScan) {
        ScanStatus scanStatus = ScanStatus.fromId(osaScan.getState().getId());
        return scanStatus == ScanStatus.FAILED;
    }

    private boolean isScanSucceeded(OsaScan osaScan) {
        ScanStatus scanStatus = ScanStatus.fromId(osaScan.getState().getId());
        return scanStatus != null && scanStatus == ScanStatus.FINISHED;
    }

    private void validateResponse(Response response, Response.Status expectedStatus, String message) throws WebApplicationException {
        if (response.getStatus() == Response.Status.SERVICE_UNAVAILABLE.getStatusCode()) {
            this.ThrowFailedToConnectCxServerError();
        }
        if (response.getStatus() != expectedStatus.getStatusCode()) {
            throw new WebApplicationException(message + ": " + response.getStatusInfo().toString());
        }
    }

    private Response ThrowFailedToConnectCxServerError() {
        throw new WebApplicationException(FAILED_TO_CONNECT_CX_SERVER_ERROR);
    }

    @Override
    public void close() {
        this.client.close();
    }
}

