/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.readers;

import com.checkmarx.configprovider.RemoteRepoDownloader;
import com.checkmarx.configprovider.dto.RepoDto;
import com.checkmarx.configprovider.dto.SourceProviderType;
import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.readers.ListReaders;
import com.checkmarx.configprovider.readers.Parsable;
import com.typesafe.config.Config;
import java.util.LinkedList;
import java.util.List;
import javax.naming.ConfigurationException;

public class RepoReader
extends Parsable
implements ConfigReader {
    private static final String DEFAULT_SEARCH_DIRECTORY = ".checkmarx";
    private static final String REPO_ROOT = "";
    private static final String CX_CONFIG = "cx.config";
    private static final String YML = "yml";
    private static final RemoteRepoDownloader downloader = new RemoteRepoDownloader();
    private String configAsCodeFileName;
    private List<String> foldersToSearch = new LinkedList<String>();
    private ListReaders downloadedResource;
    private RepoDto repoDto;

    public RepoReader(String apiBaseUrl, String namespace, String repoName, String branch, String accessToken, SourceProviderType sourceProviderType) {
        this.buildRemoteRepo(apiBaseUrl, namespace, repoName, branch, accessToken, sourceProviderType);
        this.foldersToSearch.add(DEFAULT_SEARCH_DIRECTORY);
        this.configAsCodeFileName = CX_CONFIG;
    }

    public void setConfigAsCodeFileName(String configAsCodeFileName) {
        this.configAsCodeFileName = configAsCodeFileName;
    }

    public void setFoldersToSearch(List<String> foldersToSearch) {
        this.foldersToSearch = foldersToSearch;
    }

    @Override
    Config toConfig() throws ConfigurationException {
        List<Parsable> listRawConfigYmls = downloader.downloadRepoFiles(this.getRepoDto(), this.foldersToSearch, null, YML);
        ListReaders listReaders = new ListReaders();
        for (Parsable reader : listRawConfigYmls) {
            listReaders.add((ConfigReader)((Object)reader));
        }
        this.downloadedResource = listReaders;
        return listReaders.toConfig();
    }

    @Override
    public String getName() {
        return this.downloadedResource.getName();
    }

    private void buildRemoteRepo(String apiBaseUrl, String namespace, String repoName, String branch, String accessToken, SourceProviderType sourceProviderType) {
        this.repoDto = RepoDto.builder().apiBaseUrl(apiBaseUrl).repoName(repoName).namespace(namespace).ref(branch).accessToken(accessToken).sourceProviderType(sourceProviderType).build();
    }

    public static RepoReaderBuilder builder() {
        return new RepoReaderBuilder();
    }

    public String getConfigAsCodeFileName() {
        return this.configAsCodeFileName;
    }

    public List<String> getFoldersToSearch() {
        return this.foldersToSearch;
    }

    public ListReaders getDownloadedResource() {
        return this.downloadedResource;
    }

    public RepoDto getRepoDto() {
        return this.repoDto;
    }

    public RepoReader(String configAsCodeFileName, List<String> foldersToSearch, ListReaders downloadedResource, RepoDto repoDto) {
        this.configAsCodeFileName = configAsCodeFileName;
        this.foldersToSearch = foldersToSearch;
        this.downloadedResource = downloadedResource;
        this.repoDto = repoDto;
    }

    public static class RepoReaderBuilder {
        private String configAsCodeFileName;
        private List<String> foldersToSearch;
        private ListReaders downloadedResource;
        private RepoDto repoDto;

        RepoReaderBuilder() {
        }

        public RepoReaderBuilder configAsCodeFileName(String configAsCodeFileName) {
            this.configAsCodeFileName = configAsCodeFileName;
            return this;
        }

        public RepoReaderBuilder foldersToSearch(List<String> foldersToSearch) {
            this.foldersToSearch = foldersToSearch;
            return this;
        }

        public RepoReaderBuilder downloadedResource(ListReaders downloadedResource) {
            this.downloadedResource = downloadedResource;
            return this;
        }

        public RepoReaderBuilder repoDto(RepoDto repoDto) {
            this.repoDto = repoDto;
            return this;
        }

        public RepoReader build() {
            return new RepoReader(this.configAsCodeFileName, this.foldersToSearch, this.downloadedResource, this.repoDto);
        }

        public String toString() {
            return "RepoReader.RepoReaderBuilder(configAsCodeFileName=" + this.configAsCodeFileName + ", foldersToSearch=" + this.foldersToSearch + ", downloadedResource=" + this.downloadedResource + ", repoDto=" + this.repoDto + ")";
        }
    }
}

