/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.readers;

import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.readers.Parsable;
import com.typesafe.config.Config;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.ConfigurationException;

public class ListReaders
extends Parsable
implements ConfigReader {
    List<ConfigReader> readersList = new LinkedList<ConfigReader>();

    public ListReaders() {
    }

    public ListReaders(ConfigReader configReader) {
        this.add(configReader);
    }

    public ListReaders(List<ConfigReader> configReaders) {
        this.addAll(configReaders);
    }

    public ListReaders addAll(List<ConfigReader> readers) {
        this.readersList.addAll(readers);
        this.applyOrder();
        return this;
    }

    public ListReaders add(ConfigReader configReader) {
        this.readersList.add(configReader);
        this.applyOrder();
        return this;
    }

    private void applyOrder() {
    }

    @Override
    Config toConfig() throws ConfigurationException {
        Config current = null;
        for (ConfigReader configSource : this.readersList) {
            Config base = ((Parsable)((Object)configSource)).toConfig();
            if (base == null) continue;
            current = Optional.ofNullable(current).map(arg_0 -> ((Config)base).withFallback(arg_0)).orElse(base);
        }
        return current;
    }

    @Override
    public String getName() {
        return this.readersList.stream().map(reader -> reader.getName().concat(" ")).collect(Collectors.toList()).toString();
    }
}

