/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider.readers;

import com.checkmarx.configprovider.dto.ResourceType;
import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.readers.AbstractFileReader;
import com.typesafe.config.Config;
import java.io.File;
import java.util.EnumSet;
import java.util.Optional;
import javax.naming.ConfigurationException;

public class FileReader
extends AbstractFileReader
implements ConfigReader {
    private File file;

    public FileReader(ResourceType type, String filepath) throws ConfigurationException {
        this.file = new File(filepath);
        if (!this.file.exists()) {
            throw new ConfigurationException("File not found: " + filepath);
        }
        this.type = type;
        if (!EnumSet.of(ResourceType.JSON, ResourceType.YAML).contains((Object)type)) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    Config toConfig() throws ConfigurationException {
        if (ResourceType.YAML.equals((Object)this.type)) {
            this.config = this.yamlToConfig(this.file);
        } else if (ResourceType.JSON.equals((Object)this.type)) {
            this.config = this.jsonToConfig(this.file);
        }
        return this.config;
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.file.getPath()).orElse(this.type.name());
    }

    public File getFile() {
        return this.file;
    }
}

