/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.configprovider;

import com.checkmarx.configprovider.dto.GeneralRepoDto;
import com.checkmarx.configprovider.dto.ProtocolType;
import com.checkmarx.configprovider.dto.ResourceType;
import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.readers.FileContentReader;
import com.checkmarx.configprovider.readers.Parsable;
import com.google.common.io.Files;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralGitDownloader {
    private Git git;
    private static Logger log = LoggerFactory.getLogger(GeneralGitDownloader.class);

    private String downloadRepoFilesAndGetPath(GeneralRepoDto repoDto) {
        log.debug(String.format("downloading configuration files from %s ,please wait ..", repoDto.getSrcUrl()));
        File temp = Files.createTempDir();
        CloneCommand cloneCommand = Git.cloneRepository().setBranch(repoDto.getSrcRef()).setURI(repoDto.getSrcUrl()).setDirectory(temp);
        if (ProtocolType.HTTP == repoDto.getProtocolType()) {
            if (StringUtils.isNotEmpty((CharSequence)repoDto.getSrcUserName()) && StringUtils.isNotEmpty((CharSequence)repoDto.getSrcPass())) {
                cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(repoDto.getSrcUserName(), repoDto.getSrcPass()));
            }
        } else {
            cloneCommand.setTransportConfigCallback((TransportConfigCallback)new SSHTransportSession(repoDto.getSrcPrivateKey()));
        }
        try {
            this.git = cloneCommand.call();
            if (log.isDebugEnabled()) {
                log.debug(String.format("clone complete into : %s", temp.getAbsolutePath()));
            }
        }
        catch (GitAPIException e) {
            this.closeAndDelete();
            log.warn("couldn't load config file from remote for the following reason");
            return "";
        }
        return temp.getAbsolutePath();
    }

    public Parsable loadFileByName(String workDirPath, String folder, String fileToFind, List<String> filenames) {
        return Optional.ofNullable(fileToFind).filter(filenames::contains).map(foundFile -> this.downloadFiles(workDirPath, folder, Collections.singletonList(foundFile)).get(0)).orElse(null);
    }

    public List<Parsable> downloadRepoFiles(GeneralRepoDto repo, List<String> folders, String nameToFind) {
        log.info("Searching for a config-as-code file in a remote repo");
        List<Parsable> resources = new LinkedList<Parsable>();
        String workDirPath = this.downloadRepoFilesAndGetPath(repo);
        if (workDirPath.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (folders.isEmpty() || folders.size() == 1 && "/".equals(folders.get(0))) {
            folders.clear();
            folders.add("");
        }
        for (String folder : folders) {
            List<String> filenames;
            Parsable specificFile = this.loadFileByName(workDirPath, folder, nameToFind, filenames = this.getDirectoryFilenames(workDirPath, folder));
            resources = Optional.ofNullable(specificFile).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.EMPTY_LIST);
            if (!resources.isEmpty() || filenames == null || filenames.isEmpty()) continue;
            resources = this.downloadFiles(workDirPath, folder, filenames);
        }
        List resourceNames = resources.stream().map(resource -> ((ConfigReader)((Object)resource)).getName().concat(" ")).collect(Collectors.toList());
        if (!resourceNames.isEmpty()) {
            String repoUrl = !repo.getSrcUrl().contains("@") ? repo.getSrcUrl() : repo.getSrcUrl().substring(repo.getSrcUrl().indexOf("@"));
            log.info("Config files " + resourceNames + "\nwere found for repo: " + repoUrl + " in folders: " + folders);
        }
        return resources;
    }

    private List<String> getDirectoryFilenames(String workDirPath, String folder) {
        String path = StringUtils.isNotBlank((CharSequence)folder) ? File.separator + folder : "";
        File workDir = new File(workDirPath + path);
        if (workDir.exists()) {
            return Stream.of(workDir.listFiles()).map(File::getName).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    private List<Parsable> downloadFiles(String workDirPath, String folder, List<String> filenames) {
        LinkedList<Parsable> resources = new LinkedList<Parsable>();
        if (filenames == null || filenames.isEmpty()) {
            throw new IllegalArgumentException("file names can not be empty");
        }
        filenames.stream().sorted().forEachOrdered(filename -> {
            try {
                String path = StringUtils.isNotBlank((CharSequence)folder) ? File.separator + folder : "";
                File file = new File(workDirPath + path + File.separator + filename);
                FileInputStream fileInputStream = new FileInputStream(file.getPath());
                String yamlContent = IOUtils.toString((InputStream)fileInputStream, (Charset)StandardCharsets.UTF_8);
                FileContentReader reader = new FileContentReader(yamlContent, (String)filename, ResourceType.YAML);
                resources.add(reader);
                fileInputStream.close();
                file.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return resources;
    }

    public void closeAndDelete() {
        if (this.git == null) {
            return;
        }
        File directory = this.git.getRepository().getWorkTree();
        this.git.close();
        this.delete(directory);
    }

    private void delete(File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            Stream.of(files).forEach(this::delete);
        }
        if (!directory.delete()) {
            log.warn(String.format("couldn't delete file %s", directory.getAbsolutePath()));
        }
    }

    private class SSHTransportSession
    implements TransportConfigCallback {
        private String privateKeyPath;

        public SSHTransportSession(String privateKeyPath) {
            this.privateKeyPath = privateKeyPath;
        }

        public void configure(Transport transport) {
            if (transport instanceof SshTransport) {
                JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                    protected void configure(OpenSshConfig.Host host, Session session) {
                        session.setConfig("StrictHostKeyChecking", "no");
                    }

                    protected JSch createDefaultJSch(FS fs) throws JSchException {
                        JSch jSch = super.createDefaultJSch(fs);
                        if (StringUtils.isNotEmpty((CharSequence)SSHTransportSession.this.privateKeyPath)) {
                            jSch.addIdentity(SSHTransportSession.this.privateKeyPath, "super-secret-passphrase".getBytes());
                        }
                        return jSch;
                    }
                };
                ((SshTransport)transport).setSshSessionFactory((SshSessionFactory)sshSessionFactory);
            }
        }
    }
}

