/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.redline_rpm.ChannelWrapper;
import org.redline_rpm.WritableChannelWrapper;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Signature;

public class SignatureGenerator {
    protected static final int SIGNATURE_SIZE = 287;
    protected final boolean enabled;
    protected AbstractHeader.Entry<byte[]> headerOnlyRSAEntry;
    protected AbstractHeader.Entry<byte[]> headerAndPayloadPGPEntry;
    protected final PGPPrivateKey privateKey;
    protected ChannelWrapper.Key<byte[]> headerOnlyKey = null;
    protected ChannelWrapper.Key<byte[]> headerAndPayloadKey = null;
    private Logger logger = Logger.getLogger(SignatureGenerator.class.getName());

    public SignatureGenerator(PGPPrivateKey privateKey) {
        this.privateKey = privateKey;
        this.enabled = privateKey != null;
    }

    public SignatureGenerator(File privateKeyRingFile, String privateKeyId, String privateKeyPassphrase) {
        if (privateKeyRingFile != null) {
            PGPSecretKeyRingCollection keyRings = this.readKeyRings(privateKeyRingFile);
            PGPSecretKey secretKey = this.findMatchingSecretKey(keyRings, privateKeyId);
            PGPPrivateKey key = null;
            try {
                key = this.extractPrivateKey(secretKey, privateKeyPassphrase);
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Private Key could not be extracted and therefore a signature will not be generated! " + e.getLocalizedMessage());
            }
            this.privateKey = key;
            this.enabled = key != null;
        } else {
            this.privateKey = null;
            this.enabled = false;
        }
    }

    public void prepare(Signature signature) {
        if (this.enabled) {
            this.headerOnlyRSAEntry = signature.addEntry(Signature.SignatureTag.RSAHEADER, 287);
            this.headerAndPayloadPGPEntry = signature.addEntry(Signature.SignatureTag.LEGACY_PGP, 287);
        }
    }

    public void startBeforeHeader(WritableChannelWrapper output) {
        if (this.enabled) {
            this.headerOnlyKey = output.start(this.privateKey, this.getAlgorithm());
            this.headerAndPayloadKey = output.start(this.privateKey, this.getAlgorithm());
        }
    }

    public void finishAfterHeader(WritableChannelWrapper output) {
        this.finishEntry(output, this.headerOnlyRSAEntry, this.headerOnlyKey);
    }

    public void finishAfterPayload(WritableChannelWrapper output) {
        this.finishEntry(output, this.headerAndPayloadPGPEntry, this.headerAndPayloadKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PGPSecretKeyRingCollection readKeyRings(File privateKeyRingFile) {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection;
        BufferedInputStream keyInputStream = new BufferedInputStream(new FileInputStream(privateKeyRingFile));
        InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)keyInputStream);
        try {
            pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        }
        catch (Throwable throwable) {
            try {
                decoderStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read key ring file: " + privateKeyRingFile, e);
            }
            catch (PGPException e) {
                throw new IllegalArgumentException("Could not extract key rings from: " + privateKeyRingFile, e);
            }
        }
        decoderStream.close();
        return pGPSecretKeyRingCollection;
    }

    protected PGPSecretKey findMatchingSecretKey(PGPSecretKeyRingCollection keyRings, String privateKeyId) {
        privateKeyId = privateKeyId != null ? privateKeyId.toLowerCase() : null;
        Iterator iter = keyRings.getKeyRings();
        while (iter.hasNext()) {
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)iter.next();
            Iterator keyIter = keyRing.getSecretKeys();
            while (keyIter.hasNext()) {
                PGPSecretKey key = (PGPSecretKey)keyIter.next();
                if (!key.isSigningKey() || !this.isMatchingKeyId(key, privateKeyId)) continue;
                return key;
            }
        }
        throw new IllegalArgumentException("Can't find signing key in key rings.");
    }

    protected boolean isMatchingKeyId(PGPSecretKey key, String privateKeyId) {
        if (privateKeyId == null) {
            return true;
        }
        return Long.toHexString(key.getKeyID()).endsWith(privateKeyId);
    }

    protected PGPPrivateKey extractPrivateKey(PGPSecretKey secretKey, String privateKeyPassphrase) {
        BcPBESecretKeyDecryptorBuilder secretKeyDecryptorBuilder = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider());
        try {
            PBESecretKeyDecryptor secretKeyDecryptor = secretKeyDecryptorBuilder.build(privateKeyPassphrase.toCharArray());
            return secretKey.extractPrivateKey(secretKeyDecryptor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not extract private key from key ring", e);
        }
    }

    protected void finishEntry(WritableChannelWrapper output, AbstractHeader.Entry<byte[]> entry, ChannelWrapper.Key<byte[]> key) {
        if (this.enabled) {
            this.checkKey(key);
            this.checkEntry(entry);
            entry.setValues(output.finish(key));
        }
    }

    protected void checkEntry(AbstractHeader.Entry<byte[]> entry) {
        if (entry == null) {
            throw new IllegalStateException("Entry not initialized. Please call prepare() first");
        }
    }

    protected void checkKey(ChannelWrapper.Key<byte[]> key) {
        if (key == null) {
            throw new IllegalStateException("Key is not initialized. Please call startBeforeHeader() first.");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected int getAlgorithm() {
        return this.privateKey != null ? this.privateKey.getPublicKeyPacket().getAlgorithm() : 0;
    }
}

