/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.cli.utils;

import com.cx.plugin.cli.exceptions.CLIParsingException;
import com.cx.plugin.cli.utils.PropertiesManager;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.RemoteSourceTypes;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ScanSourceConfigurator {
    private static final String SVN_DEFAULT_PORT = "80";
    private static final String PERFORCE_DEFAULT_PORT = "1666";
    private static final String TFS_DEFAULT_PORT = "8080";
    private String LOCATION_PATH_EXCEPTION = "[CxConsole] locationPath parameter needs to be specified when using [%s] as locationType";
    private String LOCATION_USER_EXCEPTION = "[CxConsole] locationUser parameter needs to be specified when using [%s] as locationType";
    private String LOCATION_PASSWORD_EXCEPTION = "[CxConsole] locationPassword parameter needs to be specified when using [%s] as locationType";
    private String LOCATION_URL_EXCEPTION = "[CxConsole] locationURL parameter needs to be specified when using [%s] as locationType";
    private String INVALID_PORT_EXCEPTION = "[CxConsole] Invalid port specified: [%s]";
    private static final Logger log = LogManager.getLogger(ScanSourceConfigurator.class);
    private CxScanConfig scanConfig;

    ScanSourceConfigurator() {
    }

    void configureSourceLocation(CommandLine commandLine, PropertiesManager props, CxScanConfig target) throws CLIParsingException {
        this.scanConfig = target;
        String locationType = commandLine.getOptionValue("locationtype");
        if (locationType == null) {
            throw new CLIParsingException("[CxConsole] No location type parameter was specified, needs to be specified using -LocationType <folder/shared/tfs/svn/perforce/git>");
        }
        String locationPath = commandLine.getOptionValue("locationpath");
        String locationURL = commandLine.getOptionValue("locationurl");
        String locationBranch = commandLine.getOptionValue("locationbranch");
        String locationUser = commandLine.getOptionValue("locationuser");
        String locationPass = commandLine.getOptionValue("locationpassword");
        String workspaceMode = commandLine.getOptionValue("workspacemode");
        String locationPort = commandLine.getOptionValue("locationport");
        switch (locationType.toLowerCase()) {
            case "folder": {
                this.setLocalSourceLocation(locationPath, props);
                break;
            }
            case "zip": {
                this.setLocalZipSourceLocation(locationPath, props);
                break;
            }
            case "shared": {
                this.setSharedSourceLocation(locationPath, locationUser, locationPass);
                break;
            }
            case "svn": {
                if (commandLine.getOptionValue("locationprivatekey") != null) {
                    this.setPrivateKey(commandLine.getOptionValue("locationprivatekey"));
                }
                this.setSVNSourceLocation(locationURL, locationPath, locationUser, locationPass, locationPort);
                break;
            }
            case "tfs": {
                this.setTFSSourceLocation(locationURL, locationPath, locationUser, locationPass, locationPort);
                break;
            }
            case "perforce": {
                this.setPerforceSourceLocation(locationURL, locationPath, locationUser, locationPass, locationPort, workspaceMode);
                break;
            }
            case "git": {
                if (commandLine.getOptionValue("locationprivatekey") != null) {
                    this.setPrivateKey(commandLine.getOptionValue("locationprivatekey"));
                }
                this.setGITSourceLocation(locationURL, locationBranch, locationUser, locationPass, locationPort);
                break;
            }
            default: {
                throw new CLIParsingException(String.format("[CxConsole] location type must be one of [folder, shared (network location), SVN, TFS, Perforce, GIT] but was %s", locationType));
            }
        }
    }

    private void setLocalZipSourceLocation(String locationPath, PropertiesManager props) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)locationPath)) {
            throw new CLIParsingException(String.format(this.LOCATION_PATH_EXCEPTION, "zip"));
        }
        File zipFile = new File(locationPath);
        if (!zipFile.exists()) {
            throw new CLIParsingException(String.format("[CxConsole] Zip file does not exist: %s", locationPath));
        }
        if (!zipFile.isFile()) {
            throw new CLIParsingException(String.format("[CxConsole] Location path must be a file for zip type, not a directory: %s", locationPath));
        }
        if (!locationPath.toLowerCase().endsWith(".zip")) {
            throw new CLIParsingException(String.format("[CxConsole] File must have .zip extension: %s", locationPath));
        }
        this.scanConfig.setZipFile(zipFile);
        this.scanConfig.setMaxZipSize(props.getIntProperty("scan.zip.max_size"));
    }

    private void setLocalSourceLocation(String locationPath, PropertiesManager props) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)locationPath)) {
            throw new CLIParsingException(String.format(this.LOCATION_PATH_EXCEPTION, "folder"));
        }
        this.scanConfig.setSourceDir(locationPath);
        this.scanConfig.setMaxZipSize(props.getIntProperty("scan.zip.max_size"));
    }

    private void setSharedSourceLocation(String locationPath, String locationUser, String locationPass) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)locationPath)) {
            throw new CLIParsingException(String.format(this.LOCATION_PATH_EXCEPTION, RemoteSourceTypes.SHARED.value()));
        }
        if (Strings.isNullOrEmpty((String)locationUser)) {
            throw new CLIParsingException(String.format(this.LOCATION_USER_EXCEPTION, RemoteSourceTypes.SHARED.value()));
        }
        if (locationPass == null) {
            throw new CLIParsingException(String.format(this.LOCATION_PASSWORD_EXCEPTION, RemoteSourceTypes.SHARED.value()));
        }
        this.scanConfig.setRemoteSrcUser(locationUser);
        this.scanConfig.setRemoteSrcPass(locationPass);
        this.scanConfig.setSourceDir(locationPath);
        this.scanConfig.setPaths(locationPath.split(";"));
        this.scanConfig.setRemoteType(RemoteSourceTypes.SHARED);
    }

    private void setSVNSourceLocation(String locationURL, String locationPath, String locationUser, String locationPass, String locationPort) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)locationPath)) {
            throw new CLIParsingException(String.format(this.LOCATION_PATH_EXCEPTION, RemoteSourceTypes.SVN.value()));
        }
        if (Strings.isNullOrEmpty((String)locationURL)) {
            throw new CLIParsingException(String.format(this.LOCATION_URL_EXCEPTION, RemoteSourceTypes.SVN.value()));
        }
        this.scanConfig.setRemoteSrcUser(locationUser);
        this.scanConfig.setRemoteSrcPass(String.valueOf(locationPass));
        this.scanConfig.setRemoteType(RemoteSourceTypes.SVN);
        this.scanConfig.setSourceDir(locationPath);
        this.scanConfig.setPaths(locationPath.split(";"));
        this.scanConfig.setRemoteSrcUrl(locationURL);
        if (Strings.isNullOrEmpty((String)locationPort)) {
            log.info("[CxConsole] No port was specified for SVN, using port {} as default", (Object)SVN_DEFAULT_PORT);
            locationPort = SVN_DEFAULT_PORT;
        }
        try {
            this.scanConfig.setRemoteSrcPort(Integer.parseInt(locationPort));
        }
        catch (NumberFormatException e) {
            throw new CLIParsingException(String.format(this.INVALID_PORT_EXCEPTION, locationPort), e);
        }
    }

    private void setTFSSourceLocation(String locationURL, String locationPath, String locationUser, String locationPass, String locationPort) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)locationPath)) {
            throw new CLIParsingException(String.format(this.LOCATION_PATH_EXCEPTION, RemoteSourceTypes.TFS.value()));
        }
        if (Strings.isNullOrEmpty((String)locationURL)) {
            throw new CLIParsingException(String.format(this.LOCATION_URL_EXCEPTION, RemoteSourceTypes.TFS.value()));
        }
        if (Strings.isNullOrEmpty((String)locationUser)) {
            throw new CLIParsingException(String.format(this.LOCATION_USER_EXCEPTION, RemoteSourceTypes.TFS.value()));
        }
        if (locationPass == null) {
            throw new CLIParsingException(String.format(this.LOCATION_PASSWORD_EXCEPTION, RemoteSourceTypes.TFS.value()));
        }
        this.scanConfig.setRemoteSrcUser(locationUser);
        this.scanConfig.setRemoteSrcPass(locationPass);
        this.scanConfig.setRemoteType(RemoteSourceTypes.TFS);
        this.scanConfig.setSourceDir(locationPath);
        this.scanConfig.setPaths(locationPath.split(";"));
        this.scanConfig.setRemoteSrcUrl(locationURL);
        if (Strings.isNullOrEmpty((String)locationPort)) {
            log.info("[CxConsole] No port was specified for TFS, using port {} as default", (Object)TFS_DEFAULT_PORT);
            locationPort = TFS_DEFAULT_PORT;
        }
        try {
            this.scanConfig.setRemoteSrcPort(Integer.parseInt(locationPort));
        }
        catch (NumberFormatException e) {
            throw new CLIParsingException(String.format(this.INVALID_PORT_EXCEPTION, locationPort), e);
        }
    }

    private void setPerforceSourceLocation(String locationURL, String locationPath, String locationUser, String locationPass, String locationPort, String workspaceMode) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)locationPath)) {
            throw new CLIParsingException(String.format(this.LOCATION_PATH_EXCEPTION, RemoteSourceTypes.PERFORCE.value()));
        }
        if (Strings.isNullOrEmpty((String)locationURL)) {
            throw new CLIParsingException(String.format(this.LOCATION_URL_EXCEPTION, RemoteSourceTypes.PERFORCE.value()));
        }
        if (Strings.isNullOrEmpty((String)locationUser)) {
            throw new CLIParsingException(String.format(this.LOCATION_USER_EXCEPTION, RemoteSourceTypes.PERFORCE.value()));
        }
        if (locationPass == null) {
            throw new CLIParsingException(String.format(this.LOCATION_PASSWORD_EXCEPTION, RemoteSourceTypes.PERFORCE.value()));
        }
        this.scanConfig.setRemoteSrcUser(locationUser);
        this.scanConfig.setRemoteSrcPass(locationPass);
        this.scanConfig.setSourceDir(locationPath);
        this.scanConfig.setPaths(locationPath.split(";"));
        this.scanConfig.setRemoteSrcUrl(locationURL);
        this.scanConfig.setRemoteType(RemoteSourceTypes.PERFORCE);
        this.scanConfig.setPerforceMode(workspaceMode);
        if (Strings.isNullOrEmpty((String)locationPort)) {
            log.info("[CxConsole] No port was specified for perforce, using port {} as default", (Object)PERFORCE_DEFAULT_PORT);
            locationPort = PERFORCE_DEFAULT_PORT;
        }
        try {
            this.scanConfig.setRemoteSrcPort(Integer.parseInt(locationPort));
        }
        catch (NumberFormatException e) {
            throw new CLIParsingException(String.format(this.INVALID_PORT_EXCEPTION, locationPort), e);
        }
    }

    private void setGITSourceLocation(String locationURL, String locationBranch, String locationUser, String locationPass, String locationPort) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)locationURL)) {
            throw new CLIParsingException(String.format("[CxConsole] locationURL parameter needs to be specified when using [%s] as a locationType", RemoteSourceTypes.GIT.value()));
        }
        if (Strings.isNullOrEmpty((String)locationBranch)) {
            throw new CLIParsingException(String.format("[CxConsole] locationBranch parameter needs to be specified when using [%s] as a locationType", RemoteSourceTypes.GIT.value()));
        }
        this.scanConfig.setRemoteSrcUser(locationUser);
        this.scanConfig.setRemoteSrcPass(String.valueOf(locationPass));
        this.scanConfig.setRemoteType(RemoteSourceTypes.GIT);
        this.scanConfig.setRemoteSrcUrl(locationURL);
        this.scanConfig.setRemoteSrcBranch(locationBranch);
        try {
            if (!Strings.isNullOrEmpty((String)locationPort)) {
                this.scanConfig.setRemoteSrcPort(Integer.parseInt(locationPort));
            }
        }
        catch (NumberFormatException e) {
            throw new CLIParsingException(String.format(this.INVALID_PORT_EXCEPTION, locationPort), e);
        }
    }

    private void setPrivateKey(String pathToKey) throws CLIParsingException {
        byte[] keyFile;
        File resultFile = new File(pathToKey);
        if (!resultFile.isAbsolute()) {
            String path = System.getProperty("user.dir");
            pathToKey = path + File.separator + pathToKey;
        }
        try {
            FileInputStream inputStream = new FileInputStream(new File(pathToKey));
            keyFile = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new CLIParsingException("[CxConsole] Failed retrieving key from specified file:\n " + e.getMessage(), e);
        }
        this.scanConfig.setRemoteSrcKeyFile(keyFile);
    }
}

