/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.cli.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertiesManager {
    private static Logger log = LogManager.getLogger(PropertiesManager.class);
    public static final String KEY_PROGRESS_INTERVAL = "scan.job.progress.interval";
    public static final String KEY_OSA_PROGRESS_INTERVAL = "scan.osa.job.progress.interval";
    public static final String KEY_RETRIES = "scan.job.connection.retries";
    public static final String REPORT_TIMEOUT = "scan.job.report.timeout";
    public static final String KEY_EXCLUDED_FOLDERS = "scan.zip.ignored.folders";
    public static final String KEY_EXCLUDED_FILES = "scan.zip.ignored.files";
    public static final String KEY_OSA_INCLUDED_FILES = "scan.osa.include.files";
    public static final String KEY_OSA_EXCLUDED_FILES = "scan.osa.exclude.files";
    public static final String KEY_OSA_EXTRACTABLE_INCLUDE_FILES = "scan.osa.extractable.include.files";
    public static final String KEY_OSA_SCAN_DEPTH = "scan.osa.extractable.depth";
    public static final String KEY_MAX_ZIP_SIZE = "scan.zip.max_size";
    public static final String KEY_DEF_PROJECT_NAME = "scan.default.projectname";
    public static final String KEY_VERSION = "cxconsole.version";
    public static final String KEY_USE_KERBEROS_AUTH = "use_kerberos_authentication";
    public static final String KEY_KERBEROS_USERNAME = "kerberos.username";
    static final String KEY_SCA_API_URL = "scan.sca.api.url";
    static final String KEY_SCA_ACCESS_CONTROL_URL = "scan.sca.accesscontrol.url";
    static final String KEY_SCA_WEB_APP_URL = "scan.sca.webapp.url";
    static final String KEY_SCA_INCLUDED_FILES = "scan.sca.include.files";
    static final String KEY_SCA_EXCLUDED_FILES = "scan.sca.exclude.files";
    static final String KEY_SCA_PROGRESS_INTERVAL = "scan.sca.job.progress.interval";
    static final String KEY_CUSTOM_TRUSTSTORE = "trustStore";
    static final String KEY_CUSTOM_TRUSTSTORE_PASSWORD = "trustStorePassword";
    public static final String KEY_DEFAULT_PRESETNAME = "scan.sast.preset.name";
    public static final String KEY_DEFAULT_ENGINE_CONFIGURATIONNAME = "scan.sast.engineconfiguration.name";
    private final String SEPARATOR = FileSystems.getDefault().getSeparator();
    private String userDir = System.getProperty("user.dir");
    private String configDirRelativePath = "config";
    private String configFile = "cx_console.properties";
    private String defaultPath = this.userDir + this.SEPARATOR + this.configDirRelativePath + this.SEPARATOR + this.configFile;
    private Properties applicationProperties;
    private static PropertiesManager props;

    private PropertiesManager() {
    }

    private PropertiesManager(String defConfig) {
        this.applicationProperties = new Properties();
        this.loadProperties(defConfig);
    }

    public static PropertiesManager getProps(String configFilePath) {
        return props == null ? new PropertiesManager(configFilePath) : props;
    }

    private void loadProperties(String confPath) {
        try {
            if (confPath != null && this.loadFromConfigParam(confPath)) {
                log.info("Config file location: {}", (Object)confPath);
                return;
            }
            if (!this.loadConfigFromFile(this.defaultPath) || this.applicationProperties.isEmpty()) {
                log.warn("Error occurred during loading configuration file. Default configuration values will be loaded.");
                this.loadDefaults();
            }
            log.info("Default configuration file location: {}", (Object)this.defaultPath);
        }
        catch (Exception ex) {
            log.warn("Error occurred during loading configuration file.", (Throwable)ex);
        }
    }

    private boolean loadFromConfigParam(String confPath) {
        try {
            confPath = Paths.get(confPath, new String[0]).toFile().getCanonicalPath();
        }
        catch (Exception ex) {
            log.warn("Error occurred during loading configuration file. The Config path is invalid.");
            return false;
        }
        return this.loadConfigFromFile(confPath);
    }

    private boolean loadConfigFromFile(String path) {
        boolean ret = false;
        if (new File(path).exists()) {
            try (FileInputStream in = new FileInputStream(path);){
                this.applicationProperties.load(in);
                ret = true;
            }
            catch (Exception e) {
                log.error("Error occurred during loading CxConsole properties.");
            }
        } else {
            log.error("The specified configuration path: [ {} ] does not exist.", (Object)path);
        }
        return ret;
    }

    private void loadDefaults() {
        this.applicationProperties.put(REPORT_TIMEOUT, "30");
        this.applicationProperties.put(KEY_PROGRESS_INTERVAL, "10");
        this.applicationProperties.put(KEY_OSA_PROGRESS_INTERVAL, "4");
        this.applicationProperties.put(KEY_RETRIES, "3");
        this.applicationProperties.put(KEY_EXCLUDED_FOLDERS, "_cvs, .svn, .hg, .git, .bzr, bin, obj, backup, node_modules");
        this.applicationProperties.put(KEY_EXCLUDED_FILES, "!**/*.DS_Store, !**/*.ipr, !**/*.iws, !**/*.bak, !**/*.tmp, !**/*.aac, !**/*.aif, !**/*.iff, !**/*.m3u, !**/*.mid, !**/*.mp3, !**/*.mpa, !**/*.ra, !**/*.wav, !**/*.wma, !**/*.3g2, !**/*.3gp, !**/*.asf, !**/*.asx, !**/*.avi, !**/*.flv, !**/*.mov, !**/*.mp4, !**/*.mpg, !**/*.rm, !**/*.swf, !**/*.vob, !**/*.wmv, !**/*.bmp, !**/*.gif, !**/*.jpg, !**/*.png, !**/*.psd, !**/*.tif, !**/*.jar, !**/*.zip, !**/*.rar, !**/*.exe, !**/*.dll, !**/*.pdb, !**/*.7z, !**/*.gz, !**/*.tar.gz, !**/*.tar, !**/*.ahtm, !**/*.ahtml, !**/*.fhtml, !**/*.hdm, !**/*.hdml, !**/*.hsql, !**/*.ht, !**/*.hta, !**/*.htc, !**/*.htd, !**/*.htmls, !**/*.ihtml, !**/*.mht, !**/*.mhtm, !**/*.mhtml, !**/*.ssi, !**/*.stm, !**/*.stml, !**/*.ttml, !**/*.txn, !**/*.class, !**/*.iml, !Checkmarx/Reports/*.*");
        this.applicationProperties.put(KEY_MAX_ZIP_SIZE, "200");
        this.applicationProperties.put(KEY_DEF_PROJECT_NAME, "console.project");
        this.applicationProperties.put(KEY_OSA_INCLUDED_FILES, "**/**");
        this.applicationProperties.put(KEY_OSA_EXCLUDED_FILES, "");
        this.applicationProperties.put(KEY_OSA_EXTRACTABLE_INCLUDE_FILES, "*.zip, *.war, *.ear, *.tgz");
        this.applicationProperties.put(KEY_OSA_SCAN_DEPTH, "4");
        this.applicationProperties.put(KEY_USE_KERBEROS_AUTH, "false");
        this.applicationProperties.put(KEY_SCA_API_URL, "https://api-sca.checkmarx.net");
        this.applicationProperties.put(KEY_SCA_ACCESS_CONTROL_URL, "https://platform.checkmarx.net");
        this.applicationProperties.put(KEY_SCA_WEB_APP_URL, "https://sca.checkmarx.net");
        File propsFile = new File(this.defaultPath);
        if (!propsFile.exists()) {
            File configDir = new File(this.userDir + this.SEPARATOR + this.configDirRelativePath);
            if (!configDir.exists()) {
                configDir.mkdir();
            }
            try (FileOutputStream fOut = new FileOutputStream(propsFile);){
                this.applicationProperties.store(fOut, "");
            }
            catch (IOException e) {
                log.warn("Cannot create configuration file");
            }
        }
    }

    public String getProperty(String key) {
        Object value = this.applicationProperties.get(key);
        return value == null ? null : value.toString();
    }

    public Integer getIntProperty(String key) {
        Object value = this.applicationProperties.get(key);
        Integer intValue = null;
        if (value != null) {
            try {
                intValue = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                log.warn("Can't parse string to int value: {}", (Object)e.getMessage());
            }
        }
        return intValue;
    }

    public Long getLongProperty(String key) {
        Object value = this.applicationProperties.get(key);
        Long longValue = null;
        if (value != null) {
            try {
                longValue = Long.parseLong(value.toString());
            }
            catch (NumberFormatException e) {
                log.warn("Can't parse string to long value: {}", (Object)e.getMessage());
            }
        }
        return longValue;
    }
}

