/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.cli.utils;

import com.cx.plugin.cli.errorsconstants.Errors;
import com.cx.restclient.dto.scansummary.ErrorSource;
import com.cx.restclient.dto.scansummary.ScanSummary;
import com.cx.restclient.dto.scansummary.ThresholdError;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.whitesource.agent.utils.CommandLineErrors;

public class ErrorParsingHelper {
    private static Map<String, Integer> errorMsgToCodeMap = ErrorParsingHelper.createMessageToCodeMap();

    private ErrorParsingHelper() {
        throw new IllegalStateException("Utility class");
    }

    private static Map<String, Integer> createMessageToCodeMap() {
        HashMap<String, Integer> messageToCodeMap = new HashMap<String, Integer>();
        messageToCodeMap.put("Login Failed", Errors.LOGIN_FAILED_ERROR.getCode());
        messageToCodeMap.put("Unsuccessful login", Errors.LOGIN_FAILED_ERROR.getCode());
        messageToCodeMap.put("Fail to login with credentials: Fail to authenticate: status code: HTTP/1.1 403 Forbidden.", Errors.LOGIN_FAILED_ERROR.getCode());
        messageToCodeMap.put("User authentication failed", Errors.LOGIN_FAILED_ERROR.getCode());
        messageToCodeMap.put("Failed to generate access token from refresh token", Errors.LOGIN_FAILED_ERROR.getCode());
        messageToCodeMap.put("invalid_username_or_password", Errors.LOGIN_FAILED_ERROR.getCode());
        messageToCodeMap.put("This feature is available only on SDLC edition", Errors.SDLC_ERROR.getCode());
        messageToCodeMap.put("Open Source Analysis License is not enabled for this project.Please contact your CxSAST Administrator", Errors.NO_OSA_LICENSE_ERROR.getCode());
        messageToCodeMap.put("Failed to resolve dependencies for OSA scan:", Errors.OSA_RESOLVE_ERROR.getCode());
        messageToCodeMap.put("No dependencies found for OSA scan", Errors.OSA_NO_DEPENDENCIES_ERROR.getCode());
        messageToCodeMap.put("OSA scan requires an existing project on the server", Errors.NO_PROJECT_PRIOR_TO_OSA_SCAN_ERROR.getCode());
        messageToCodeMap.put("Asynchronous run does not allow report creation. Please remove the report parameters and run again", Errors.GENERAL_ERROR.getCode());
        messageToCodeMap.put("Asynchronous run does not support threshold. Please remove the threshold parameters and run again", Errors.GENERAL_ERROR.getCode());
        messageToCodeMap.put("SAST and OSA vulnerabilities threshold exceeded", Errors.GENERIC_THRESHOLD_FAILURE_ERROR.getCode());
        messageToCodeMap.put("OSA high vulnerability threshold exceeded", Errors.OSA_HIGH_THRESHOLD_ERROR.getCode());
        messageToCodeMap.put("OSA medium vulnerability threshold exceeded", Errors.OSA_MEDIUM_THRESHOLD_ERROR.getCode());
        messageToCodeMap.put("OSA low vulnerability threshold exceeded", Errors.OSA_LOW_THRESHOLD_ERROR.getCode());
        messageToCodeMap.put("SAST critical vulnerability threshold exceeded", Errors.SAST_CRITICAL_THRESHOLD_ERROR.getCode());
        messageToCodeMap.put("SAST high vulnerability threshold exceeded", Errors.SAST_HIGH_THRESHOLD_ERROR.getCode());
        messageToCodeMap.put("SAST medium vulnerability threshold exceeded", Errors.SAST_MEDIUM_THRESHOLD_ERROR.getCode());
        messageToCodeMap.put("SAST low vulnerability threshold exceeded", Errors.SAST_LOW_THRESHOLD_ERROR.getCode());
        messageToCodeMap.put("Failed to resolve Maven dependencies for OSA scan", Errors.OSA_MAVEN_RESOLVE_ERROR.getCode());
        messageToCodeMap.put("Failed to resolve Gradle dependencies for OSA scan", Errors.OSA_GRADLE_RESOLVE_ERROR.getCode());
        messageToCodeMap.put("Failed to resolve NPM dependencies for OSA scan", Errors.OSA_NPM_RESOLVE_ERROR.getCode());
        messageToCodeMap.put("Failed to resolve Nuget/DotNet dependencies for OSA scan", Errors.OSA_NUGET_RESOLVE_ERROR.getCode());
        return messageToCodeMap;
    }

    public static Errors getErrorType(ScanSummary scanSummary) {
        if (scanSummary.isPolicyViolated()) {
            return Errors.POLICY_VIOLATION_ERROR;
        }
        ThresholdError sastMostSevere = ErrorParsingHelper.getMostSevereThresholdError(scanSummary, ErrorSource.SAST);
        ThresholdError osaMostSevere = ErrorParsingHelper.getMostSevereThresholdError(scanSummary, ErrorSource.OSA);
        ThresholdError scaMostSevere = ErrorParsingHelper.getMostSevereThresholdError(scanSummary, ErrorSource.SCA);
        if (sastMostSevere != null && (osaMostSevere != null || scaMostSevere != null)) {
            return Errors.GENERIC_THRESHOLD_FAILURE_ERROR;
        }
        if (sastMostSevere == null && osaMostSevere == null && scaMostSevere == null) {
            return Errors.SCAN_SUCCEEDED;
        }
        if (sastMostSevere != null) {
            return ErrorParsingHelper.toThresholdErrorCode(sastMostSevere);
        }
        return ErrorParsingHelper.toThresholdErrorCode(osaMostSevere != null ? osaMostSevere : scaMostSevere);
    }

    private static Errors toThresholdErrorCode(ThresholdError error) {
        if (error.getSource() == ErrorSource.SAST) {
            switch (error.getSeverity()) {
                case CRITICAL: {
                    return Errors.SAST_CRITICAL_THRESHOLD_ERROR;
                }
                case HIGH: {
                    return Errors.SAST_HIGH_THRESHOLD_ERROR;
                }
                case MEDIUM: {
                    return Errors.SAST_MEDIUM_THRESHOLD_ERROR;
                }
            }
            return Errors.SAST_LOW_THRESHOLD_ERROR;
        }
        switch (error.getSeverity()) {
            case HIGH: {
                return Errors.OSA_HIGH_THRESHOLD_ERROR;
            }
            case MEDIUM: {
                return Errors.OSA_MEDIUM_THRESHOLD_ERROR;
            }
        }
        return Errors.OSA_LOW_THRESHOLD_ERROR;
    }

    private static ThresholdError getMostSevereThresholdError(ScanSummary scanSummary, ErrorSource source) {
        return scanSummary.getThresholdErrors().stream().filter(error -> error.getSource() == source).max(Comparator.comparing(ThresholdError::getSeverity)).orElse(null);
    }

    public static int parseError(String errorMsg) {
        if (errorMsg == null) {
            return Errors.GENERAL_ERROR.getCode();
        }
        if (StringUtils.containsIgnoreCase((CharSequence)errorMsg, (CharSequence)"Failed to resolve dependencies for OSA scan:")) {
            Set failedResolver = CommandLineErrors.getFailedResolver();
            if (failedResolver.size() > 1) {
                return Errors.OSA_RESOLVE_ERROR.getCode();
            }
            String resolver = (String)failedResolver.iterator().next();
            if (resolver.equalsIgnoreCase("Maven")) {
                return Errors.OSA_MAVEN_RESOLVE_ERROR.getCode();
            }
            if (resolver.equalsIgnoreCase("Gradle")) {
                return Errors.OSA_GRADLE_RESOLVE_ERROR.getCode();
            }
            if (resolver.equalsIgnoreCase("NPM")) {
                return Errors.OSA_NPM_RESOLVE_ERROR.getCode();
            }
            if (resolver.equalsIgnoreCase("DotNet") || resolver.equalsIgnoreCase("Nuget")) {
                return Errors.OSA_NUGET_RESOLVE_ERROR.getCode();
            }
            return Errors.OSA_RESOLVE_ERROR.getCode();
        }
        for (Map.Entry<String, Integer> entry : errorMsgToCodeMap.entrySet()) {
            if (!StringUtils.containsIgnoreCase((CharSequence)errorMsg, (CharSequence)entry.getKey())) continue;
            return entry.getValue();
        }
        return Errors.GENERAL_ERROR.getCode();
    }
}

