/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.cli.utils;

import com.checkmarx.configprovider.ConfigProvider;
import com.checkmarx.configprovider.dto.GeneralRepoDto;
import com.checkmarx.configprovider.dto.ProtocolType;
import com.checkmarx.configprovider.dto.ResourceType;
import com.checkmarx.configprovider.dto.interfaces.ConfigReader;
import com.checkmarx.configprovider.readers.FileReader;
import com.checkmarx.configprovider.readers.GeneralGitReader;
import com.cx.plugin.cli.configascode.ConfigAsCode;
import com.cx.plugin.cli.configascode.ProjectConfig;
import com.cx.plugin.cli.configascode.SastConfig;
import com.cx.plugin.cli.configascode.ScaConfig;
import com.cx.plugin.cli.constants.Command;
import com.cx.plugin.cli.exceptions.BadOptionCombinationException;
import com.cx.plugin.cli.exceptions.CLIParsingException;
import com.cx.plugin.cli.utils.PropertiesManager;
import com.cx.plugin.cli.utils.ScanSourceConfigurator;
import com.cx.restclient.ast.dto.sca.AstScaConfig;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ProxyConfig;
import com.cx.restclient.dto.RemoteSourceTypes;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.SourceLocationType;
import com.cx.restclient.sca.utils.CxSCAFileSystemUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.naming.ConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.transport.URIish;
import org.whitesource.agent.api.model.AgentProjectInfo;

public final class CxConfigHelper {
    public static final String EMPTY_JSON = "EMPTY_JSON";
    private static final String CONFIG_AS_CODE_FILE_NAME = "cx.config";
    public static final String CONFIG_FILE_S_NOT_FOUND_OR_COULDN_T_BE_LOADED = "Config file %s not found or couldn't be loaded,please check if file exist's and if file content is valid";
    private static Logger log = LogManager.getLogger(CxConfigHelper.class);
    private static final String DEFAULT_PRESET_NAME = "Project Default";
    private static final String ENGINE_CONFIGURATION_DEFAULT = "Project Default";
    private static final String ENGINE_CONFIGURATION_DEFAULT_ID = "0";
    private static PropertiesManager props;
    private Command command;
    private CommandLine commandLine;
    private int fullScanCycle;
    public static final int FULL_SCAN_CYCLE_MIN = 1;
    public static final int FULL_SCAN_CYCLE_MAX = 99;

    public CxConfigHelper(String configFilePath) {
        props = PropertiesManager.getProps(configFilePath);
    }

    public CxScanConfig resolveConfiguration(Command command, CommandLine cmd) throws CLIParsingException, IOException, ConfigurationException {
        boolean isFullScan;
        this.command = command;
        this.commandLine = cmd;
        this.checkForAmbiguousArgs();
        this.setSystemProperties();
        CxScanConfig scanConfig = new CxScanConfig();
        if (this.testConnection(scanConfig)) {
            return scanConfig;
        }
        ProxyConfig proxyConfig = this.genProxyConfig();
        if (proxyConfig != null) {
            scanConfig.setProxy(true);
            scanConfig.setScaProxy(true);
            scanConfig.setProxyConfig(proxyConfig);
            scanConfig.setScaProxyConfig(proxyConfig);
            log.info("Proxy configuration have been provided");
        }
        scanConfig.setNTLM(cmd.hasOption("ntlm"));
        if (command.equals((Object)Command.SCAN) || command.equals((Object)Command.ASYNC_SCAN)) {
            scanConfig.setSastEnabled(true);
            scanConfig.addScannerType(ScannerType.SAST);
        }
        scanConfig.setSynchronous(command.equals((Object)Command.SCAN) || command.equals((Object)Command.OSA_SCAN) || command.equals((Object)Command.SCA_SCAN));
        ScannerType scannerType = this.getDependencyScannerType();
        if (scannerType != null) {
            scanConfig.addScannerType(scannerType);
        }
        scanConfig.setCxOrigin("cx-CLI");
        scanConfig.setPluginVersion(CxConfigHelper.class.getPackage().getImplementationVersion());
        if (scanConfig.isSastOrOSAEnabled() || command.equals((Object)Command.GENERATE_TOKEN) || command.equals((Object)Command.REVOKE_TOKEN)) {
            scanConfig.setUrl(this.getSastOrOsaServerUrl());
            this.setSastOrOsaCredentials(scanConfig);
        }
        if (command.equals((Object)Command.GENERATE_TOKEN) || command.equals((Object)Command.REVOKE_TOKEN)) {
            return scanConfig;
        }
        scanConfig.setEngineConfigurationId(null);
        scanConfig.setEngineConfigurationName(null);
        String suppliedEngineConfigurationName = cmd.getOptionValue("configuration");
        if (suppliedEngineConfigurationName == null || suppliedEngineConfigurationName.isEmpty()) {
            suppliedEngineConfigurationName = props.getProperty("scan.sast.engineconfiguration.name");
        }
        log.info("Engine configuration (source encoding): " + suppliedEngineConfigurationName);
        if (!suppliedEngineConfigurationName.equalsIgnoreCase("Project Default")) {
            scanConfig.setEngineConfigurationName(suppliedEngineConfigurationName);
        } else {
            scanConfig.setEngineConfigurationId(Integer.parseInt(ENGINE_CONFIGURATION_DEFAULT_ID));
        }
        if (cmd.hasOption("customfields")) {
            scanConfig.setCustomFields(this.apiFormat(cmd.getOptionValue("customfields")));
        }
        scanConfig.setUseSSOLogin(cmd.hasOption("usesso"));
        scanConfig.setDisableCertificateValidation(cmd.hasOption("trustedcertificates"));
        scanConfig.setPublic(!cmd.hasOption("private"));
        if (cmd.hasOption("enablesca") || command.equals((Object)Command.SCA_SCAN)) {
            scanConfig.setEnablePolicyViolationsSCA(cmd.hasOption("checkpolicy"));
        }
        if (scanConfig.isSastEnabled() || command.equals((Object)Command.OSA_SCAN) || cmd.hasOption("enableosa")) {
            scanConfig.setEnablePolicyViolations(cmd.hasOption("checkpolicy"));
        }
        if (!this.commandLine.hasOption("configascode")) {
            if (command.equals((Object)Command.SCA_SCAN) || command.equals((Object)Command.ASYNC_SCA_SCAN)) {
                scanConfig.setProjectName(CxConfigHelper.extractProjectName(cmd.getOptionValue("projectname"), true));
                scanConfig.setTeamPath(CxConfigHelper.extractTeamPath(cmd.getOptionValue("projectname"), true));
                if (cmd.hasOption("scatimeout")) {
                    scanConfig.setSCAScanTimeoutInMinutes(Integer.valueOf(cmd.getOptionValue("scatimeout")));
                }
            } else {
                if (cmd.hasOption("enablesca") && cmd.hasOption("scatimeout")) {
                    scanConfig.setSCAScanTimeoutInMinutes(Integer.valueOf(cmd.getOptionValue("scatimeout")));
                }
                scanConfig.setProjectName(CxConfigHelper.extractProjectName(cmd.getOptionValue("projectname"), false));
                scanConfig.setTeamPath(CxConfigHelper.extractTeamPath(cmd.getOptionValue("projectname"), false));
            }
        }
        String suppliedPresetName = cmd.getOptionValue("preset");
        scanConfig.setPresetId(null);
        if (suppliedPresetName != null && !suppliedPresetName.isEmpty()) {
            scanConfig.setPresetName(suppliedPresetName.trim());
        } else {
            scanConfig.setPresetName(props.getProperty("scan.sast.preset.name"));
            log.info("Default Preset : " + scanConfig.getPresetName());
        }
        scanConfig.setSastFolderExclusions(this.getParamWithDefault("locationpathexclude", "scan.zip.ignored.folders", true));
        String includeExcludeCommand = this.getRelevantCommand();
        String sastFilterPattern = this.getParamWithDefault(includeExcludeCommand, "scan.zip.ignored.files", true) + this.getIncExcParamWithDefault(includeExcludeCommand);
        scanConfig.setSastFilterPattern(sastFilterPattern);
        scanConfig.setScanComment(cmd.getOptionValue("comment"));
        this.setScanReports(scanConfig);
        String reportPath = this.getReportPath("scareportpath");
        if (reportPath != null && !reportPath.isEmpty()) {
            File reportDir = new File(reportPath);
            scanConfig.setReportsDir(reportDir);
        }
        scanConfig.setGenerateScaReport(cmd.hasOption("generateScaReport"));
        scanConfig.setScaReportFormat(cmd.getOptionValue("scareportformat"));
        if (scanConfig.isGenerateScaReport()) {
            this.throwForInvalidScaReportFormat(scanConfig.getScaReportFormat());
            if (!cmd.hasOption("scareportpath")) {
                throw new CLIParsingException("scareportpath command line option must be specified.");
            }
        }
        scanConfig.setIncremental(cmd.hasOption("incremental"));
        String postScanAction = cmd.getOptionValue("postscanaction");
        scanConfig.setPostScanName(postScanAction);
        scanConfig.setForceScan(cmd.hasOption("forcescan"));
        scanConfig.setEnableSASTBranching(cmd.hasOption("enablesastbranching"));
        if (cmd.hasOption("enablesastbranching")) {
            if (!cmd.hasOption("masterbranchprojname")) {
                CxConfigHelper.getRequiredParam(cmd, "masterbranchprojname", null);
            } else {
                scanConfig.setMasterBranchProjName(cmd.getOptionValue("masterbranchprojname"));
            }
        }
        if (cmd.hasOption("incremental")) {
            scanConfig.setIncremental(!cmd.hasOption("forcescan"));
        }
        boolean bl = isFullScan = cmd.hasOption("incremental") && cmd.hasOption("forcescan");
        if (isFullScan) {
            log.info("Both incremental scan and Force scan options are provided. Full scan will be performed.");
        }
        if (cmd.hasOption("periodicfullscan")) {
            if (!cmd.hasOption("incremental")) {
                CxConfigHelper.getRequiredParam(cmd, "incremental", null);
            } else {
                String periodicFullScan = cmd.getOptionValue("periodicfullscan");
                this.fullScanCycle = Integer.valueOf(periodicFullScan);
                boolean isIncremental = this.isThisBuildIncremental();
                scanConfig.setIncremental(isIncremental);
            }
        }
        scanConfig.setAvoidDuplicateProjectScans(cmd.hasOption("avoidduplicateprojectscans"));
        this.setSASTThresholds(scanConfig);
        String dsLocationPath = this.getSharedDependencyScanOption(scanConfig, "osalocationpath", "scalocationpath");
        if (scanConfig.isSastEnabled() || dsLocationPath == null) {
            ScanSourceConfigurator locator = new ScanSourceConfigurator();
            locator.configureSourceLocation(this.commandLine, props, scanConfig);
        }
        scanConfig.setProgressInterval(props.getIntProperty("scan.job.progress.interval"));
        scanConfig.setConnectionRetries(props.getIntProperty("scan.job.connection.retries"));
        scanConfig.setDefaultProjectName(props.getProperty("scan.default.projectname"));
        boolean isTimeOutProvided = cmd.hasOption("copybranchtimeoutinseconds");
        if (isTimeOutProvided) {
            int timeoutinseconds = Integer.valueOf(cmd.getOptionValue("copybranchtimeoutinseconds"));
            log.info("=============timeoutinseconds==========" + timeoutinseconds);
            scanConfig.setcopyBranchTimeOutInSeconds(timeoutinseconds);
        }
        this.configureDependencyScan(scanConfig);
        if (cmd.hasOption("configascode")) {
            this.checkForConfigAsCode(scanConfig);
        }
        if (scanConfig.getAvoidDuplicateProjectScans() != null && scanConfig.getAvoidDuplicateProjectScans().booleanValue()) {
            log.warn("avoidduplicateprojectscans option will be deprecated in version after v1.1.36. SAST configuration will be used to determine the parallel scan policy.");
        }
        return scanConfig;
    }

    public void setSystemProperties() {
        String customTrustStore = props.getProperty("trustStore");
        String customTrustStorePassword = props.getProperty("trustStorePassword");
        if (customTrustStore != null && !customTrustStore.isEmpty()) {
            System.setProperty("javax.net.ssl.trustStore", customTrustStore);
            System.setProperty("javax.net.ssl.trustStorePassword", customTrustStorePassword);
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        }
    }

    private String apiFormat(String customFields) {
        if (StringUtils.isNotEmpty((CharSequence)customFields)) {
            customFields = customFields.replaceAll(":", "\":\"");
            customFields = customFields.replaceAll(",", "\",\"");
            customFields = "{\"".concat(customFields).concat("\"}");
        }
        return customFields;
    }

    private void checkForConfigAsCode(CxScanConfig scanConfig) throws CLIParsingException, IOException, ConfigurationException {
        if (StringUtils.isNotEmpty((CharSequence)scanConfig.getRemoteSrcUrl()) && RemoteSourceTypes.GIT == scanConfig.getRemoteType()) {
            this.resolveConfigAsCodeFromRemote(scanConfig);
        }
        if (StringUtils.isNotEmpty((CharSequence)scanConfig.getSourceDir())) {
            this.resolveConfigAsCodeLocal(scanConfig);
        }
    }

    private void resolveConfigAsCodeLocal(CxScanConfig scanConfig) throws CLIParsingException, IOException, ConfigurationException {
        log.info("loading config file from local working directory ..");
        ConfigAsCode configAsCodeFromFile = this.getConfigAsCodeFromFile(scanConfig.getSourceDir() + File.separator + ".checkmarx" + File.separator + CONFIG_AS_CODE_FILE_NAME);
        this.overrideConfigAsCode(configAsCodeFromFile, scanConfig);
    }

    private void resolveConfigAsCodeFromRemote(CxScanConfig scanConfig) throws CLIParsingException, ConfigurationException {
        log.info("loading config file from remote working directory ..");
        GeneralGitReader reader = null;
        try {
            URIish urIish = this.prepareRemoteUrl(scanConfig.getRemoteSrcUrl(), scanConfig.getRemoteSrcPort());
            GeneralRepoDto repoDto = new GeneralRepoDto();
            repoDto.setSrcUrl(urIish.toString());
            repoDto.setSrcPass(StringUtils.isNotEmpty((CharSequence)urIish.getPass()) ? urIish.getPass() : scanConfig.getRemoteSrcPass());
            repoDto.setSrcUserName(StringUtils.isNotEmpty((CharSequence)urIish.getUser()) ? urIish.getUser() : scanConfig.getRemoteSrcUser());
            repoDto.setSrcRef(scanConfig.getRemoteSrcBranch());
            if ("http".equalsIgnoreCase(urIish.getScheme()) || "https".equalsIgnoreCase(urIish.getScheme())) {
                repoDto.setProtocolType(ProtocolType.HTTP);
            } else {
                repoDto.setProtocolType(ProtocolType.SSH);
                repoDto.setSrcPrivateKey(this.commandLine.getOptionValue("locationprivatekey"));
            }
            reader = new GeneralGitReader(repoDto);
            ConfigAsCode configAsCodeFromFile = this.getConfigAsCode((ConfigReader)reader);
            this.overrideConfigAsCode(configAsCodeFromFile, scanConfig);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(String.format("Couldn't initiate connection using %s", scanConfig.getRemoteSrcUrl()));
        }
        finally {
            Optional.ofNullable(reader).ifPresent(GeneralGitReader::close);
        }
    }

    private ConfigAsCode getConfigAsCode(ConfigReader reader) throws ConfigurationException {
        ConfigProvider configProvider = ConfigProvider.getInstance();
        configProvider.init("cx-CLI", reader);
        if (!configProvider.hasAnyConfiguration("cx-CLI")) {
            throw new ConfigurationException(String.format(CONFIG_FILE_S_NOT_FOUND_OR_COULDN_T_BE_LOADED, ".checkmarx/cx.config"));
        }
        ConfigAsCode configAsCodeFromFile = new ConfigAsCode();
        if (configProvider.hasConfiguration("cx-CLI", "project")) {
            configAsCodeFromFile.setProject((ProjectConfig)configProvider.getConfiguration("cx-CLI", "project", ProjectConfig.class));
        }
        if (configProvider.hasConfiguration("cx-CLI", "sast")) {
            configAsCodeFromFile.setSast((SastConfig)configProvider.getConfiguration("cx-CLI", "sast", SastConfig.class));
        }
        if (configProvider.hasConfiguration("cx-CLI", "sca")) {
            configAsCodeFromFile.setSca((ScaConfig)configProvider.getConfiguration("cx-CLI", "sca", ScaConfig.class));
        }
        return configAsCodeFromFile;
    }

    private void overrideConfigAsCode(ConfigAsCode configAsCodeFromFile, CxScanConfig scanConfig) throws CLIParsingException {
        HashMap<String, String> overridesResults = new HashMap<String, String>();
        this.mapProjectConfiguration(Optional.ofNullable(configAsCodeFromFile.getProject()), scanConfig, overridesResults);
        this.mapSastConfiguration(Optional.ofNullable(configAsCodeFromFile.getSast()), scanConfig, overridesResults);
        this.mapScaConfiguration(Optional.ofNullable(configAsCodeFromFile.getSca()), scanConfig, overridesResults);
        if (!overridesResults.isEmpty()) {
            log.info("The following fields are overridden using config as code file : ");
            overridesResults.keySet().forEach(key -> log.info(String.format("%s = %s", key, overridesResults.get(key))));
        }
    }

    private void mapScaConfiguration(Optional<ScaConfig> sca, CxScanConfig scanConfig, Map<String, String> overridesResults) {
        AtomicReference<String> fileInclude = new AtomicReference<String>("");
        AtomicReference<String> fileExclude = new AtomicReference<String>("");
        sca.map(ScaConfig::getFileExclude).filter(StringUtils::isNotBlank).ifPresent(pValue -> {
            fileExclude.set((String)pValue);
            overridesResults.put("Sca File Exclude", (String)pValue);
        });
        sca.map(ScaConfig::getFileInclude).filter(StringUtils::isNotBlank).ifPresent(pValue -> {
            fileInclude.set((String)pValue);
            overridesResults.put("Sca File Include", (String)pValue);
        });
        sca.map(ScaConfig::getPathExclude).filter(StringUtils::isNotBlank).ifPresent(pValue -> {
            scanConfig.setOsaFolderExclusions((String)pValue);
            overridesResults.put("Sca Folder Exclude", (String)pValue);
        });
        sca.map(ScaConfig::getCritical).filter(n -> n > 0).ifPresent(pValue -> {
            scanConfig.setOsaThresholdsEnabled(true);
            scanConfig.setOsaCriticalThreshold((Integer)pValue);
            overridesResults.put("Sca Critical", String.valueOf(pValue));
        });
        sca.map(ScaConfig::getHigh).filter(n -> n > 0).ifPresent(pValue -> {
            scanConfig.setOsaThresholdsEnabled(true);
            scanConfig.setOsaHighThreshold((Integer)pValue);
            overridesResults.put("Sca High", String.valueOf(pValue));
        });
        sca.map(ScaConfig::getMedium).filter(n -> n > 0).ifPresent(pValue -> {
            scanConfig.setOsaThresholdsEnabled(true);
            scanConfig.setOsaMediumThreshold((Integer)pValue);
            overridesResults.put("Sca Medium", String.valueOf(pValue));
        });
        sca.map(ScaConfig::getLow).filter(n -> n > 0).ifPresent(pValue -> {
            scanConfig.setOsaThresholdsEnabled(true);
            scanConfig.setOsaLowThreshold((Integer)pValue);
            overridesResults.put("Sca Low", String.valueOf(pValue));
        });
        if (!fileExclude.get().isEmpty() || !fileInclude.get().isEmpty()) {
            this.setDependencyScanFilterPattern(scanConfig, fileInclude.get(), fileExclude.get());
        }
    }

    private void mapSastConfiguration(Optional<SastConfig> sast, CxScanConfig scanConfig, Map<String, String> overridesResults) {
        sast.map(SastConfig::getConfiguration).filter(StringUtils::isNotBlank).ifPresent(pValue -> {
            scanConfig.setEngineConfigurationName((String)pValue);
            overridesResults.put("Configuration", (String)pValue);
        });
        sast.map(SastConfig::isIncremental).ifPresent(pValue -> {
            scanConfig.setIncremental((Boolean)pValue);
            overridesResults.put("Is Incremental", String.valueOf(pValue));
        });
        sast.map(SastConfig::isPrivateScan).ifPresent(pValue -> {
            scanConfig.setPublic(pValue == false);
            overridesResults.put("Is Private", String.valueOf(pValue));
        });
        sast.map(SastConfig::getLow).filter(n -> n > 0).ifPresent(pValue -> {
            scanConfig.setSastThresholdsEnabled(true);
            scanConfig.setSastLowThreshold((Integer)pValue);
            overridesResults.put("Low", String.valueOf(pValue));
        });
        sast.map(SastConfig::getMedium).filter(n -> n > 0).ifPresent(pValue -> {
            scanConfig.setSastThresholdsEnabled(true);
            scanConfig.setSastMediumThreshold((Integer)pValue);
            overridesResults.put("Medium", String.valueOf(pValue));
        });
        sast.map(SastConfig::getHigh).filter(n -> n > 0).ifPresent(pValue -> {
            scanConfig.setSastThresholdsEnabled(true);
            scanConfig.setSastHighThreshold((Integer)pValue);
            overridesResults.put("High", String.valueOf(pValue));
        });
        sast.map(SastConfig::getCritical).filter(n -> n > 0).ifPresent(pValue -> {
            scanConfig.setSastThresholdsEnabled(true);
            scanConfig.setSastCriticalThreshold((Integer)pValue);
            overridesResults.put("Critical", String.valueOf(pValue));
        });
        sast.map(SastConfig::getPreset).filter(StringUtils::isNotBlank).ifPresent(pValue -> {
            scanConfig.setPresetName((String)pValue);
            overridesResults.put("Preset", (String)pValue);
        });
        sast.map(SastConfig::getExcludeFolders).filter(StringUtils::isNotBlank).ifPresent(pValue -> {
            if (StringUtils.isNotEmpty((CharSequence)scanConfig.getSastFolderExclusions())) {
                pValue = Stream.of(scanConfig.getSastFolderExclusions().split(","), pValue.split(",")).flatMap(x -> Arrays.stream(x)).map(String::trim).distinct().collect(Collectors.joining(","));
            }
            scanConfig.setSastFolderExclusions((String)pValue);
            overridesResults.put("Folder Exclusions", (String)pValue);
        });
        sast.map(SastConfig::getIncludeExcludePattern).filter(StringUtils::isNotBlank).ifPresent(pValue -> {
            if (StringUtils.isNotEmpty((CharSequence)scanConfig.getSastFilterPattern())) {
                pValue = Stream.of(scanConfig.getSastFilterPattern().split(","), pValue.split(",")).flatMap(x -> Arrays.stream(x)).map(String::trim).distinct().collect(Collectors.joining(","));
            }
            scanConfig.setSastFilterPattern((String)pValue);
            overridesResults.put("Include/Exclude pattern", (String)pValue);
        });
        sast.map(SastConfig::isOverrideProjectSetting).ifPresent(pValue -> {
            scanConfig.setIsOverrideProjectSetting((boolean)pValue);
            overridesResults.put("Is Overridable", String.valueOf(pValue));
        });
        sast.map(SastConfig::isEnableSASTBranching).ifPresent(pValue -> {
            scanConfig.setEnableSASTBranching((Boolean)pValue);
            overridesResults.put("Enable SAST Branching", String.valueOf(pValue));
        });
        sast.map(SastConfig::getMasterBranchProjName).ifPresent(pValue -> {
            scanConfig.setMasterBranchProjName((String)pValue);
            overridesResults.put("Master Branch Project Name", String.valueOf(pValue));
        });
        sast.map(SastConfig::isAvoidDuplicateProjectScans).ifPresent(pValue -> {
            scanConfig.setAvoidDuplicateProjectScans((Boolean)pValue);
            overridesResults.put("Avoid Duplicate Project Scans", String.valueOf(pValue));
        });
    }

    private void mapProjectConfiguration(Optional<ProjectConfig> project, CxScanConfig scanConfig, Map<String, String> overridesResults) throws CLIParsingException {
        String projectName = project.map(ProjectConfig::getFullPath).orElse(null);
        if (this.command.equals((Object)Command.SCA_SCAN) || this.command.equals((Object)Command.ASYNC_SCA_SCAN)) {
            scanConfig.setProjectName(CxConfigHelper.extractProjectName(projectName, true));
            scanConfig.setTeamPath(CxConfigHelper.extractTeamPath(projectName, true));
        } else {
            scanConfig.setProjectName(CxConfigHelper.extractProjectName(projectName, false));
            scanConfig.setTeamPath(CxConfigHelper.extractTeamPath(projectName, false));
        }
        if (projectName != null) {
            overridesResults.put("Project Name", projectName);
        }
        project.map(ProjectConfig::getOrigin).filter(StringUtils::isNotBlank).ifPresent(origin -> {
            scanConfig.setCxOrigin((String)origin);
            overridesResults.put("Origin", (String)origin);
        });
    }

    private ConfigAsCode getConfigAsCodeFromFile(String filePath) throws ConfigurationException, IOException {
        FileReader reader = new FileReader(ResourceType.YAML, filePath);
        return this.getConfigAsCode((ConfigReader)reader);
    }

    private URIish prepareRemoteUrl(String remoteSrcUrl, int remoteSrcPort) throws URISyntaxException {
        URIish urIish = new URIish(remoteSrcUrl);
        if (remoteSrcPort > 0) {
            urIish.setPort(remoteSrcPort);
        }
        return urIish;
    }

    private void configureDependencyScan(CxScanConfig scanConfig) throws CLIParsingException {
        if (!scanConfig.isAstScaEnabled() && !scanConfig.isOsaEnabled()) {
            return;
        }
        if (scanConfig.isOsaEnabled()) {
            this.setOSAEnv();
            this.setOsaSpecificConfig(scanConfig);
        } else if (scanConfig.isAstScaEnabled()) {
            this.setScaSpecificConfig(scanConfig);
        }
        this.setSharedDependencyScanConfig(scanConfig);
    }

    private void setOSAEnv() {
        String errLogDir;
        System.setProperty("FSA_ENRICH_ERR_LOGS", "true");
        String[] fsaConfArr = this.commandLine.getOptionValues("osafsaconf");
        if (fsaConfArr != null && !Arrays.asList(fsaConfArr).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            for (String arg : fsaConfArr) {
                if (!StringUtils.isNotEmpty((CharSequence)(arg = arg.trim()))) continue;
                sb.append(prefix + arg);
                prefix = ";";
            }
            String fsaConf = sb.toString().trim();
            if (StringUtils.isNotEmpty((CharSequence)fsaConf)) {
                System.setProperty("FSA_CONFIGURATION", fsaConf);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(errLogDir = this.commandLine.getOptionValue("osaerrorlogdir")))) {
            System.setProperty("FSA_ERR_LOGS_PATH", errLogDir);
        }
    }

    private String getRelevantCommand() {
        String oldCommandLineValue = this.commandLine.getOptionValue("locationfilesexclude");
        String newCommandLineValue = this.commandLine.getOptionValue("includeexcludepattern");
        if (newCommandLineValue != null) {
            return "includeexcludepattern";
        }
        if (oldCommandLineValue != null) {
            return "locationfilesexclude";
        }
        return "";
    }

    private void setOsaSpecificConfig(CxScanConfig scanConfig) {
        String reportDir;
        scanConfig.setOsaRunInstall(this.commandLine.hasOption("executepackagedependency"));
        scanConfig.setOsaFailOnError(this.commandLine.hasOption("osafailonerror"));
        String osaJsonFile = this.commandLine.getOptionValue("osascanjson");
        if (StringUtils.isNotEmpty((CharSequence)osaJsonFile)) {
            if (this.verifyOsaJson(osaJsonFile)) {
                String json = this.getFileContent(new File(osaJsonFile));
                scanConfig.setOsaDependenciesJson(json);
                log.info("FSA resolver override SUCCESS, OSA dependencies json used: " + osaJsonFile);
            } else {
                log.error("FSA resolver override: FAILED, OSA dependencies json used: " + osaJsonFile);
                scanConfig.setOsaDependenciesJson(EMPTY_JSON);
            }
        }
        scanConfig.setReportsDir((reportDir = this.commandLine.getOptionValue("osajson")) != null ? new File(reportDir) : null);
        scanConfig.setOsaGenerateJsonReport(reportDir != null);
        String archiveIncludePatterns = this.getParamWithDefault("osaarchivetoextract", "scan.osa.extractable.include.files", false);
        scanConfig.setOsaArchiveIncludePatterns(archiveIncludePatterns);
        String osaScanDepth = this.getOptionalParam("osascandepth", "scan.osa.extractable.depth");
        scanConfig.setOsaScanDepth(osaScanDepth);
    }

    private boolean verifyOsaJson(String osaJsonFile) {
        try {
            String json;
            ObjectMapper jsonMapper;
            Collection dependenciesObj;
            File jsonFile = new File(osaJsonFile);
            if (jsonFile.exists() && (dependenciesObj = (Collection)(jsonMapper = new ObjectMapper()).readValue(json = this.getFileContent(jsonFile), (JavaType)jsonMapper.getTypeFactory().constructCollectionType(Collection.class, AgentProjectInfo.class))) != null) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("Fail parse dependencies json file.");
        }
        return false;
    }

    private String getFileContent(File file) {
        try {
            return IOUtils.toString((URI)file.toURI(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Fail to get file content.");
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setScaSpecificConfig(CxScanConfig scanConfig) throws CLIParsingException {
        String configFilePaths;
        AstScaConfig sca = new AstScaConfig();
        String apiUrl = CxConfigHelper.normalizeUrl(CxConfigHelper.getRequiredParam(this.commandLine, "scaapiurl", "scan.sca.api.url"));
        sca.setApiUrl(apiUrl);
        String acUrl = CxConfigHelper.normalizeUrl(CxConfigHelper.getRequiredParam(this.commandLine, "scaaccesscontrolurl", "scan.sca.accesscontrol.url"));
        sca.setAccessControlUrl(acUrl);
        String webAppUrl = CxConfigHelper.normalizeUrl(CxConfigHelper.getRequiredParam(this.commandLine, "scawebappurl", "scan.sca.webapp.url"));
        sca.setWebAppUrl(webAppUrl);
        String envVariables = this.getOptionalParam("env", "");
        if (StringUtils.isNotEmpty((CharSequence)envVariables)) {
            sca.setEnvVariables(CxSCAFileSystemUtils.convertStringToKeyValueMap(envVariables));
        }
        if (StringUtils.isNotEmpty((CharSequence)(configFilePaths = this.getOptionalParam("scaconfigfile", "")))) {
            sca.setConfigFilePaths(Arrays.asList(configFilePaths.split("\\s*,\\s*")));
        }
        this.configureScaWithSastDetails(sca);
        if (this.commandLine.hasOption("includesource")) {
            sca.setIncludeSources(true);
        }
        if (this.commandLine.hasOption("enablescaresolver")) {
            sca.setEnableScaResolver(true);
            String pathToResolver = CxConfigHelper.getRequiredParam(this.commandLine, "pathtoresolver", null);
            String additionalParams = CxConfigHelper.getRequiredParam(this.commandLine, "scaresolveraddparameters", null);
            additionalParams = CxConfigHelper.checkMissingMandatoryAdditionalParams(this.commandLine, additionalParams);
            log.debug("SCA Resolver Additional Parameters: " + additionalParams);
            this.validateSCAResolverParams();
            sca.setPathToScaResolver(pathToResolver);
            sca.setScaResolverAddParameters(additionalParams);
        }
        sca.setUsername(CxConfigHelper.getRequiredParam(this.commandLine, "scausername", null));
        sca.setPassword(CxConfigHelper.getRequiredParam(this.commandLine, "scapassword", null));
        sca.setTenant(CxConfigHelper.getRequiredParam(this.commandLine, "scaaccount", null));
        sca.setRemoteRepositoryInfo(null);
        sca.setSourceLocationType(SourceLocationType.LOCAL_DIRECTORY);
        String reportDir = this.commandLine.getOptionValue("scajsondirpath");
        if (reportDir != null) {
            File reportFolder = new File(reportDir);
            Path reportPath = Paths.get(reportDir, new String[0]);
            if (!reportFolder.isDirectory() || !reportFolder.canWrite()) throw new CLIParsingException(reportDir + " directory doesn't exist.");
            if (!Files.isWritable(reportPath)) throw new CLIParsingException("There is no write access for: " + reportDir);
            scanConfig.setReportsDir(reportDir != null ? reportFolder : null);
            scanConfig.setOsaGenerateJsonReport(reportDir != null);
            scanConfig.setScaJsonReport(reportDir);
        }
        scanConfig.setAstScaConfig(sca);
    }

    private void configureScaWithSastDetails(AstScaConfig sca) throws CLIParsingException {
        String serverURL = this.getOptionalParam("cxsasturl", "");
        String user = this.getOptionalParam("cxsastuser", "");
        String password = this.getOptionalParam("cxsastpass", "");
        String projectId = this.getOptionalParam("cxsastprojectid", "");
        String projectName = this.getOptionalParam("cxsastprojectname", "");
        if (!this.commandLine.hasOption("enablesca")) {
            if ((this.commandLine.hasOption("cxsastprojectname") || this.commandLine.hasOption("cxsastprojectid")) && this.exploitablePathParamsIncomplete(serverURL, user, password, projectId, projectName)) {
                serverURL = StringUtils.isEmpty((CharSequence)serverURL) ? this.getOptionalParam("cxserver", "") : serverURL;
                user = StringUtils.isEmpty((CharSequence)user) ? this.getOptionalParam("cxuser", "") : user;
                password = StringUtils.isEmpty((CharSequence)password) ? this.getOptionalParam("cxpassword", "") : password;
                String string = projectName = StringUtils.isEmpty((CharSequence)projectName) ? this.getOptionalParam("projectname", "") : projectName;
            }
            if (this.exploitablePathParamsIncomplete(serverURL, user, password, projectId, projectName)) {
                if (!this.exploitablePathParamsEmpty(serverURL, user, password, projectId, projectName)) {
                    throw new CLIParsingException("[CxConsole] For SCA exploitable path, CxSAST server details like url, user, password and full project path or project id are required. Received partial parameters.");
                }
            } else {
                this.prepareExpPathScaConfig(sca, serverURL, user, password, projectId, projectName);
            }
        } else if (this.exploitablePathParamsEmpty(serverURL, user, password, projectId, projectName) || this.exploitablePathParamsIncomplete(serverURL, user, password, projectId, projectName)) {
            this.prepareExpPathScaConfig(sca, this.getOptionalParam("cxserver", ""), this.getOptionalParam("cxuser", ""), this.getOptionalParam("cxpassword", ""), "", this.commandLine.getOptionValue("projectname"));
            if (StringUtils.isNotEmpty((CharSequence)projectId)) {
                sca.setSastProjectId(projectId);
            }
            if (StringUtils.isNotEmpty((CharSequence)projectName)) {
                sca.setSastProjectName(projectName);
            }
        } else {
            this.prepareExpPathScaConfig(sca, serverURL, user, password, projectId, projectName);
        }
    }

    private void prepareExpPathScaConfig(AstScaConfig sca, String serverURL, String user, String password, String projectId, String projectName) {
        sca.setSastServerUrl(serverURL);
        sca.setSastUsername(user);
        sca.setSastPassword(password);
        sca.setSastProjectName(projectName);
        sca.setSastProjectId(projectId);
    }

    private boolean exploitablePathParamsEmpty(String serverURL, String user, String password, String projectId, String projectName) {
        return StringUtils.isEmpty((CharSequence)serverURL) && StringUtils.isEmpty((CharSequence)user) && StringUtils.isEmpty((CharSequence)password) && StringUtils.isEmpty((CharSequence)projectId) && StringUtils.isEmpty((CharSequence)projectName);
    }

    private boolean exploitablePathParamsIncomplete(String serverURL, String user, String password, String projectId, String projectName) {
        boolean partialParams = false;
        partialParams = !StringUtils.isNotEmpty((CharSequence)serverURL) || partialParams;
        partialParams = !StringUtils.isNotEmpty((CharSequence)user) || partialParams;
        partialParams = !StringUtils.isNotEmpty((CharSequence)password) || partialParams;
        partialParams = !StringUtils.isNotEmpty((CharSequence)projectId) && !StringUtils.isNotEmpty((CharSequence)projectName) || partialParams;
        return partialParams;
    }

    private void setSharedDependencyScanConfig(CxScanConfig scanConfig) throws CLIParsingException {
        this.setDependencyScanThresholds(scanConfig);
        String location = this.getSharedDependencyScanOption(scanConfig, "osalocationpath", "scalocationpath");
        if (scanConfig.isOsaEnabled() && location != null) {
            this.validateOsaLocationPath(location);
        }
        scanConfig.setOsaLocationPath(location);
        String folderExclusions = this.getSharedDependencyScanOption(scanConfig, "osapathexclude", "scapathexclude");
        scanConfig.setOsaFolderExclusions(folderExclusions);
        String key = scanConfig.isOsaEnabled() ? "scan.osa.job.progress.interval" : "scan.sca.job.progress.interval";
        scanConfig.setOsaProgressInterval(props.getIntProperty(key));
        this.setDependencyScanFilterPattern(scanConfig);
    }

    private void validateOsaLocationPath(String location) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)location)) {
            throw new CLIParsingException("[CxConsole] OSA location path is required. Please specify -OsaLocationPath parameter with a valid directory path.");
        }
        File locationFile = new File(location);
        if (!locationFile.exists()) {
            throw new CLIParsingException("OSA location path does not exist: " + location);
        }
        if (locationFile.isDirectory()) {
            return;
        }
        if (locationFile.isFile()) {
            String fileName = locationFile.getName().toLowerCase();
            if (fileName.endsWith(".zip")) {
                throw new CLIParsingException("[CxConsole] ZIP files are not supported for OSA scanner type. OSA location path must be a directory.");
            }
            throw new CLIParsingException("[CxConsole] OSA location path must be a directory, not a file: " + location);
        }
    }

    private void setDependencyScanFilterPattern(CxScanConfig scanConfig) {
        String excludedFiles;
        String includedFiles;
        if (scanConfig.isOsaEnabled()) {
            includedFiles = this.getOptionalParam("osafilesinclude", "scan.osa.include.files");
            excludedFiles = this.getOptionalParam("osafilesexclude", "scan.osa.exclude.files");
        } else {
            includedFiles = this.getOptionalParam("scafilesinclude", "scan.sca.include.files");
            excludedFiles = this.getOptionalParam("scafilesexclude", "scan.sca.exclude.files");
        }
        this.setDependencyScanFilterPattern(scanConfig, includedFiles, excludedFiles);
    }

    private void setDependencyScanFilterPattern(CxScanConfig scanConfig, String includedFiles, String excludedFiles) {
        String filterPattern = null;
        if (includedFiles != null) {
            filterPattern = excludedFiles != null ? includedFiles + ", " + excludedFiles : includedFiles;
        } else if (excludedFiles != null) {
            filterPattern = excludedFiles;
        }
        scanConfig.setOsaFilterPattern(filterPattern);
    }

    private void setSastOrOsaCredentials(CxScanConfig scanConfig) throws CLIParsingException {
        boolean isSSO = this.commandLine.hasOption("usesso");
        String token = this.commandLine.getOptionValue("cxtoken");
        String username = this.commandLine.getOptionValue("cxuser");
        String password = this.validatePassword(this.commandLine.getOptionValue("cxpassword"));
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            scanConfig.setRefreshToken(token);
        } else {
            if ((Strings.isNullOrEmpty((String)username) || Strings.isNullOrEmpty((String)password)) && !isSSO) {
                throw new CLIParsingException("[CxConsole] User name and password are mandatory unless SSO or token is used");
            }
            scanConfig.setUsername(username);
            scanConfig.setPassword(password);
        }
    }

    private String validatePassword(String password) {
        return StringUtils.isNotEmpty((CharSequence)password) && password.startsWith("''") ? password.substring(2) : password;
    }

    private String getSastOrOsaServerUrl() throws CLIParsingException {
        String rawUrl = CxConfigHelper.getRequiredParam(this.commandLine, "cxserver", null);
        return CxConfigHelper.normalizeUrl(rawUrl);
    }

    private void checkForAmbiguousArgs() throws CLIParsingException {
        String message = null;
        if (this.commandLine.hasOption("enableosa") && this.commandLine.hasOption("enablesca")) {
            message = String.format("%s and %s arguments cannot be specified together.", "enableosa", "enablesca");
        } else if (this.command == Command.SCA_SCAN && this.commandLine.hasOption("enableosa")) {
            message = String.format("%s argument cannot be used with %s command", new Object[]{"enableosa", this.command});
        } else if (this.command == Command.OSA_SCAN && this.commandLine.hasOption("enablesca")) {
            message = String.format("%s argument cannot be used with %s command", new Object[]{"enablesca", this.command});
        }
        if (message != null) {
            throw new BadOptionCombinationException(message);
        }
    }

    private void setScanReports(CxScanConfig scanConfig) {
        String reportPath = this.getReportPath("reportpdf");
        if (reportPath != null) {
            scanConfig.addPDFReport(reportPath);
            scanConfig.setGeneratePDFReport(true);
        } else {
            scanConfig.setGeneratePDFReport(false);
        }
        reportPath = this.getReportPath("reportxml");
        if (reportPath != null) {
            scanConfig.addXMLReport(reportPath);
            scanConfig.setGenerateXmlReport(true);
        } else {
            scanConfig.setGenerateXmlReport(false);
        }
        reportPath = this.getReportPath("reportcsv");
        if (reportPath != null) {
            scanConfig.addCSVReport(reportPath);
        }
        if ((reportPath = this.getReportPath("reportrtf")) != null) {
            scanConfig.addRTFReport(reportPath);
        }
    }

    private String getReportPath(String optionName) {
        String rawValue = this.commandLine.getOptionValue(optionName);
        String result = null;
        if (rawValue != null) {
            result = rawValue.replace("..\\", "").replace("..//", "");
        }
        return result;
    }

    private CxScanConfig setSASTThresholds(CxScanConfig scanConfig) {
        String sastCritical = this.commandLine.getOptionValue("sastcritical");
        String sastHigh = this.commandLine.getOptionValue("sasthigh");
        String sastMedium = this.commandLine.getOptionValue("sastmedium");
        String sastLow = this.commandLine.getOptionValue("sastlow");
        scanConfig.setSastThresholdsEnabled(false);
        if (!Strings.isNullOrEmpty((String)sastCritical)) {
            scanConfig.setSastCriticalThreshold(Integer.valueOf(sastCritical));
            scanConfig.setSastThresholdsEnabled(true);
        }
        if (!Strings.isNullOrEmpty((String)sastHigh)) {
            scanConfig.setSastHighThreshold(Integer.valueOf(sastHigh));
            scanConfig.setSastThresholdsEnabled(true);
        }
        if (!Strings.isNullOrEmpty((String)sastMedium)) {
            scanConfig.setSastMediumThreshold(Integer.valueOf(sastMedium));
            scanConfig.setSastThresholdsEnabled(true);
        }
        if (!Strings.isNullOrEmpty((String)sastLow)) {
            scanConfig.setSastLowThreshold(Integer.valueOf(sastLow));
            scanConfig.setSastThresholdsEnabled(true);
        }
        return scanConfig;
    }

    private void setDependencyScanThresholds(CxScanConfig scanConfig) {
        String critical = this.getSharedDependencyScanOption(scanConfig, "", "scacritical");
        String high = this.getSharedDependencyScanOption(scanConfig, "osahigh", "scahigh");
        String medium = this.getSharedDependencyScanOption(scanConfig, "osamedium", "scamedium");
        String low = this.getSharedDependencyScanOption(scanConfig, "osalow", "scalow");
        scanConfig.setOsaThresholdsEnabled(false);
        if (!Strings.isNullOrEmpty((String)critical)) {
            scanConfig.setOsaCriticalThreshold(Integer.valueOf(critical));
            scanConfig.setOsaThresholdsEnabled(true);
        }
        if (!Strings.isNullOrEmpty((String)high)) {
            scanConfig.setOsaHighThreshold(Integer.valueOf(high));
            scanConfig.setOsaThresholdsEnabled(true);
        }
        if (!Strings.isNullOrEmpty((String)medium)) {
            scanConfig.setOsaMediumThreshold(Integer.valueOf(medium));
            scanConfig.setOsaThresholdsEnabled(true);
        }
        if (!Strings.isNullOrEmpty((String)low)) {
            scanConfig.setOsaLowThreshold(Integer.valueOf(low));
            scanConfig.setOsaThresholdsEnabled(true);
        }
    }

    private String getSharedDependencyScanOption(CxScanConfig scanConfig, String osaOption, String scaOption) {
        String result = null;
        if (scanConfig.isOsaEnabled()) {
            result = this.commandLine.getOptionValue(osaOption);
        } else if (scanConfig.isAstScaEnabled()) {
            result = this.commandLine.getOptionValue(scaOption);
        }
        return result;
    }

    private ScannerType getDependencyScannerType() {
        ScannerType result = this.command == Command.OSA_SCAN || this.command == Command.ASYNC_OSA_SCAN || this.commandLine.hasOption("enableosa") ? ScannerType.OSA : (this.command == Command.SCA_SCAN || this.command == Command.ASYNC_SCA_SCAN || this.commandLine.hasOption("enablesca") ? ScannerType.AST_SCA : null);
        return result;
    }

    private static int getLastIndexOfTeam(String fullPath, boolean isScaScan) throws CLIParsingException {
        int lastIdxOfBackSlash = fullPath.lastIndexOf("\\");
        int lastIdxOfSlash = fullPath.lastIndexOf("/");
        if (lastIdxOfBackSlash == -1 && lastIdxOfSlash == -1) {
            if (isScaScan) {
                return -1;
            }
            throw new CLIParsingException(String.format("[CxConsole]  Invalid project path specified: %s", fullPath));
        }
        return lastIdxOfBackSlash != -1 ? lastIdxOfBackSlash : lastIdxOfSlash;
    }

    private static String extractProjectName(String fullPath, boolean isScaScan) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)fullPath)) {
            throw new CLIParsingException("[CxConsole] No project path was specified");
        }
        int lastIdx = CxConfigHelper.getLastIndexOfTeam(fullPath, isScaScan);
        return fullPath.substring(lastIdx + 1);
    }

    private static String extractTeamPath(String fullPath, boolean isScaScan) throws CLIParsingException {
        if (Strings.isNullOrEmpty((String)fullPath)) {
            throw new CLIParsingException("[CxConsole] No project path was specified");
        }
        int lastIdx = CxConfigHelper.getLastIndexOfTeam(fullPath, isScaScan);
        if (lastIdx == -1) {
            return "";
        }
        return fullPath.substring(0, lastIdx);
    }

    public static void printConfig(CommandLine commandLine) {
        log.info("-----------------------------------------------------------------------------------------");
        log.info("CxConsole Configuration: ");
        log.info("--------------------");
        String pluginVersion = CxConfigHelper.class.getPackage() != null ? CxConfigHelper.class.getPackage().getImplementationVersion() : "";
        log.info("plugin version: {}", (Object)pluginVersion);
        for (Option param : commandLine.getOptions()) {
            String value;
            String name;
            String string = name = param.getLongOpt() != null ? param.getLongOpt() : param.getOpt();
            if (param.getOpt().equalsIgnoreCase("cxpassword") || param.getOpt().equalsIgnoreCase("scapassword") || param.getOpt().equalsIgnoreCase("locationpassword") || param.getOpt().equalsIgnoreCase("cxtoken")) {
                value = "********";
            } else if (param.getOpt().equalsIgnoreCase("cxuser") || param.getOpt().equalsIgnoreCase("scausername") || param.getOpt().equalsIgnoreCase("locationuser")) {
                value = param.getValue();
                log.debug("{}: {}", (Object)name, (Object)value);
                value = DigestUtils.sha256Hex((String)param.getValue());
            } else if (param.getOpt().equalsIgnoreCase("locationurl")) {
                int i;
                String value1 = param.getValue();
                String[] arrOfStr = value1.split("@");
                value = "";
                if (arrOfStr.length == 1) {
                    for (i = 0; i < arrOfStr[0].length(); ++i) {
                        value = value + "*";
                    }
                } else {
                    for (i = 0; i < arrOfStr[0].length(); ++i) {
                        value = value + "*";
                    }
                    value = value + "@";
                    value = value + arrOfStr[1];
                }
            } else {
                value = param.hasArg() ? param.getValue() : "true";
            }
            log.info("{}: {}", (Object)name, (Object)value);
        }
        log.info("--------------------\n\n");
    }

    public static void printHelp(Command mode) {
        if (mode == null) {
            return;
        }
        String footerFormat = "\nUsage example: %s\n\n(c) 2019 CheckMarx.com LTD, All Rights Reserved\n";
        String helpHeader = mode.getDescription();
        String helpFooter = String.format(footerFormat, mode.getUsageExamples());
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(120, mode.value(), helpHeader, Command.getOptions(), helpFooter, true);
    }

    private String getOptionalParam(String commandLineKey, String fallbackProperty) {
        String commandLineValue = this.commandLine.getOptionValue(commandLineKey);
        String propertyValue = props.getProperty(fallbackProperty);
        return StringUtils.isNotEmpty((CharSequence)commandLineValue) ? commandLineValue : propertyValue;
    }

    private boolean validateSCAResolverParams() throws CLIParsingException {
        File file;
        boolean isValidParams = true;
        String pathToResolver = this.commandLine.getOptionValue("pathtoresolver");
        String additionalParams = this.commandLine.getOptionValue("scaresolveraddparameters");
        pathToResolver = pathToResolver + File.separator + "ScaResolver";
        if (!SystemUtils.IS_OS_UNIX) {
            pathToResolver = pathToResolver + ".exe";
        }
        if (!(file = new File(pathToResolver)).exists()) {
            throw new CLIParsingException("SCA Resolver path does not exist. Path=" + file.getAbsolutePath());
        }
        String[] arguments = additionalParams.split(" ");
        for (int i = 0; i < arguments.length; ++i) {
            File resultPath;
            if (!arguments[i].equals("-r") && !arguments[i].equals("-s")) continue;
            String dirPath = arguments[i + 1];
            if (dirPath.endsWith(File.separator)) {
                dirPath = dirPath.substring(0, dirPath.length() - 2);
            }
            if ((resultPath = new File(dirPath)).exists() || !arguments[i].equals("-s")) continue;
            throw new CLIParsingException("Source code path does not exist. " + resultPath.getAbsolutePath());
        }
        return isValidParams;
    }

    private String getParamWithDefault(String commandLineKey, String fallbackProperty, boolean useConfigAsCode) {
        String commandLineValue = this.commandLine.getOptionValue(commandLineKey);
        String propertyValue = props.getProperty(fallbackProperty);
        if (useConfigAsCode) {
            return StringUtils.isNotEmpty((CharSequence)commandLineValue) && !this.commandLine.hasOption("configascode") ? propertyValue + ", " + commandLineValue : propertyValue;
        }
        return StringUtils.isNotEmpty((CharSequence)commandLineValue) ? propertyValue + ", " + commandLineValue : propertyValue;
    }

    private String getIncExcParamWithDefault(String commandLineKey) {
        String commandLineValue = this.commandLine.getOptionValue(commandLineKey);
        if (!this.commandLine.hasOption("configascode") && StringUtils.isNotEmpty((CharSequence)commandLineValue) && Stream.of(commandLineValue.split(",")).map(String::trim).anyMatch(val -> !val.startsWith("!")) && !commandLineValue.contains("**/*")) {
            return ", **/*";
        }
        return "";
    }

    private static String getRequiredParam(CommandLine cmdLine, String cmdLineOptionName, @Nullable String fallbackProperty) throws CLIParsingException {
        String result = cmdLine.getOptionValue(cmdLineOptionName);
        if (Strings.isNullOrEmpty((String)result) && fallbackProperty != null) {
            result = props.getProperty(fallbackProperty);
        }
        if (Strings.isNullOrEmpty((String)result)) {
            String message = fallbackProperty != null ? String.format("%s command line option or %s configuration setting must be specified.", cmdLineOptionName, fallbackProperty) : String.format("%s command line option must be specified.", cmdLineOptionName);
            throw new CLIParsingException(message);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkMissingMandatoryAdditionalParams(CommandLine cmdLine, String addParams) throws CLIParsingException {
        if (addParams == null) {
            addParams = "";
        }
        if (!addParams.contains("-n ")) {
            String projectName = cmdLine.getOptionValue("projectname");
            if (!StringUtils.isNotEmpty((CharSequence)projectName)) throw new CLIParsingException("projectname command line option must be specified");
            projectName = projectName.trim();
            addParams = addParams + " -n " + projectName;
        }
        if (!addParams.contains("-s ")) {
            String locationPath = cmdLine.getOptionValue("locationpath");
            String scaLocationPath = cmdLine.getOptionValue("scalocationpath");
            if (StringUtils.isNotEmpty((CharSequence)locationPath)) {
                locationPath = locationPath.trim();
                addParams = addParams + " -s " + locationPath;
            } else {
                if (!StringUtils.isNotEmpty((CharSequence)scaLocationPath)) throw new CLIParsingException("locationpath command line option must be specified");
                scaLocationPath = scaLocationPath.trim();
                addParams = addParams + " -s " + scaLocationPath;
            }
        }
        if (cmdLine.hasOption("enablesca") && (addParams.contains("--cxprojectname ") || addParams.contains("--cxprojectid "))) {
            if (!addParams.contains("--cxserver ")) {
                String cxserver = cmdLine.getOptionValue("cxserver");
                if (!StringUtils.isNotEmpty((CharSequence)cxserver)) throw new CLIParsingException("cxserver command line option must be specified");
                cxserver = cxserver.trim();
                addParams = addParams + " --cxserver " + cxserver;
            }
            if (!addParams.contains("--cxuser ")) {
                String cxuser = cmdLine.getOptionValue("cxuser");
                if (!StringUtils.isNotEmpty((CharSequence)cxuser)) throw new CLIParsingException("cxuser command line option must be specified");
                cxuser = cxuser.trim();
                addParams = addParams + " --cxuser " + cxuser;
            }
            if (addParams.contains("--cxpassword ")) return addParams;
            String cxpassword = cmdLine.getOptionValue("cxpassword");
            if (!StringUtils.isNotEmpty((CharSequence)cxpassword)) throw new CLIParsingException("cxpassword command line option must be specified");
            cxpassword = cxpassword.trim();
            return addParams + " --cxpassword " + cxpassword;
        }
        if (!addParams.contains("--cxprojectname ")) {
            if (!addParams.contains("--cxprojectid ")) return addParams;
        }
        if (!addParams.contains("--cxserver ")) throw new CLIParsingException("--cxserver, --cxuser, --cxpassword and --cxprojectname must be specified to use Exploitable Path.");
        if (!addParams.contains("--cxuser ")) throw new CLIParsingException("--cxserver, --cxuser, --cxpassword and --cxprojectname must be specified to use Exploitable Path.");
        if (addParams.contains("--cxpassword ")) return addParams;
        throw new CLIParsingException("--cxserver, --cxuser, --cxpassword and --cxprojectname must be specified to use Exploitable Path.");
    }

    private static String normalizeUrl(String rawValue) {
        return rawValue.startsWith("http") ? rawValue : "http://" + rawValue;
    }

    private String getVariable(String var) {
        String value = StringUtils.isNotEmpty((CharSequence)System.getenv(var)) ? System.getenv(var) : System.getProperty(var);
        return StringUtils.isNotEmpty((CharSequence)value) ? value.trim() : null;
    }

    private ProxyConfig genProxyConfig() {
        String HTTP_HOST = this.getVariable("http.proxyHost");
        String HTTP_PORT = this.getVariable("http.proxyPort");
        String HTTP_USERNAME = this.getVariable("http.proxyUser");
        String HTTP_PASSWORD = this.getVariable("http.proxyPassword");
        String HTTP_NON_HOSTS = this.getVariable("http.nonProxyHosts");
        String HTTPS_HOST = this.getVariable("https.proxyHost");
        String HTTPS_PORT = this.getVariable("https.proxyPort");
        String HTTPS_USERNAME = this.getVariable("https.proxyUser");
        String HTTPS_PASSWORD = this.getVariable("https.proxyPassword");
        String HTTPS_NON_HOSTS = this.getVariable("https.nonProxyHosts");
        ProxyConfig proxyConfig = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)HTTP_HOST) && StringUtils.isNotEmpty((CharSequence)HTTP_PORT)) {
                proxyConfig = new ProxyConfig();
                proxyConfig.setUseHttps(false);
                proxyConfig.setHost(HTTP_HOST);
                proxyConfig.setPort(Integer.parseInt(HTTP_PORT));
                proxyConfig.setNoproxyHosts(StringUtils.isEmpty((CharSequence)HTTP_NON_HOSTS) ? "" : HTTP_NON_HOSTS);
                if (StringUtils.isNotEmpty((CharSequence)HTTP_USERNAME) && StringUtils.isNotEmpty((CharSequence)HTTP_PASSWORD)) {
                    proxyConfig.setUsername(HTTP_USERNAME);
                    proxyConfig.setPassword(HTTP_PASSWORD);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)HTTPS_HOST) && StringUtils.isNotEmpty((CharSequence)HTTPS_PORT)) {
                proxyConfig = new ProxyConfig();
                proxyConfig.setUseHttps(true);
                proxyConfig.setHost(HTTPS_HOST);
                proxyConfig.setPort(Integer.parseInt(HTTPS_PORT));
                proxyConfig.setNoproxyHosts(StringUtils.isEmpty((CharSequence)HTTPS_NON_HOSTS) ? "" : HTTPS_NON_HOSTS);
                if (StringUtils.isNotEmpty((CharSequence)HTTPS_USERNAME) && StringUtils.isNotEmpty((CharSequence)HTTPS_PASSWORD)) {
                    proxyConfig.setUsername(HTTPS_USERNAME);
                    proxyConfig.setPassword(HTTPS_PASSWORD);
                }
            }
        }
        catch (Exception e) {
            log.error("Fail to set custom proxy", (Throwable)e);
        }
        return proxyConfig;
    }

    private boolean testConnection(CxScanConfig scanConfig) throws CLIParsingException {
        if (this.command.equals((Object)Command.TEST_CONNECTION)) {
            if (this.commandLine.getOptionValue("cxserver") != null) {
                scanConfig.setUrl(this.getSastOrOsaServerUrl());
                this.setSastOrOsaCredentials(scanConfig);
                scanConfig.setUseSSOLogin(this.commandLine.hasOption("usesso"));
            } else {
                this.setScaSpecificConfig(scanConfig);
            }
            return true;
        }
        return false;
    }

    private boolean isThisBuildIncremental() {
        int buildNumber = 0;
        Map<String, String> env = System.getenv();
        if (env.get("BUILD_NUMBER") != null) {
            buildNumber = Integer.valueOf(env.get("BUILD_NUMBER"));
        }
        if (this.fullScanCycle == 0) {
            return true;
        }
        if (this.fullScanCycle < 1 || this.fullScanCycle > 99) {
            return true;
        }
        boolean shouldBeFullScan = buildNumber % (this.fullScanCycle + 1) == 1;
        return !shouldBeFullScan;
    }

    private void throwForInvalidScaReportFormat(String format) throws ConfigurationException {
        boolean valid = false;
        List<String> supportedFormats = Arrays.asList("json", "xml", "pdf", "csv", "cyclonedxjson", "cyclonedxxml");
        if (format == null || !supportedFormats.contains(format.toLowerCase())) {
            throw new ConfigurationException("Invalid SCA report format:" + format + ". Supported formats are:" + supportedFormats.toString());
        }
    }
}

