/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.cli.constants;

import com.cx.plugin.cli.constants.ArgDescriptions;
import com.cx.plugin.cli.constants.UsageExamples;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public enum Command {
    SCAN("Scan", "\n\nCxConsole Scan -Projectname SP\\Cx\\Engine\\AST -CxServer http://localhost -cxuser admin@cx -cxpassword admin -locationtype folder -locationpath C:\\cx -preset All -incremental -reportpdf a.pdf\nCxConsole Scan -projectname SP\\Cx\\Engine\\AST -CxServer http://localhost -cxuser admin@cx -cxpassword admin -locationtype zip -locationpath C:\\cx\\project.zip -preset All\nCxConsole Scan -projectname SP\\Cx\\Engine\\AST -cxserver http://localhost -cxuser admin@cx -cxpassword admin -locationtype tfs -locationurl http://vsts2003:8080 -locationuser dm\\matys -locationpassword XYZ -preset default -reportxml a.xml -reportpdf b.pdf -incremental -forcescan\nCxConsole Scan -projectname SP\\Cx\\Engine\\AST -cxserver http://localhost -cxuser admin@cx -cxpassword admin -locationtype share -locationpath '\\\\storage\\path1;\\\\storage\\path2' -locationuser dm\\matys -locationpassword XYZ -preset \"Sans 25\" -reportxls a.xls -reportpdf b.pdf -private -verbose -log a.log\n -LocationPathExclude test*, *log* -LocationFilesExclude web.config , *.class\n-enablesastbranching to check if branching support is enabled\n-masterbranchprojname master branch project name\n-periodicfullscan number like 4,5,etc", "\nThe \"Scan\" command allows to scan new and existing projects. It accepts all project settings as an arguments, similar to Web interface."),
    ASYNC_SCAN("AsyncScan", "\n\nCxConsole Scan -Projectname SP\\Cx\\Engine\\AST -CxServer http://localhost -cxuser admin@cx -cxpassword admin -locationtype folder -locationpath C:\\cx -preset All -incremental -reportpdf a.pdf\nCxConsole Scan -projectname SP\\Cx\\Engine\\AST -CxServer http://localhost -cxuser admin@cx -cxpassword admin -locationtype zip -locationpath C:\\cx\\project.zip -preset All\nCxConsole Scan -projectname SP\\Cx\\Engine\\AST -cxserver http://localhost -cxuser admin@cx -cxpassword admin -locationtype tfs -locationurl http://vsts2003:8080 -locationuser dm\\matys -locationpassword XYZ -preset default -reportxml a.xml -reportpdf b.pdf -incremental -forcescan\nCxConsole Scan -projectname SP\\Cx\\Engine\\AST -cxserver http://localhost -cxuser admin@cx -cxpassword admin -locationtype share -locationpath '\\\\storage\\path1;\\\\storage\\path2' -locationuser dm\\matys -locationpassword XYZ -preset \"Sans 25\" -reportxls a.xls -reportpdf b.pdf -private -verbose -log a.log\n -LocationPathExclude test*, *log* -LocationFilesExclude web.config , *.class\n-enablesastbranching to check if branching support is enabled\n-masterbranchprojname master branch project name\n-periodicfullscan number like 4,5,etc", "\nThe \"Scan\" command allows to scan new and existing projects. It accepts all project settings as an arguments, similar to Web interface."),
    OSA_SCAN("OsaScan", "\n\nrunCxConsole.cmd OsaScan -v -Projectname SP\\Cx\\Engine\\AST -CxServer http://localhost -cxuser admin -cxpassword admin -osaLocationPath C:\\cx  -OsaFilesExclude *.class OsaPathExclude src,temp  \nrunCxConsole.cmd  OsaScan -v -projectname SP\\Cx\\Engine\\AST -cxserver http://localhost -cxuser admin -cxpassword admin -locationtype folder -locationurl http://vsts2003:8080 -locationuser dm\\matys -locationpassword XYZ  \nrunCxConsole.cmd  OsaScan -v -projectname SP\\Cx\\Engine\\AST -cxserver http://localhost -cxuser admin -cxpassword admin -locationtype shared -locationpath '\\storage\\path1;\\storage\\path2' -locationuser dm\\matys -locationpassword XYZ  -log a.log\n \nrunCxConsole.cmd  OsaScan -v -Projectname CxServer\\SP\\Company\\my project -CxServer http://localhost -cxuser admin -cxpassword admin -locationtype folder -locationpath C:\\Users\\some_project -OsaFilesExclude *.bat ", "\nThe \"OsaScan\" command enables you to run a dependency scan for an existing project using the legacy CxOSA engine. The scan is, by default, run in synchronous mode. This means that the CLI initiates the scan task and the scan results can be viewed in the CLI and in the log file created."),
    ASYNC_OSA_SCAN("AsyncOsaScan", "\n\nrunCxConsole.cmd OsaScan -v -Projectname SP\\Cx\\Engine\\AST -CxServer http://localhost -cxuser admin -cxpassword admin -osaLocationPath C:\\cx  -OsaFilesExclude *.class OsaPathExclude src,temp  \nrunCxConsole.cmd  OsaScan -v -projectname SP\\Cx\\Engine\\AST -cxserver http://localhost -cxuser admin -cxpassword admin -locationtype folder -locationurl http://vsts2003:8080 -locationuser dm\\matys -locationpassword XYZ  \nrunCxConsole.cmd  OsaScan -v -projectname SP\\Cx\\Engine\\AST -cxserver http://localhost -cxuser admin -cxpassword admin -locationtype shared -locationpath '\\storage\\path1;\\storage\\path2' -locationuser dm\\matys -locationpassword XYZ  -log a.log\n \nrunCxConsole.cmd  OsaScan -v -Projectname CxServer\\SP\\Company\\my project -CxServer http://localhost -cxuser admin -cxpassword admin -locationtype folder -locationpath C:\\Users\\some_project -OsaFilesExclude *.bat ", "\nThe \"OsaScan\" command enables you to run a dependency scan for an existing project using the legacy CxOSA engine. The scan is, by default, run in synchronous mode. This means that the CLI initiates the scan task and the scan results can be viewed in the CLI and in the log file created."),
    SCA_SCAN("ScaScan", UsageExamples.SCA_SCAN, "This command enables you to run a dependency scan for an existing project using the new CxSCA engine. The scan is, by default, run in synchronous mode. This means that the CLI initiates the scan task and the scan results can be viewed in the CLI and in the log file created."),
    ASYNC_SCA_SCAN("AsyncScaScan", UsageExamples.ASYNC_SCA_SCAN, "This command enables you to run a dependency scan for an existing project using the new CxSCA engine. The scan is run in asynchronous mode. This means that the scan task ends when the scan request reaches the scan queue. As a result the scan results can only be viewed via the CxSCA web application."),
    GENERATE_TOKEN("GenerateToken", "runCxConsole.cmd GenerateToken -CxServer http://localhost -cxuser admin@company -cxpassword admin -v", "\nThe \"GenerateToken\" command allows to generate login token, to be used instead of username and password."),
    REVOKE_TOKEN("RevokeToken", "runCxConsole.cmd RevokeToken -CxToken 1241513513tsfrg42 -CxServer http://localhost -v", "\nThe \"RevokeToken\" command allows to discard existing token."),
    TEST_CONNECTION("TestConnection", "runCxConsole.cmd TestConnection -CxServer http://localhost -usesso -v", "\nThe \"TestConnection\" command checks if login was successful or not.");

    private final String usageExample;
    private final String description;
    private final String value;
    private static final List<String> commandsList;

    public static Command getCommandByValue(String value) {
        Command commandByValue = null;
        for (Command command : Command.values()) {
            if (!command.value().equalsIgnoreCase(value)) continue;
            commandByValue = command;
            break;
        }
        return commandByValue;
    }

    private Command(String value, String usageExample, String description) {
        this.value = value;
        this.usageExample = usageExample;
        this.description = description;
    }

    public String toString() {
        return this.value;
    }

    public static List<String> getAllValues() {
        return commandsList;
    }

    public String getUsageExamples() {
        return this.usageExample;
    }

    public String getDescription() {
        return this.description;
    }

    public String value() {
        return this.value;
    }

    public static Options getOptions() {
        Options options = new Options();
        options.addOption("config", true, "Path to CLI configuration file");
        options.addOption("cxserver", true, "IP address or resolvable name of CxSuite web server");
        options.addOption("cxuser", true, "Login username. Mandatory, Unless token is used or SSO login is used on Windows ('-useSSO' flag)");
        options.addOption("cxpassword", true, "Login password. Mandatory, Unless token is used or SSO login is used on Windows ('-useSSO' flag)");
        options.addOption("customfields", true, "Scan level custom fields");
        options.addOption("cxtoken", true, "Login token. Mandatory, Unless username and password are provided or SSO login is used on Windows ('-useSSO' flag)");
        options.addOption("generatetoken", false, "\nThe \"GenerateToken\" command allows to generate login token, to be used instead of username and password.");
        options.addOption("revoketoken", true, "\nThe \"RevokeToken\" command allows to discard existing token.");
        options.addOption("projectname", true, "A full absolute name of a project. The full Project name includes the whole path to the project, including Server, service provider, company, and team. Example:  -ProjectName \"CxServer\\SP\\Company\\Users\\bs java\" If project with such a name doesn't exist in the system, new project will be created.");
        options.addOption("checkpolicy", false, "This parameter will break the build if the CxOSA policy is violated. Optional.");
        options.addOption("workspacemode", true, "When -LocationType parameter is set to Perforce, add this parameter and add the workspace name into -locationPath. Optional");
        options.addOption("locationtype", true, "Source location type, one of: folder, zip, shared (network location), SVN, TFS, Perforce, GIT. Mandatory");
        options.addOption("locationpath", true, "Local or network path to sources or source repository branch. Mandatory if location type is folder, zip, SVN, TFS, Perforce or shared.");
        options.addOption("locationbranch", true, "Source GIT branch, Mandatory if location type is GIT");
        options.addOption("locationprivatekey", true, "GIT SSH key locations, Mandatory if location type is GIT using SSH");
        options.addOption("locationurl", true, "Source control URL. Madnatory if locationtype is any source control system.");
        options.addOption("locationport", true, "Source control system port. Default: 8080 (TFS), 80 (SVN), or 1666 (Perforce). Optional.");
        options.addOption("locationuser", true, "Source control/network credentials. Mandatory if locationtype is TFS/Perforce/shared");
        options.addOption("locationpassword", true, "Source control/network credentials. Mandatory if locationtype is TFS/Perforce/shared");
        options.addOption("locationpathexclude", true, "Comma separated list of folder name patterns to exclude from scan. For example, exclude all test and log folders: -locationPathExclude test* log_* Optional");
        options.addOption("locationfilesexclude", true, "Comma separated list of file name patterns to exclude from scan. For example, exclude all files with '.class' extension: -LocationFilesExclude *.class Optional");
        options.addOption("includeexcludepattern", true, "Comma separated list of file name patterns to exclude/include from/to scan. For example, exclude all files with '.class' extension: -includeexcludepattern \"!*.class\". Optional");
        options.addOption("osalocationpath", true, "Local or network path to sources or source repository branch. May include multiple list of folders (local or shared) separated by comma. Optional");
        options.addOption("osafilesinclude", true, ArgDescriptions.OSA_FILES_INCLUDE);
        options.addOption("osafilesexclude", true, ArgDescriptions.OSA_FILES_EXCLUDE);
        options.addOption("osapathexclude", true, ArgDescriptions.OSA_FOLDER_EXCLUDE);
        options.addOption("osaarchivetoextract", true, "Comma separated list of file extensions to be extracted in the OSA scan. \nFor example: -OsaArchiveToExtract *.zip extracts only files with .zip extension. Optional.");
        options.addOption("osascandepth", true, "Extraction depth of files to include in the OSA scan. Optional.");
        options.addOption("enableosa", false, "Enable open source analysis (CxOSA). -osaLocationPath should be specified or the -LocationType parameter needs to be defined as 'folder' or 'shared' (if -osaLocationPath doesn't exist, use -locationPath). Optional.");
        options.addOption("enablesca", false, ArgDescriptions.SCA_ENABLED);
        options.addOption("osajson", true, "Generate CxOSA JSON report. Optional, not supported in AsyncScan mode");
        options.addOption("scajsondirpath", true, "Generates three CxSCA JSON reports. Saves the reports in the specified folder path, Optional. Not supported in AsyncScaScan/AsyncScan mode");
        options.addOption("executepackagedependency", false, "Retrieve all supported package dependencies before performing OSA scan (see Remarks section). Optional.");
        options.addOption("osafailonerror", false, "Fails the execution in case of any error during the dependencies resolution process.");
        options.addOption(Option.builder((String)"osafsaconf").hasArg(true).hasArgs().argName("fsa configuration").desc("Comma separated list of FSA args, Example: 'npm.runPreStep,nuget.resolveDependencies' will override default values.").valueSeparator(',').build());
        options.addOption(Option.builder((String)"osaerrorlogdir").hasArg(true).hasArgs().argName("osa error log dir").desc("OSA error logs root path, if not provided will be stored at runtime directory.").build());
        options.addOption(Option.builder((String)"osascanjson").hasArg(true).hasArgs().argName("osa scan json").desc("OSA dependencies json to scan.").build());
        options.addOption("reportpdf", true, "Name or path to results report, by type. Optional. Not supported in AsyncScan mode.");
        options.addOption("reportxml", true, "Name or path to results report, by type. Optional. Not supported in AsyncScan mode.");
        options.addOption("reportcsv", true, "Name or path to results report, by type. Optional. Not supported in AsyncScan mode.");
        options.addOption("reportrtf", true, "Name or path to results report, by type. Optional. Not supported in AsyncScan mode.");
        options.addOption("generateScaReport", false, "Set Generate Sca Report. Optional.");
        options.addOption("scareportformat", true, "Set Sca Report Format. Optional.");
        options.addOption("scareportpath", true, "Path to SCA results report, by type. Optional. Not supported in AsyncScan mode.");
        options.addOption("incremental", false, "Run incremental scan instead of a full scan. Scans only new and modified files, relative to project's last scan(-Incremental will disable any -ForceScan setting). Optional.");
        options.addOption("forcescan", false, "Force scan on source code, which has not been changed since the last scan of the same project (not compatible with -Incremental option). Optional.");
        options.addOption("private", false, "Scan will not be visible to other users. Optional");
        options.addOption(Option.builder((String)"preset").desc("If not provided, will use preset defined in existing project or, for a new project, the default preset. Optional").hasArg(true).argName("preset").build());
        options.addOption(Option.builder((String)"comment").desc("Saves a comment with the scan results. For example: -comment 'important scan1'. Optional. Not supported in AsyncScan mode").hasArg(true).argName("text").build());
        options.addOption(Option.builder((String)"usesso").desc("Single Sign-On: Use Windows credentials of current user to log into CxSAST. Optional.").hasArg(false).build());
        options.addOption("sastcritical", true, ArgDescriptions.SAST_CRITICAL);
        options.addOption("sasthigh", true, ArgDescriptions.SAST_HIGH);
        options.addOption("sastmedium", true, ArgDescriptions.SAST_MEDIUM);
        options.addOption("sastlow", true, ArgDescriptions.SAST_LOW);
        options.addOption("osahigh", true, ArgDescriptions.OSA_HIGH);
        options.addOption("osamedium", true, ArgDescriptions.OSA_MEDIUM);
        options.addOption("osalow", true, ArgDescriptions.OSA_LOW);
        options.addOption("scaapiurl", true, "IP address or resolvable name of a SCA instance.");
        options.addOption("scaaccesscontrolurl", true, "IP address or resolvable name of an access control server that is used to access SCA.");
        options.addOption("scawebappurl", true, "URL of the SCA web application. Used to generate web report URL. If this option is not provided in the command line, a value from the config file is used.");
        options.addOption("scausername", true, "SCA username.");
        options.addOption("scapassword", true, "SCA password.");
        options.addOption("scaaccount", true, "Account name to be used during authentication.");
        options.addOption("enablescaresolver", false, "The command enables SCA dependency resolution using SCA Resolver Tool.");
        options.addOption("pathtoresolver", true, "Local path to sca resolver installation directory.");
        options.addOption("scaresolveraddparameters", true, "Arguments to SCA Resolver tool. Mandatory parameters as documented in SCA Resolver documentation to execute it in offline mode must be provided.");
        options.addOption("scacritical", true, ArgDescriptions.SCA_CRITICAL);
        options.addOption("scahigh", true, ArgDescriptions.SCA_HIGH);
        options.addOption("scamedium", true, ArgDescriptions.SCA_MEDIUM);
        options.addOption("scalow", true, ArgDescriptions.SCA_LOW);
        options.addOption("scafilesinclude", true, ArgDescriptions.SCA_FILES_INCLUDE);
        options.addOption("scafilesexclude", true, ArgDescriptions.SCA_FILES_EXCLUDE);
        options.addOption("scalocationpath", true, "Local or network path to sources that should scanned. Optional.");
        options.addOption("configascode", false, "Override scan settings with Remote/Local configuration file located inside source directory");
        options.addOption("scapathexclude", true, ArgDescriptions.SCA_FOLDER_EXCLUDE);
        options.addOption("v", "verbose", false, "Turns on verbose mode. All messages and events will be sent to the console or log file.");
        options.addOption("log", true, "Log file to be created.");
        options.addOption("loglevel", true, "Log level.");
        options.addOption("trustedcertificates", false, "The \u2018TrustedCertificates\u2019 parameter can be used to add certified security to the connection. By default, all certificates are trusted. When disabled, only certificates signed by a trusted certificate authority can be accepted.");
        options.addOption("configuration", true, "Code language configuration. Possible values are : Default Configuration, Japanese (Shift-JIS), Korean and Multi-language Scan. If configuration is not set, 'Default Configuration' is used.");
        options.addOption("ntlm", false, "Use NTLM for proxy authentication");
        options.addOption("env", true, "Optional Environment Variables that could be used during the SCA scan process.");
        options.addOption("cxsastprojectid", true, "Project Id from Checkmarx SAST used during SCA scan process.");
        options.addOption("cxsastprojectname", true, "Project Name from Checkmarx SAST used during SCA scan process.This supports both \"/\" and \"\\\" but requires a leading slash");
        options.addOption("cxsasturl", true, "IP address or resolvable name of CxSuite web server");
        options.addOption("cxsastuser", true, "Login username. Mandatory, Unless token is used or SSO login is used on Windows ('-useSSO' flag)");
        options.addOption("cxsastpass", true, "Login password. Mandatory, Unless token is used or SSO login is used on Windows ('-useSSO' flag)");
        options.addOption("scaconfigfile", true, "Configuration files from package managers (maven,npm etc.) needed for the SCA scan.");
        options.addOption("includesource", false, "Flag to include the entire source code for the SCA scan.");
        options.addOption("scatimeout", true, "Timeout duration for SCA scan.");
        options.addOption("enablesastbranching", false, "Enable to create child project");
        options.addOption("masterbranchprojname", true, "Master branch project name");
        options.addOption("postscanaction", true, "Post Scan Action name that is to be performed automatically after a scan.");
        options.addOption("periodicfullscan", true, "Run a full scan after X incremental scans . Scans all files, (-Incremental should be enable). Optional.");
        options.addOption("avoidduplicateprojectscans", false, "Avoid duplicate project scans in queue");
        options.addOption("copybranchtimeoutinseconds", true, "TimeOut duration for branch project copy.");
        return options;
    }

    static {
        commandsList = new ArrayList<String>();
        for (Command command : Command.values()) {
            commandsList.add(command.value.toLowerCase());
        }
    }
}

