/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.cli;

import com.cx.plugin.cli.CxSastConnectionProvider;
import com.cx.plugin.cli.constants.Command;
import com.cx.plugin.cli.errorsconstants.Errors;
import com.cx.plugin.cli.exceptions.CLIParsingException;
import com.cx.plugin.cli.utils.CxConfigHelper;
import com.cx.plugin.cli.utils.ErrorParsingHelper;
import com.cx.restclient.CxClientDelegator;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.Results;
import com.cx.restclient.dto.ScanResults;
import com.cx.restclient.dto.ScannerType;
import com.cx.restclient.dto.scansummary.ScanSummary;
import com.cx.restclient.exception.CxClientException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.ConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.slf4j.Log4jLoggerFactory;
import org.slf4j.Logger;

public class CxConsoleLauncher {
    private static final String SCA_PROJECT_NAME_INVALID_CHARS = "[\"`,:;\\\\|/'<>\\[\\]{}~]";
    private static org.apache.logging.log4j.Logger log;

    public static void main(String[] args) {
        int exitCode;
        Command command = null;
        try {
            CxConsoleLauncher.verifyArgsCount(args);
            args = CxConsoleLauncher.overrideProperties(args);
            args = CxConsoleLauncher.convertParamToLowerCase(args);
            CommandLine commandLine = CxConsoleLauncher.getCommandLine(args);
            command = CxConsoleLauncher.getCommand(commandLine);
            System.setProperty("cliLogPath", commandLine.getOptionValue("log", "." + File.separator + "logs" + File.separator + "cx_console.log"));
            System.setProperty("logLevel", commandLine.hasOption("v") ? "TRACE" : "INFO");
            Configurator.reconfigure();
            String logLocation = commandLine.getOptionValue("log", "." + File.separator + "logs" + File.separator + "cx_console.log");
            String logLevel = CxConsoleLauncher.getLogLevel(commandLine);
            CxConsoleLauncher.initFileLogging(logLocation, logLevel);
            exitCode = CxConsoleLauncher.execute(command, commandLine);
        }
        catch (CLIParsingException | ConfigurationException | ParseException e) {
            if (command == null) {
                String logLocation = "." + File.separator + "logs" + File.separator + "cx_console.log";
                String logLevel = "TRACE";
                CxConsoleLauncher.initFileLogging(logLocation, logLevel);
            }
            CxConfigHelper.printHelp(command);
            log.error(String.format("%n%n[CxConsole] Error parsing command: %n%s%n%n", e));
            exitCode = ErrorParsingHelper.parseError(e.getMessage());
        }
        catch (CxClientException | IOException | InterruptedException e) {
            log.error("CLI process terminated, error: " + e.getMessage());
            exitCode = ErrorParsingHelper.parseError(e.getMessage());
        }
        System.exit(exitCode);
    }

    private static void verifyArgsCount(String[] args) throws CLIParsingException {
        if (args.length == 0) {
            throw new CLIParsingException("No arguments were given");
        }
    }

    private static String[] overrideProperties(String[] args) {
        String propFilePath = null;
        for (int i = 0; i < args.length; ++i) {
            if (!"-propFile".equals(args[i])) continue;
            propFilePath = args[i + 1];
            break;
        }
        if (propFilePath != null) {
            try {
                log.info("Overriding properties from file: " + propFilePath);
                String argsStr = IOUtils.toString((InputStream)new FileInputStream(propFilePath), (Charset)Consts.UTF_8);
                args = argsStr.split("\\s+");
            }
            catch (Exception e) {
                log.error("can't read file", (Throwable)e);
            }
        }
        return args;
    }

    private static int execute(Command command, CommandLine commandLine) throws CLIParsingException, IOException, CxClientException, InterruptedException, ConfigurationException {
        ArrayList<ScanResults> results = new ArrayList<ScanResults>();
        int exitCode = Errors.SCAN_SUCCEEDED.getCode();
        CxConfigHelper.printConfig(commandLine);
        CxConfigHelper configHelper = new CxConfigHelper(commandLine.getOptionValue("config"));
        CxScanConfig cxScanConfig = configHelper.resolveConfiguration(command, commandLine);
        CxConsoleLauncher.validateScanParameters(cxScanConfig);
        Logger logger = (Logger)new Log4jLoggerFactory().getLogger(log.getName());
        CxSastConnectionProvider connectionProvider = new CxSastConnectionProvider(cxScanConfig, logger);
        CxClientDelegator clientDelegator = new CxClientDelegator(cxScanConfig, logger);
        ScanResults initScanResults = clientDelegator.init();
        results.add(initScanResults);
        if (command.equals((Object)Command.TEST_CONNECTION)) {
            if (cxScanConfig.getAstScaConfig() != null) {
                String accessControlUrl = cxScanConfig.getAstScaConfig().getAccessControlUrl();
                log.info("Testing connection to: " + accessControlUrl);
                clientDelegator.getScaClient().testScaConnection();
            } else {
                String url = cxScanConfig.getUrl();
                log.info("Testing connection to: " + url);
                connectionProvider.login();
            }
            log.info("Login successful");
            return exitCode;
        }
        if (command.equals((Object)Command.REVOKE_TOKEN)) {
            if (CxConsoleLauncher.cxTokenExists(commandLine)) {
                String token = cxScanConfig.getRefreshToken();
                token = DigestUtils.sha256Hex((String)token);
                log.info("Revoking access token: " + token);
                connectionProvider.revokeToken(cxScanConfig.getRefreshToken());
                return exitCode;
            }
            log.error("-CxToken flag is missing.");
            exitCode = Errors.GENERAL_ERROR.getCode();
            return exitCode;
        }
        if (command.equals((Object)Command.GENERATE_TOKEN)) {
            if (CxConsoleLauncher.userPasswordProvided(commandLine)) {
                String token = connectionProvider.getToken();
                log.info("The login token is: " + token);
                return exitCode;
            }
            log.error("-CxUser and -CxPassword flags are missing.");
            exitCode = Errors.GENERAL_ERROR.getCode();
            return exitCode;
        }
        ScanResults createScanResults = clientDelegator.initiateScan();
        results.add(createScanResults);
        if (cxScanConfig.getSynchronous().booleanValue()) {
            ScanResults scanResults = clientDelegator.waitForScanResults();
            results.add(scanResults);
            CxConsoleLauncher.getScanResultExceptionIfExists(results);
            if ((cxScanConfig.isSastEnabled() || cxScanConfig.isOsaEnabled()) && cxScanConfig.getEnablePolicyViolations() || cxScanConfig.isAstScaEnabled() && cxScanConfig.getEnablePolicyViolationsSCA()) {
                clientDelegator.printIsProjectViolated(scanResults);
            }
            ScanSummary scanSummary = new ScanSummary(cxScanConfig, scanResults.getSastResults(), scanResults.getOsaResults(), scanResults.getScaResults());
            String scanSummaryString = scanSummary.toString();
            if (scanSummary.hasErrors()) {
                log.info(scanSummaryString);
                exitCode = ErrorParsingHelper.getErrorType(scanSummary).getCode();
            }
        } else {
            CxConsoleLauncher.getScanResultExceptionIfExists(results);
            log.info("Scan is Running in Asynchronous mode. Not waiting for scan to finish.");
        }
        return exitCode;
    }

    private static void validateScanParameters(CxScanConfig cxScanConfig) throws CLIParsingException, CxClientException {
        if (cxScanConfig == null) {
            return;
        }
        if (cxScanConfig.isOsaEnabled() && cxScanConfig.getOsaDependenciesJson() != null && cxScanConfig.getOsaDependenciesJson().equals("EMPTY_JSON")) {
            throw new CxClientException("No dependencies found for OSA scan");
        }
        if (cxScanConfig.isAstScaEnabled() && CxConsoleLauncher.checkContainsSpecialChars(cxScanConfig.getProjectName(), SCA_PROJECT_NAME_INVALID_CHARS)) {
            throw new CLIParsingException("[CxConsole] SCA project name cannot contain special characters.");
        }
    }

    private static boolean checkContainsSpecialChars(String valueToCheck, String regex) {
        boolean check = false;
        if (!StringUtils.isEmpty((CharSequence)valueToCheck)) {
            Pattern my_pattern = Pattern.compile(regex, 2);
            Matcher my_match = my_pattern.matcher(valueToCheck);
            check = my_match.find();
        }
        return check;
    }

    private static void getScanResultExceptionIfExists(List<ScanResults> scanResults) {
        scanResults.forEach(scanResult -> {
            if (scanResult != null) {
                Map<ScannerType, Results> resultsMap = scanResult.getResults();
                for (Results value : resultsMap.values()) {
                    if (value == null || value.getException() == null) continue;
                    throw value.getException();
                }
            }
        });
    }

    private static CommandLine getCommandLine(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        return parser.parse(Command.getOptions(), args);
    }

    private static boolean cxTokenExists(CommandLine commandLine) {
        return commandLine.hasOption("cxtoken");
    }

    private static boolean userPasswordProvided(CommandLine commandLine) {
        return commandLine.hasOption("cxuser") && commandLine.hasOption("cxpassword");
    }

    private static Command getCommand(CommandLine commandLine) throws CLIParsingException {
        Command command;
        if (CxConsoleLauncher.countCommands(commandLine) < 2) {
            try {
                command = Command.getCommandByValue(commandLine.getArgs()[0]);
            }
            catch (Exception e) {
                throw new CLIParsingException(String.format("command [%s] is invalid, valid command must start with one of %s", "", Command.getAllValues()));
            }
            if (command == null) {
                throw new CLIParsingException(String.format("command [%s] is invalid, valid command must start with one of %s", commandLine.getArgs()[0], Command.getAllValues()));
            }
        } else {
            throw new CLIParsingException(String.format("Invalid command count, One command must be provided Only. One of these commands must be provided only %s. ", commandLine.getArgList()));
        }
        return command;
    }

    private static int countCommands(CommandLine commandLine) {
        int commandCount = 0;
        commandCount = commandLine.getArgList().size();
        return commandCount;
    }

    private static String[] convertParamToLowerCase(String[] args) {
        return (String[])Arrays.stream(args).map(arg -> arg.startsWith("-") && CxConsoleLauncher.isCliCmdOption(arg) ? arg.toLowerCase() : arg).toArray(String[]::new);
    }

    private static boolean isCliCmdOption(String argName) {
        Option argfound = Command.getOptions().getOption(argName.toLowerCase());
        return argfound != null && !StringUtils.isEmpty((CharSequence)argfound.getOpt().toString());
    }

    private static void initFileLogging(String logLocation, String logLevel) {
        System.setProperty("cliLogPath", logLocation);
        System.setProperty("logLevel", logLevel);
        log.debug("cliLogPath :" + logLocation);
        log.debug("logLevel :" + logLevel);
        Configurator.reconfigure();
    }

    private static String getLogLevel(CommandLine commandLine) {
        if (commandLine.hasOption("v")) {
            return "TRACE";
        }
        if (commandLine.hasOption("loglevel") && commandLine.getOptionValue("loglevel") != null) {
            return commandLine.getOptionValue("loglevel").toUpperCase();
        }
        return "INFO";
    }

    static {
        try {
            String log4jConfigFile = System.getProperty("user.dir") + File.separator + "log4j2.xml";
            ConfigurationSource source = new ConfigurationSource((InputStream)new FileInputStream(log4jConfigFile));
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception e) {
            System.out.println("Failed to use external log config file");
        }
        log = LogManager.getLogger(CxConsoleLauncher.class);
    }
}

