/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.whitesource.agent.api.model.ChecksumType;
import org.whitesource.agent.api.model.CopyrightInfo;
import org.whitesource.agent.api.model.DependencyHintsInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.api.model.ExclusionInfo;
import org.whitesource.agent.via.api.VulnerabilityAnalysisResult;

public class DependencyInfo
implements Serializable {
    private static final long serialVersionUID = -6212622409560068635L;
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String classifier;
    private String scope;
    private String sha1;
    private String headerSha1;
    private String footerSha1;
    private String utf8Sha1;
    private String fullHash;
    private String mostSigBitsHash;
    private String leastSigBitsHash;
    private String commentlessSha1;
    private String noNewLinesSha1;
    private String otherPlatformSha1;
    private String systemPath;
    private boolean optional;
    private Collection<DependencyInfo> children = new LinkedList<DependencyInfo>();
    private Collection<ExclusionInfo> exclusions = new LinkedList<ExclusionInfo>();
    private Collection<String> licenses = new LinkedList<String>();
    private Collection<CopyrightInfo> copyrights = new LinkedList<CopyrightInfo>();
    private Date lastModified;
    private String filename;
    private DependencyType dependencyType;
    private DependencyHintsInfo hints;
    private Map<ChecksumType, String> checksums = new TreeMap<ChecksumType, String>();
    private VulnerabilityAnalysisResult vulnerabilityAnalysisResult;
    private String commit;

    public DependencyInfo() {
    }

    public DependencyInfo(String groupId, String artifactId, String version) {
        this();
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public DependencyInfo(String sha1) {
        this();
        this.setSha1(sha1);
    }

    public DependencyInfo(String sha1, String fullHash) {
        this(sha1);
        this.setFullHash(fullHash);
    }

    public DependencyInfo(String sha1, String fullHash, String mostSigBitsHash, String leastSigBitsHash) {
        this(sha1, fullHash);
        this.setMostSigBitsHash(mostSigBitsHash);
        this.setLeastSigBitsHash(leastSigBitsHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DependencyInfo@").append(Integer.toHexString(this.hashCode())).append("[").append("groupId= ").append(this.groupId).append(",").append("artifactId= ").append(this.artifactId).append(",").append("version= ").append(this.version).append(",").append("filename= ").append(this.filename).append(",").append("dependencyType= ").append((Object)this.dependencyType).append(" ]");
        return sb.toString();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependencyInfo)) {
            return false;
        }
        DependencyInfo that = (DependencyInfo)o;
        if (StringUtils.isNotEmpty((String)this.sha1)) {
            return this.sha1.equals(that.sha1);
        }
        if (StringUtils.isNotEmpty((String)that.sha1)) {
            return false;
        }
        if (this.optional != that.optional) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(that.classifier) : that.classifier != null) {
            return false;
        }
        if (this.exclusions != null ? !this.exclusions.equals(that.exclusions) : that.exclusions != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.filename != null ? !this.filename.equals(that.filename) : that.filename != null) {
            return false;
        }
        if (this.dependencyType != null ? !this.dependencyType.equals((Object)that.dependencyType) : that.dependencyType != null) {
            return false;
        }
        if (this.systemPath != null ? !this.systemPath.equals(that.systemPath) : that.systemPath != null) {
            return false;
        }
        return !(this.vulnerabilityAnalysisResult != null ? !this.vulnerabilityAnalysisResult.equals((Object)that.vulnerabilityAnalysisResult) : that.vulnerabilityAnalysisResult != null);
    }

    public int hashCode() {
        int result = 133;
        result = 23 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
        result = 23 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 23 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 23 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 23 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 23 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 23 * result + (this.sha1 != null ? this.sha1.hashCode() : 0);
        result = 23 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
        result = 23 * result + (this.optional ? 1 : 0);
        result = 23 * result + (this.filename != null ? this.filename.hashCode() : 0);
        result = 23 * result + (this.dependencyType != null ? this.dependencyType.hashCode() : 0);
        result = 23 * result + (this.systemPath != null ? this.systemPath.hashCode() : 0);
        result = 23 * result + (this.vulnerabilityAnalysisResult != null ? this.vulnerabilityAnalysisResult.hashCode() : 0);
        return result;
    }

    public boolean hasLicenses() {
        return this.licenses != null && !this.licenses.isEmpty();
    }

    public boolean hasCopyrights() {
        return this.copyrights != null && !this.copyrights.isEmpty();
    }

    public void addChecksum(ChecksumType checksumType, String checksum) {
        if (StringUtils.isNotBlank((String)checksum)) {
            this.checksums.put(checksumType, checksum);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
        this.addChecksum(ChecksumType.SHA1, sha1);
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public void setSystemPath(String systemPath) {
        this.systemPath = systemPath;
    }

    public Collection<ExclusionInfo> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Collection<ExclusionInfo> exclusions) {
        this.exclusions = exclusions;
    }

    public boolean getOptional() {
        return this.optional;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Collection<DependencyInfo> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<DependencyInfo> children) {
        this.children = children;
    }

    public Collection<String> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(Collection<String> licenses) {
        this.licenses = licenses;
    }

    public Collection<CopyrightInfo> getCopyrights() {
        return this.copyrights;
    }

    public void setCopyrights(Collection<CopyrightInfo> copyrights) {
        this.copyrights = copyrights;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getHeaderSha1() {
        return this.headerSha1;
    }

    public void setHeaderSha1(String headerSha1) {
        this.headerSha1 = headerSha1;
    }

    public String getFooterSha1() {
        return this.footerSha1;
    }

    public void setFooterSha1(String footerSha1) {
        this.footerSha1 = footerSha1;
    }

    public String getUtf8Sha1() {
        return this.utf8Sha1;
    }

    public void setUtf8Sha1(String utf8Sha1) {
        this.utf8Sha1 = utf8Sha1;
        this.addChecksum(ChecksumType.SHA1_UTF8, utf8Sha1);
    }

    public String getCommentlessSha1() {
        return this.commentlessSha1;
    }

    public void setCommentlessSha1(String commentlessSha1) {
        this.commentlessSha1 = commentlessSha1;
        this.addChecksum(ChecksumType.SHA1_NO_COMMENTS, commentlessSha1);
    }

    public String getNoNewLinesSha1() {
        return this.noNewLinesSha1;
    }

    public void setNoNewLinesSha1(String noNewLinesSha1) {
        this.noNewLinesSha1 = noNewLinesSha1;
    }

    public String getOtherPlatformSha1() {
        return this.otherPlatformSha1;
    }

    public void setOtherPlatformSha1(String otherPlatformSha1) {
        this.otherPlatformSha1 = otherPlatformSha1;
        this.addChecksum(ChecksumType.SHA1_OTHER_PLATFORM, otherPlatformSha1);
    }

    public String getFullHash() {
        return this.fullHash;
    }

    public void setFullHash(String fullHash) {
        this.fullHash = fullHash;
        this.addChecksum(ChecksumType.SHA1_SUPER_HASH, fullHash);
    }

    public String getMostSigBitsHash() {
        return this.mostSigBitsHash;
    }

    public void setMostSigBitsHash(String mostSigBitsHash) {
        this.mostSigBitsHash = mostSigBitsHash;
        this.addChecksum(ChecksumType.SHA1_SUPER_HASH_MSB, mostSigBitsHash);
    }

    public String getLeastSigBitsHash() {
        return this.leastSigBitsHash;
    }

    public void setLeastSigBitsHash(String leastSigBitsHash) {
        this.leastSigBitsHash = leastSigBitsHash;
        this.addChecksum(ChecksumType.SHA1_SUPER_HASH_LSB, leastSigBitsHash);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public DependencyType getDependencyType() {
        return this.dependencyType;
    }

    public void setDependencyType(DependencyType dependencyType) {
        this.dependencyType = dependencyType;
    }

    public DependencyHintsInfo getHints() {
        return this.hints;
    }

    public void setHints(DependencyHintsInfo hints) {
        this.hints = hints;
    }

    public Map<ChecksumType, String> getChecksums() {
        return this.checksums;
    }

    public void setChecksums(Map<ChecksumType, String> checksums) {
        this.checksums = checksums;
    }

    public VulnerabilityAnalysisResult getVulnerabilityAnalysisResult() {
        return this.vulnerabilityAnalysisResult;
    }

    public void setVulnerabilityAnalysisResult(VulnerabilityAnalysisResult vulnerabilityAnalysisResult) {
        this.vulnerabilityAnalysisResult = vulnerabilityAnalysisResult;
    }

    public String getCommit() {
        return this.commit;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }
}

