/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExtensionUtils {
    public static final List<String> SOURCE_EXTENSIONS = Arrays.asList("c", "cc", "cp", "cpp", "cxx", "c\\+\\+", "h", "hh", "hpp", "hxx", "h\\+\\+", "m", "mm", "pch", "c#", "cs", "csharp", "go", "goc", "js", "pl", "plx", "pm", "ph", "cgi", "fcgi", "pod", "psgi", "al", "perl", "t", "pl6", "p6m", "p6l", "pm6", "nqp", "6pl", "6pm", "p6", "php", "py", "rb", "swift", "java", "clj", "cljx", "cljs", "cljc");
    public static final List<String> BINARY_EXTENSIONS = Arrays.asList("jar", "egg", "tar.gz", "tgz", "zip", "whl", "gem", "apk", "air", "dmg", "exe", "gem", "gzip", "msi", "nupkg", "swc", "swf", "tar.bz2", "pkg.tar.xz", "(u)?deb", "(a)?rpm");
    public static final List<String> ARCHIVE_EXTENSIONS = Arrays.asList("war", "ear", "zip", "whl", "tar.gz", "tgz", "tar");
    public static final String SOURCE_FILE_PATTERN;
    public static final String BINARY_FILE_PATTERN;
    public static final String ARCHIVE_FILE_PATTERN;
    public static final String[] INCLUDES;
    public static final String[] EXCLUDES;
    public static final String[] ARCHIVE_INCLUDES;
    public static final String[] ARCHIVE_EXCLUDES;

    private static String initializeRegexPattern(List<String> extensions) {
        StringBuilder sb = new StringBuilder();
        for (String extension : extensions) {
            sb.append(".*\\.");
            sb.append(extension);
            sb.append("|");
        }
        return sb.toString().substring(0, sb.toString().lastIndexOf("|"));
    }

    private static String[] initializeGlobPattern(List<String> extensions) {
        String[] globPatterns = new String[extensions.size()];
        for (int i = 0; i < extensions.size(); ++i) {
            globPatterns[i] = "**/*." + extensions.get(i);
        }
        return globPatterns;
    }

    static {
        EXCLUDES = new String[]{"**/*sources.jar", "**/*javadoc.jar", "**/tests/**"};
        ARCHIVE_EXCLUDES = new String[]{"**/*sources.jar", "**/*javadoc.jar", "**/tests/**"};
        SOURCE_FILE_PATTERN = ExtensionUtils.initializeRegexPattern(SOURCE_EXTENSIONS);
        BINARY_FILE_PATTERN = ExtensionUtils.initializeRegexPattern(BINARY_EXTENSIONS);
        ARCHIVE_FILE_PATTERN = ExtensionUtils.initializeRegexPattern(ARCHIVE_EXTENSIONS);
        ArrayList<String> allExtensions = new ArrayList<String>();
        allExtensions.addAll(SOURCE_EXTENSIONS);
        allExtensions.addAll(BINARY_EXTENSIONS);
        INCLUDES = ExtensionUtils.initializeGlobPattern(allExtensions);
        ARCHIVE_INCLUDES = ExtensionUtils.initializeGlobPattern(ARCHIVE_EXTENSIONS);
    }
}

