/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.whitesource.util.CxLogUtil;

public class FileWalker
implements Iterator<Path> {
    private final Logger logger = CxLogUtil.getLogger(FileWalker.class);
    final BlockingQueue<Path> pathBlockingQueue;

    public FileWalker(String scannerBaseDir, int size, String[] includes, String[] excludes) {
        this.pathBlockingQueue = new ArrayBlockingQueue<Path>(size);
        Thread thread = new Thread(() -> {
            final PathMatcher pathMatcherIncludes = FileSystems.getDefault().getPathMatcher("glob:{" + String.join((CharSequence)",", includes) + "}");
            final PathMatcher pathMatcherExcludes = FileSystems.getDefault().getPathMatcher("glob:{" + String.join((CharSequence)",", excludes) + "}");
            try {
                Files.walkFileTree(Paths.get(scannerBaseDir, new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            if (attrs.isSymbolicLink()) {
                                System.out.format("Symbolic link: %s ", file);
                            } else if (attrs.isRegularFile()) {
                                System.out.format("Regular file: %s ", file);
                            } else {
                                System.out.format("Other: %s ", file);
                            }
                            if (pathMatcherIncludes.matches(file) && !pathMatcherExcludes.matches(file)) {
                                FileWalker.this.pathBlockingQueue.offer(file, 4242L, TimeUnit.HOURS);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public Iterator<Path> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = false;
        long dropDeadMS = System.currentTimeMillis() + 2000L;
        while (System.currentTimeMillis() < dropDeadMS) {
            if (this.pathBlockingQueue.peek() != null) {
                hasNext = true;
                break;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return hasNext;
    }

    @Override
    public Path next() {
        Path path = null;
        try {
            path = this.pathBlockingQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return path;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static Iterable<String> getFileNames(String scannerBaseDir, String[] includes, String[] excludes, boolean followSymlinks, boolean globCaseSensitive) {
        final ArrayList<String> files = new ArrayList<String>();
        final PathMatcher pathMatcherIncludes = FileSystems.getDefault().getPathMatcher("glob:{" + String.join((CharSequence)",", includes) + "}");
        final PathMatcher pathMatcherExcludes = FileSystems.getDefault().getPathMatcher("glob:{" + String.join((CharSequence)",", excludes) + "}");
        try {
            final Path pathToScan = Paths.get(scannerBaseDir, new String[0]);
            Files.walkFileTree(pathToScan, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (pathMatcherIncludes.matches(path) && !pathMatcherExcludes.matches(path)) {
                        files.add(path.toString().replace(pathToScan.toString() + File.separator, ""));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return files;
    }

    public static Iterable<String> getAllFileNames(String scannerBaseDir, String[] includes, String[] excludes, boolean followSymlinks, boolean globCaseSensitive) {
        FileWalker z = null;
        try {
            z = new FileWalker(scannerBaseDir, 1024, includes, excludes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator<Path> i = z.iterator();
        ArrayList<String> files = new ArrayList<String>();
        while (i.hasNext()) {
            Path p = i.next();
            String s = p.toString().replace(scannerBaseDir, "");
            files.add(s);
        }
        return files;
    }
}

