/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.utils.CommandLineErrors;
import org.whitesource.util.CxLogUtil;

public class CommandLineProcess {
    private final Logger logger = CxLogUtil.getLogger(CommandLineProcess.class);
    private String rootDirectory;
    private String[] args;
    private long timeoutReadLineSeconds;
    private long timeoutProcessMinutes;
    private boolean errorInProcess = false;
    private Process processStart = null;
    private File errorLog = new File("error.log");
    private static int errCount = 1;
    private static final long DEFAULT_TIMEOUT_READLINE_SECONDS = 60L;
    private static final long DEFAULT_TIMEOUT_PROCESS_MINUTES = 15L;
    private static final String WINDOWS_SEPARATOR = "\\";
    private static final SimpleDateFormat DF = new SimpleDateFormat("MMddHHmmss");
    private static final String OSA_ERROR_FOLDER_PATH = String.format(File.separator + "osa-logs" + File.separator + "scan-%s" + File.separator + "error", DF.format(new Timestamp(System.currentTimeMillis())));
    private static final String OSA_ERROR_FILE = File.separator + "errcmd";
    private static final String OSA_ERROR_FILE_EXT = ".log";

    public CommandLineProcess(String rootDirectory, String[] args) {
        this.rootDirectory = rootDirectory;
        this.args = args;
        this.timeoutReadLineSeconds = this.initReadlineTimeout();
        this.timeoutProcessMinutes = this.initProcessTimeout();
    }

    private boolean enrichErrLogs() {
        try {
            String isErrLogs = System.getenv("FSA_ENRICH_ERR_LOGS");
            String string = isErrLogs = StringUtils.isNotEmpty((String)isErrLogs) ? isErrLogs : System.getProperty("FSA_ENRICH_ERR_LOGS");
            if (StringUtils.isNotEmpty((String)isErrLogs)) {
                return Boolean.parseBoolean(isErrLogs);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getErrLogPath() {
        String errDir = System.getenv("FSA_ERR_LOGS_PATH");
        errDir = StringUtils.isNotEmpty((String)errDir) ? errDir : System.getProperty("FSA_ERR_LOGS_PATH");
        return this.isDirExist(errDir) ? errDir : System.getProperty("user.dir");
    }

    private boolean isDirExist(String path) {
        if (StringUtils.isNotEmpty((String)path)) {
            File dir = new File(path);
            try {
                return dir.exists() && dir.isDirectory();
            }
            catch (Exception e) {
                this.logger.warn("Fail to set FSA error logs folder on: " + path);
            }
        }
        return false;
    }

    private long initReadlineTimeout() {
        try {
            String readlineTimeout = System.getenv("FSA_READLINE_TIMEOUT");
            String string = readlineTimeout = StringUtils.isNotEmpty((String)readlineTimeout) ? readlineTimeout : System.getProperty("FSA_READLINE_TIMEOUT");
            if (StringUtils.isNotEmpty((String)readlineTimeout)) {
                return Long.parseLong(readlineTimeout);
            }
            return 60L;
        }
        catch (Exception e) {
            return 60L;
        }
    }

    private long initProcessTimeout() {
        try {
            String processTimeout = System.getenv("FSA_PROCESS_TIMEOUT");
            String string = processTimeout = StringUtils.isNotEmpty((String)processTimeout) ? processTimeout : System.getProperty("FSA_PROCESS_TIMEOUT");
            if (StringUtils.isNotEmpty((String)processTimeout)) {
                return Long.parseLong(processTimeout);
            }
            return 15L;
        }
        catch (Exception e) {
            return 15L;
        }
    }

    private boolean isUncPath() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return StringUtils.isNotEmpty((String)this.rootDirectory) && this.rootDirectory.startsWith("\\\\");
        }
        return false;
    }

    public List<String> executeProcess() throws IOException {
        return this.executeProcess(true, false);
    }

    private boolean isWinCmd() {
        try {
            return this.args[0].equalsIgnoreCase("cmd") && this.args[1].equalsIgnoreCase("/c");
        }
        catch (Exception e) {
            return false;
        }
    }

    private List<String> executeProcess(boolean includeOutput, boolean includeErrorLines) throws IOException {
        String redirectErrorOutput;
        ProcessBuilder pb;
        LinkedList<String> linesOutput = new LinkedList<String>();
        if (this.isUncPath()) {
            if (this.isWinCmd()) {
                this.args = (String[])ArrayUtils.add((Object[])this.args, (int)2, (Object)"pushd");
                this.args = (String[])ArrayUtils.add((Object[])this.args, (int)3, (Object)this.rootDirectory);
                this.args = (String[])ArrayUtils.add((Object[])this.args, (int)4, (Object)"&&");
            } else {
                this.args = (String[])ArrayUtils.add((Object[])this.args, (int)0, (Object)"pushd");
                this.args = (String[])ArrayUtils.add((Object[])this.args, (int)1, (Object)this.rootDirectory);
                this.args = (String[])ArrayUtils.add((Object[])this.args, (int)2, (Object)"&&");
            }
            this.args = (String[])ArrayUtils.add((Object[])this.args, (int)this.args.length, (Object)"&&");
            this.args = (String[])ArrayUtils.add((Object[])this.args, (int)this.args.length, (Object)"popd");
            pb = new ProcessBuilder(this.args);
            pb.directory(new File(System.getProperty("user.home")));
        } else {
            pb = new ProcessBuilder(this.args);
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                this.rootDirectory = this.getShortPath(this.rootDirectory);
            }
            pb.directory(new File(this.rootDirectory));
        }
        String string = redirectErrorOutput = DependencyCollector.isWindows() ? "nul" : "/dev/null";
        if (includeErrorLines) {
            pb.redirectError(this.errorLog);
        } else {
            pb.redirectError(new File(redirectErrorOutput));
        }
        if (!includeOutput || includeErrorLines) {
            pb.redirectOutput(new File(redirectErrorOutput));
        }
        if (!includeErrorLines) {
            this.logger.info("Executing command:");
            this.logger.info("{}> {}", (Object)this.rootDirectory, (Object)String.join((CharSequence)" ", this.args));
        }
        this.processStart = pb.start();
        if (includeOutput) {
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            InputStreamReader inputStreamReader = !includeErrorLines ? new InputStreamReader(this.processStart.getInputStream()) : new InputStreamReader(this.processStart.getErrorStream());
            BufferedReader reader = new BufferedReader(inputStreamReader);
            try {
                this.errorInProcess = this.readBlock(inputStreamReader, reader, executorService, linesOutput, includeErrorLines);
            }
            catch (TimeoutException e) {
                this.errorInProcess = true;
                CommandLineErrors.addFailedCmd(Arrays.toString(this.args));
                this.processStart.destroy();
                return linesOutput;
            }
        }
        try {
            this.processStart.waitFor(this.timeoutProcessMinutes, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.errorInProcess = true;
            CommandLineErrors.addFailedCmd(Arrays.toString(this.args));
            this.logger.error("'{}' was interrupted {}", (Object)this.args, (Object)e);
        }
        if (this.processStart.isAlive() && this.errorInProcess) {
            this.logger.warn("Error executing command destroying process");
            this.processStart.destroy();
            return linesOutput;
        }
        if (this.getExitStatus() != 0) {
            File dir = new File(this.rootDirectory);
            int numOfFiles = dir.exists() ? FileUtils.listFiles((File)dir, null, (boolean)true).size() : -1;
            this.logger.error("Execute command finished unexpected, exit code: '{}', directory: {}, is directory valid: {}, folder content size: {}, Output:", new Object[]{this.getExitStatus(), this.rootDirectory, dir.exists(), numOfFiles});
            if (this.enrichErrLogs()) {
                this.logErrors(linesOutput);
                ++errCount;
            }
            this.errorInProcess = true;
            CommandLineErrors.addFailedCmd(Arrays.toString(this.args));
        }
        return linesOutput;
    }

    private void logErrors(List<String> lines) {
        try {
            File errDir = new File(this.getErrLogPath() + OSA_ERROR_FOLDER_PATH);
            if (!errDir.exists()) {
                errDir.mkdirs();
            }
            String filePath = errCount == 1 ? errDir.getAbsolutePath() + OSA_ERROR_FILE + OSA_ERROR_FILE_EXT : errDir.getAbsolutePath() + OSA_ERROR_FILE + errCount + OSA_ERROR_FILE_EXT;
            this.logger.info("Failed command: '" + Arrays.toString(this.args) + "', error log: " + filePath);
            try (FileWriter writer = new FileWriter(filePath);){
                writer.write("##### Failed command #####" + System.lineSeparator());
                writer.write(Arrays.toString(this.args) + System.lineSeparator());
                writer.write("##########################" + System.lineSeparator() + System.lineSeparator());
                for (String line : lines) {
                    writer.write(line + System.lineSeparator());
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Fail to create error log for command: " + Arrays.toString(this.args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printErrors() {
        if (this.errorLog.isFile()) {
            try {
                String currLine;
                FileReader fileReader = new FileReader(this.errorLog);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((currLine = bufferedReader.readLine()) != null) {
                    this.logger.warn(currLine);
                }
                fileReader.close();
            }
            catch (Exception e) {
                this.logger.warn("Error printing cmd command errors {} ", (Object)e.getMessage());
                this.logger.error("Error: {}", (Object[])e.getStackTrace());
            }
            finally {
                try {
                    FileUtils.forceDelete((File)this.errorLog);
                }
                catch (IOException e) {
                    this.logger.warn("Error closing cmd command errors file {} ", (Object)e.getMessage());
                    this.logger.error("Error: {}", (Object[])e.getStackTrace());
                }
            }
        }
    }

    private String getShortPath(String rootPath) {
        File file = new File(rootPath);
        String lastPathAfterSeparator = null;
        String shortPath = this.getWindowsShortPath(file.getAbsolutePath());
        if (StringUtils.isNotEmpty((String)shortPath)) {
            return this.getWindowsShortPath(file.getAbsolutePath());
        }
        while (StringUtils.isEmpty((String)this.getWindowsShortPath(file.getAbsolutePath()))) {
            String filePath = file.getAbsolutePath();
            lastPathAfterSeparator = StringUtils.isNotEmpty(lastPathAfterSeparator) ? file.getAbsolutePath().substring(filePath.lastIndexOf(WINDOWS_SEPARATOR), filePath.length()) + lastPathAfterSeparator : file.getAbsolutePath().substring(filePath.lastIndexOf(WINDOWS_SEPARATOR), filePath.length());
            file = file.getParentFile();
        }
        return this.getWindowsShortPath(file.getAbsolutePath()) + lastPathAfterSeparator;
    }

    private String getWindowsShortPath(String path) {
        if (path.length() >= 256) {
            char[] result = new char[256];
            Kernel32.INSTANCE.GetShortPathName(path, result, result.length);
            return Native.toString((char[])result);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readBlock(InputStreamReader inputStreamReader, BufferedReader reader, ExecutorService executorService, List<String> lines, boolean includeErrorLines) throws TimeoutException {
        boolean wasError = false;
        boolean continueReadingLines = true;
        boolean timeout = false;
        try {
            if (!includeErrorLines) {
                this.logger.debug("trying to read lines using '{}'", (Object)Arrays.toString(this.args));
            }
            int lineIndex = 1;
            String line = "";
            while (continueReadingLines && line != null) {
                Future<String> future = executorService.submit(new ReadLineTask(reader));
                try {
                    line = future.get(this.timeoutReadLineSeconds, TimeUnit.SECONDS);
                    if (!includeErrorLines) {
                        if (StringUtils.isNotBlank((String)line)) {
                            this.logger.debug("Read line #{}: {}", (Object)lineIndex, (Object)line);
                            lines.add(line);
                        } else {
                            this.logger.debug("Finished reading {} lines", (Object)(lineIndex - 1));
                        }
                    } else if (StringUtils.isNotBlank((String)line)) {
                        lines.add(line);
                    }
                }
                catch (TimeoutException e) {
                    this.logger.debug("Received timeout when reading line #" + lineIndex, (Object[])e.getStackTrace());
                    this.logger.warn("Failed reading line, probably user input is expected.");
                    inputStreamReader = null;
                    reader = null;
                    continueReadingLines = false;
                    wasError = true;
                    timeout = true;
                }
                catch (Exception e) {
                    this.logger.debug("Error reading line #" + lineIndex, (Object[])e.getStackTrace());
                    continueReadingLines = false;
                    wasError = true;
                }
                ++lineIndex;
            }
        }
        catch (Exception e) {
            this.logger.error("error parsing output : {}", (Object[])e.getStackTrace());
        }
        finally {
            executorService.shutdown();
            IOUtils.closeQuietly((Closeable)inputStreamReader);
            IOUtils.closeQuietly((Closeable)reader);
        }
        if (timeout) {
            throw new TimeoutException("Failed reading line, probably user input is expected.");
        }
        return wasError;
    }

    public void executeProcessWithoutOutput() throws IOException {
        this.executeProcess(false, false);
    }

    public List<String> executeProcessWithErrorOutput() throws IOException {
        return this.executeProcess(false, true);
    }

    public void setTimeoutReadLineSeconds(long timeoutReadLineSeconds) {
        this.timeoutReadLineSeconds = timeoutReadLineSeconds;
    }

    public void setTimeoutProcessMinutes(long timeoutProcessMinutes) {
        this.timeoutProcessMinutes = timeoutProcessMinutes;
    }

    public boolean isErrorInProcess() {
        return this.errorInProcess;
    }

    public int getExitStatus() {
        if (this.processStart != null) {
            return this.processStart.exitValue();
        }
        return 0;
    }

    class ReadLineTask
    implements Callable<String> {
        private final BufferedReader reader;

        ReadLineTask(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public String call() throws Exception {
            return this.reader.readLine();
        }
    }
}

