/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.python;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.dotNet.DotNetRestoreCollector;
import org.whitesource.agent.dependency.resolver.python.PythonDependencyCollector;
import org.whitesource.agent.utils.FilesUtils;

public class PythonDependencyResolver
extends AbstractDependencyResolver {
    private final String pythonPath;
    private final String pipPath;
    private final boolean ignoreSourceFiles;
    private final boolean ignorePipEnvInstallErrors;
    private final boolean runPipenvPreStep;
    private final boolean pipenvInstallDevDependencies;
    private Collection<String> excludes = new ArrayList<String>();
    private boolean ignorePipInstallErrors;
    private boolean installVirutalenv;
    private boolean resolveHierarchyTree;
    private String[] pythonRequirementsFileIncludes;
    public String PYTHON_REGEX = "\\\\";
    private static final String PY_EXT = ".py";
    public static final String WHITESOURCE_PYTHON_TEMP_FOLDER = "Whitesource_python_resolver";
    public static final String DIRECT = "_direct";

    public PythonDependencyResolver(String pythonPath, String pipPath, boolean ignorePipInstallErrors, boolean installVirtualEnv, boolean resolveHierarchyTree, String[] pythonRequirementsFileIncludes, boolean ignoreSourceFiles, boolean ignorePipEnvInstallErrors, boolean runPipenvPreStep, boolean pipenvInstallDevDependencies) {
        this.pythonPath = pythonPath;
        this.pipPath = pipPath;
        this.ignorePipInstallErrors = ignorePipInstallErrors;
        this.installVirutalenv = installVirtualEnv;
        this.resolveHierarchyTree = resolveHierarchyTree;
        this.pythonRequirementsFileIncludes = pythonRequirementsFileIncludes;
        this.ignoreSourceFiles = ignoreSourceFiles;
        this.ignorePipEnvInstallErrors = ignorePipEnvInstallErrors;
        this.runPipenvPreStep = runPipenvPreStep;
        this.pipenvInstallDevDependencies = pipenvInstallDevDependencies;
    }

    @Override
    public ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> dependenciesFiles) {
        if (this.ignoreSourceFiles) {
            this.excludes = Arrays.asList("**/*.py");
        }
        FilesUtils filesUtils = new FilesUtils();
        Collection<Object> resultDependencies = new LinkedList();
        Collection<Object> dependencyInfos = new LinkedList();
        String pipFilePath = projectFolder + DotNetRestoreCollector.BACK_SLASH + "Pipfile";
        if (Paths.get(pipFilePath, new String[0]).toFile().exists()) {
            resultDependencies = this.runPipEnvAlgorithm(filesUtils, pipFilePath);
        } else {
            dependencyInfos = this.runPipAlgorithm(filesUtils, dependenciesFiles);
            resultDependencies.addAll(dependencyInfos);
        }
        return new ResolutionResult(resultDependencies, this.getExcludes(), this.getDependencyType(), topLevelFolder);
    }

    private Collection<DependencyInfo> runPipAlgorithm(FilesUtils filesUtils, Set<String> dependenciesFiles) {
        LinkedList<DependencyInfo> resultDependencies = new LinkedList<DependencyInfo>();
        for (String dependencyFile : dependenciesFiles) {
            String tempDirVirtualEnv = filesUtils.createTmpFolder(true, WHITESOURCE_PYTHON_TEMP_FOLDER);
            String tempDirPackages = filesUtils.createTmpFolder(false, WHITESOURCE_PYTHON_TEMP_FOLDER);
            String tempDirDirectPackages = filesUtils.createTmpFolder(false, "Whitesource_python_resolver_direct");
            Collection dependencies = new LinkedList();
            if (tempDirVirtualEnv != null && tempDirPackages != null) {
                PythonDependencyCollector pythonDependencyCollector = new PythonDependencyCollector(this.pythonPath, this.pipPath, this.installVirutalenv, this.resolveHierarchyTree, this.ignorePipInstallErrors, dependencyFile, tempDirPackages, tempDirVirtualEnv, tempDirDirectPackages);
                String currentTopLevelFolder = dependencyFile.substring(0, dependencyFile.replaceAll(this.PYTHON_REGEX, "/").lastIndexOf("/"));
                Collection<AgentProjectInfo> projects = pythonDependencyCollector.collectDependencies(currentTopLevelFolder);
                dependencies = projects.stream().flatMap(project -> project.getDependencies().stream()).collect(Collectors.toList());
                FilesUtils.deleteDirectory(new File(tempDirVirtualEnv));
                FilesUtils.deleteDirectory(new File(tempDirPackages));
                FilesUtils.deleteDirectory(new File(tempDirDirectPackages));
            }
            resultDependencies.addAll(dependencies);
        }
        return resultDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DependencyInfo> runPipEnvAlgorithm(FilesUtils filesUtils, String pipfilePath) {
        String tempDirPackages = null;
        LinkedList<DependencyInfo> dependencies = new LinkedList();
        try {
            tempDirPackages = filesUtils.createTmpFolder(true, WHITESOURCE_PYTHON_TEMP_FOLDER);
            String dependencyFile = pipfilePath;
            PythonDependencyCollector pythonDependencyCollector = new PythonDependencyCollector(this.ignorePipEnvInstallErrors, this.runPipenvPreStep, tempDirPackages, this.pythonPath, this.pipPath, this.pipenvInstallDevDependencies);
            String currentTopLevelFolder = dependencyFile.substring(0, dependencyFile.replaceAll(this.PYTHON_REGEX, "/").lastIndexOf("/"));
            Collection<AgentProjectInfo> projects = pythonDependencyCollector.collectDependencies(currentTopLevelFolder);
            dependencies = projects.stream().flatMap(project -> project.getDependencies().stream()).collect(Collectors.toList());
        }
        finally {
            if (tempDirPackages != null) {
                FilesUtils.deleteDirectory(new File(tempDirPackages));
            }
        }
        return dependencies;
    }

    @Override
    protected Collection<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return new ArrayList<String>(Arrays.asList(PY_EXT));
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.PYTHON;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.PYTHON.name();
    }

    @Override
    public String[] getBomPattern() {
        return this.pythonRequirementsFileIncludes;
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return new ArrayList<String>();
    }

    public String getPythonPath() {
        return this.pythonPath;
    }

    public String getPipPath() {
        return this.pipPath;
    }
}

