/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.python;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.dependency.resolver.python.DependenciesFileType;
import org.whitesource.agent.dependency.resolver.python.PythonDependencyResolver;
import org.whitesource.agent.hash.ChecksumUtils;
import org.whitesource.agent.utils.CommandLineProcess;
import org.whitesource.agent.utils.FilesUtils;
import org.whitesource.util.CxLogUtil;

public class PythonDependencyCollector
extends DependencyCollector {
    private boolean installVirtualEnv;
    private boolean resolveHierarchyTree;
    private boolean ignorePipInstallErrors;
    private boolean ignorePipEnvInstallErrors;
    private boolean runPipEnvPreStep;
    private boolean pipenvInstallDevDependencies;
    private String requirementsTxtOrSetupPyPath;
    private String pythonPath;
    private String pipPath;
    private String tempDirPackages;
    private String tempDirVirtualenv;
    private String topLevelFolder;
    private AtomicInteger counterFolders = new AtomicInteger(0);
    private DependenciesFileType dependencyFileType;
    private String tempDirDirectPackages;
    private final Logger logger = CxLogUtil.getLogger(PythonDependencyResolver.class);
    private static final String VIRTUALENV = "virtualenv";
    private static final String USER = "--user";
    private static final String SOURCE = "source";
    private static final String BIN_ACTIVATE = "/env/bin/activate";
    private static final String SCRIPTS_ACTIVATE = "\\env\\Scripts\\activate.bat";
    private static final String AND = "&&";
    private static final String PIPDEPTREE = "pipdeptree";
    private static final String M = "-m";
    private static final String ENV = "/env";
    private static final String JSON_TREE = "--json-tree";
    private static final String HIERARCHY_TREE_TXT = "/HierarchyTree.txt";
    private static final String PACKAGE_NAME = "package_name";
    private static final String INSTALLED_VERSION = "installed_version";
    private static final String DEPENDENCIES = "dependencies";
    private static final String LOWER_COMMA = "_";
    private static final String F = "-f";
    private static final String COMMA = "-";
    private static final String EMPTY_STRING = "";
    private static final String DOWNLOAD = "download";
    private static final String INSTALL = "install";
    private static final String R_PARAMETER = "-r";
    private static final String D_PARAMETER = "-d";
    private static final String COMMENT_SIGN_PYTHON = "#";
    private static final int NUM_THREADS = 8;
    private static final String FORWARD_SLASH = "/";
    private static final String SCRIPT_SH = "/script.sh";
    private static final String BIN_BASH = "#!/bin/bash";
    private static final String ARROW = ">";
    private static final String NO_DEPS = "--no-deps";
    private static final String[] DEFAULT_PACKAGES_IN_PIPDEPTREE = new String[]{"pipdeptree", "setuptools", "wheel"};
    private static final String APOSTROPHE = "'";
    private static final String PIPENV = "pipenv";
    private static final String GRAPH = "graph";
    private static final String RUN = "run";
    private static final String DEV = "--dev";
    private static final String LOCK = "lock";

    public PythonDependencyCollector(String pythonPath, String pipPath, boolean installVirtualEnv, boolean resolveHierarchyTree, boolean ignorePipInstallErrors, String requirementsTxtOrSetupPyPath, String tempDirPackages, String tempDirVirtualEnv, String tempDirDirectPackages) {
        this.pythonPath = pythonPath;
        this.pipPath = pipPath;
        this.installVirtualEnv = installVirtualEnv;
        this.resolveHierarchyTree = resolveHierarchyTree;
        if (requirementsTxtOrSetupPyPath.endsWith("setup.py")) {
            requirementsTxtOrSetupPyPath = requirementsTxtOrSetupPyPath.substring(0, requirementsTxtOrSetupPyPath.length() - ("setup.py".length() + 1));
            this.dependencyFileType = DependenciesFileType.SETUP_PY;
        } else {
            this.dependencyFileType = DependenciesFileType.REQUIREMENTS_TXT;
        }
        this.requirementsTxtOrSetupPyPath = requirementsTxtOrSetupPyPath;
        this.tempDirPackages = tempDirPackages;
        this.tempDirVirtualenv = tempDirVirtualEnv;
        this.tempDirDirectPackages = tempDirDirectPackages;
        this.ignorePipInstallErrors = ignorePipInstallErrors;
    }

    public PythonDependencyCollector(boolean ignorePipEnvInstallErrors, boolean runPipEnvPreStep, String tempDirPackages, String pythonPath, String pipPath, boolean pipenvInstallDevDependencies) {
        this.pythonPath = pythonPath;
        this.pipPath = pipPath;
        this.ignorePipEnvInstallErrors = ignorePipEnvInstallErrors;
        this.dependencyFileType = DependenciesFileType.PIPFILE;
        this.tempDirPackages = tempDirPackages;
        this.runPipEnvPreStep = runPipEnvPreStep;
        this.pipenvInstallDevDependencies = pipenvInstallDevDependencies;
    }

    @Override
    public Collection<AgentProjectInfo> collectDependencies(String topLevelFolder) {
        List<DependencyInfo> dependencies;
        this.topLevelFolder = topLevelFolder;
        if (this.dependencyFileType.equals((Object)DependenciesFileType.PIPFILE)) {
            this.logger.debug("Found pipfile, running pipenv algorithm");
            dependencies = this.runPipEnvAlgorithm();
        } else {
            this.logger.debug("Found requiremrents or setup file, running pip algorithm");
            dependencies = this.runPipAlgorithm();
        }
        return this.getSingleProjectList(dependencies);
    }

    private List<DependencyInfo> runPipAlgorithm() {
        List<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        boolean failed = false;
        boolean virtualEnvInstalled = true;
        if (this.installVirtualEnv && this.resolveHierarchyTree) {
            try {
                String pipOpt = this.getPipOptions();
                virtualEnvInstalled = StringUtils.isNotEmpty((String)pipOpt) ? !this.processCommand(new String[]{this.pythonPath, M, this.pipPath, INSTALL, pipOpt, USER, VIRTUALENV}, true) : !this.processCommand(new String[]{this.pythonPath, M, this.pipPath, INSTALL, USER, VIRTUALENV}, true);
            }
            catch (IOException e) {
                virtualEnvInstalled = false;
            }
        }
        if (virtualEnvInstalled) {
            try {
                this.logger.debug("Collecting python dependencies. It might take a few minutes.");
                if (this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
                    failed = this.processCommand(new String[]{this.pipPath, DOWNLOAD, R_PARAMETER, this.requirementsTxtOrSetupPyPath, D_PARAMETER, this.tempDirPackages}, true);
                } else if (this.dependencyFileType == DependenciesFileType.SETUP_PY) {
                    failed = this.processCommand(new String[]{this.pipPath, DOWNLOAD, this.requirementsTxtOrSetupPyPath, D_PARAMETER, this.tempDirPackages}, true);
                }
                if (failed) {
                    String error = null;
                    if (this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
                        error = "Fail to run 'pip install -r " + this.requirementsTxtOrSetupPyPath + APOSTROPHE;
                    } else if (this.dependencyFileType == DependenciesFileType.SETUP_PY) {
                        error = "Fail to run 'pip install " + this.requirementsTxtOrSetupPyPath + APOSTROPHE;
                    }
                    this.logger.warn("{}. To see the full error, re-run the plugin with this parameter in the config file: log.level=debug", error);
                } else if (!failed && !this.resolveHierarchyTree) {
                    dependencies = this.collectDependencies(new File(this.tempDirPackages), this.requirementsTxtOrSetupPyPath);
                } else if (!failed && this.resolveHierarchyTree) {
                    boolean failedGetTree = this.getTree(this.requirementsTxtOrSetupPyPath);
                    if (!failedGetTree) {
                        dependencies = this.collectDependenciesWithTree(this.tempDirVirtualenv + HIERARCHY_TREE_TXT, this.requirementsTxtOrSetupPyPath);
                        if (this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
                            this.fixDependencies(dependencies);
                        }
                    } else {
                        dependencies = this.collectDependencies(new File(this.tempDirPackages), this.requirementsTxtOrSetupPyPath);
                    }
                }
                if (failed && this.ignorePipInstallErrors && this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
                    this.logger.info("Try to download each dependency in " + this.requirementsTxtOrSetupPyPath + " file one by one. It might take a few minutes.");
                    FilesUtils.deleteDirectory(new File(this.tempDirPackages));
                    this.tempDirPackages = new FilesUtils().createTmpFolder(false, "Whitesource_python_resolver");
                    if (this.tempDirPackages != null) {
                        this.downloadLineByLine(this.requirementsTxtOrSetupPyPath);
                        dependencies = this.collectDependencies(new File(this.tempDirPackages), this.requirementsTxtOrSetupPyPath);
                        FilesUtils.deleteDirectory(new File(this.tempDirPackages));
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn("Cannot read the requirements.txt file");
            }
            catch (Exception e) {
                this.logger.error("Fail while reading the requirements.txt file", (Throwable)e);
            }
        } else {
            this.logger.warn("Virutalenv package installation failed");
        }
        return dependencies;
    }

    private List<DependencyInfo> runPipEnvAlgorithm() {
        Set<String> dependencyNamesVersions;
        List<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        if (this.runPipEnvPreStep) {
            this.logger.debug("Running PipEnv PreStep");
            if (this.pipenvInstallDevDependencies) {
                this.runPipEnvInstallCommand(new String[]{PIPENV, INSTALL, DEV});
            } else {
                this.runPipEnvInstallCommand(new String[]{PIPENV, INSTALL});
            }
        }
        this.logger.info("Running dependency tree with 'pipenv graph'");
        String requirementsTempFile = this.tempDirPackages + "\\" + "requirements.txt";
        List<String> lines = this.commandLineRunner(this.topLevelFolder, new String[]{PIPENV, GRAPH});
        if (!this.isEmpty(lines)) {
            this.logger.info("Parsing dependency tree");
            dependencyNamesVersions = this.parsePipEnvGraph(lines);
        } else {
            this.logger.warn("pipenv graph failed, getting dependencies directly from pipfile");
            lines = this.commandLineRunner(this.topLevelFolder, new String[]{PIPENV, LOCK, R_PARAMETER, DEV});
            List<String> lines1 = this.commandLineRunner(this.topLevelFolder, new String[]{PIPENV, LOCK, R_PARAMETER});
            lines.addAll(lines1);
            dependencyNamesVersions = this.parsePipFile(lines);
        }
        if (dependencyNamesVersions != null) {
            try (FileWriter fw = new FileWriter(new File(requirementsTempFile));){
                for (String dependencyNamesVersion : dependencyNamesVersions) {
                    fw.write(dependencyNamesVersion + "\n");
                }
            }
            catch (IOException e) {
                this.logger.warn("Cannot create a file to write in temp folder {}", (Object)e.getMessage());
                this.logger.debug("Cannot create a file to write in temp folder, Error: {}", (Object[])e.getStackTrace());
            }
        } else {
            this.logger.warn("pipenv graph anad pipfile.lock failed please try to turn python.runPipenvPreStep to run pipenv install");
        }
        try {
            this.logger.info("downloading packages");
            boolean failed = this.processCommand(new String[]{PIPENV, RUN, this.pipPath, DOWNLOAD, R_PARAMETER, requirementsTempFile, D_PARAMETER, this.tempDirPackages}, true);
            if (failed && this.ignorePipEnvInstallErrors) {
                this.logger.info("Failed to download all dependencies at once, Try to install dependencies one by one. It might take a few minutes.");
                for (String dependencyNamesVersion : dependencyNamesVersions) {
                    failed = this.processCommand(new String[]{PIPENV, RUN, this.pipPath, DOWNLOAD, dependencyNamesVersion, D_PARAMETER, this.tempDirPackages}, true);
                    if (!failed) continue;
                    this.logger.warn("pipenv run pip download {} failed to execute", (Object)dependencyNamesVersion);
                }
            }
            dependencies = this.collectDependencies(new File(this.tempDirPackages), this.topLevelFolder);
        }
        catch (IOException e) {
            this.logger.warn("downloading dependencies failed: {}", (Object)e.getMessage());
            this.logger.debug("downloading dependencies failed: {}", (Object[])e.getStackTrace());
        }
        return dependencies;
    }

    private Set<String> parsePipEnvGraph(List<String> lines) {
        HashSet<String> dependencyLines = new HashSet<String>();
        for (String line : lines) {
            this.logger.debug(line);
            if (line.contains("==")) {
                dependencyLines.add(line);
                continue;
            }
            String artifactId = line.substring(line.indexOf(COMMA) + 2, line.indexOf(91) - 1);
            String version = line.substring(line.lastIndexOf(" ") + 1, line.indexOf(93));
            dependencyLines.add(artifactId + "==" + version);
        }
        return dependencyLines;
    }

    private String getPipOptions() {
        String nugetOpt = System.getenv("CX_PIP_OPTIONS");
        return StringUtils.isNotEmpty((String)nugetOpt) ? nugetOpt : System.getProperty("CX_PIP_OPTIONS");
    }

    private void fixDependencies(Collection<DependencyInfo> dependencies) {
        this.logger.debug("Trying to get all the direct dependencies.");
        boolean failed = false;
        try {
            if (this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
                failed = this.processCommand(new String[]{this.pipPath, DOWNLOAD, R_PARAMETER, this.requirementsTxtOrSetupPyPath, NO_DEPS, D_PARAMETER, this.tempDirDirectPackages}, true);
            }
            if (!failed) {
                this.findDirectDependencies(dependencies);
            } else {
                this.logger.debug("Cannot download direct dependencies.");
            }
        }
        catch (IOException e) {
            this.logger.debug("Cannot download direct dependencies.");
        }
    }

    private void findDirectDependencies(Collection<DependencyInfo> dependencies) {
        File directDependenciesFolder = new File(this.tempDirDirectPackages);
        File[] directDependenciesFiles = directDependenciesFolder.listFiles();
        if (directDependenciesFiles.length > dependencies.size()) {
            int missingDirectDependencies = directDependenciesFiles.length - dependencies.size();
            this.logger.debug("There are {} missing direct dependencies", (Object)missingDirectDependencies);
            int i = 0;
            while (missingDirectDependencies > 0) {
                boolean found = false;
                File directDependencyToCheck = directDependenciesFiles[i];
                for (DependencyInfo dependency : dependencies) {
                    if (!dependency.getArtifactId().equals(directDependencyToCheck.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.logger.debug("Trying to find the direct dependency of: {}", (Object)directDependencyToCheck.getName());
                    DependencyInfo foundDependencyInfo = this.findDirectDependencyInTree(dependencies, directDependencyToCheck);
                    if (foundDependencyInfo != null) {
                        dependencies.add(foundDependencyInfo);
                    } else {
                        this.logger.warn("Error getting dependency {}, might be issues using pipdeptree command", (Object)directDependencyToCheck.getName());
                    }
                    --missingDirectDependencies;
                }
                ++i;
            }
        }
    }

    private DependencyInfo findDirectDependencyInTree(Collection<DependencyInfo> dependencies, File directDependencyToCheck) {
        for (DependencyInfo dependency : dependencies) {
            if (dependency.getArtifactId().equals(directDependencyToCheck.getName())) {
                return dependency;
            }
            DependencyInfo child = this.findDirectDependencyInTree(dependency.getChildren(), directDependencyToCheck);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private List<DependencyInfo> collectDependenciesWithTree(String treeFile, String requirementsTxtPath) {
        List<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        try {
            String allTreeFile = new String(Files.readAllBytes(Paths.get(treeFile, new String[0])), StandardCharsets.UTF_8);
            JSONArray treeArray = new JSONArray(allTreeFile);
            File[] files = new File(this.tempDirPackages).listFiles();
            if (this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
                dependencies = this.collectDependenciesReq(treeArray, files, requirementsTxtPath);
            } else if (this.dependencyFileType == DependenciesFileType.SETUP_PY) {
                dependencies = this.collectDependenciesReq(treeArray.getJSONObject(this.findIndexInArrayOfPipdeptree(treeArray)).getJSONArray(DEPENDENCIES), files, requirementsTxtPath);
            }
        }
        catch (IOException e) {
            this.logger.warn("Cannot read the hierarchy tree file");
        }
        return dependencies;
    }

    private int findIndexInArrayOfPipdeptree(JSONArray treeArray) {
        for (int i = 0; i < treeArray.length(); ++i) {
            boolean findDefault = false;
            String packageName = treeArray.getJSONObject(i).getString(PACKAGE_NAME);
            for (String defaultPackage : DEFAULT_PACKAGES_IN_PIPDEPTREE) {
                if (!defaultPackage.equals(packageName)) continue;
                findDefault = true;
                break;
            }
            if (findDefault) continue;
            return i;
        }
        return treeArray.length() - 1;
    }

    private List<DependencyInfo> collectDependenciesReq(JSONArray dependenciesArray, File[] files, String requirementsTxtPath) {
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        for (int i = 0; i < dependenciesArray.length(); ++i) {
            JSONObject packageObject = dependenciesArray.getJSONObject(i);
            DependencyInfo dependency = this.getDependencyByName(files, packageObject.getString(PACKAGE_NAME), packageObject.getString(INSTALLED_VERSION), requirementsTxtPath);
            if (dependency == null) continue;
            dependencies.add(dependency);
            dependency.setChildren(this.collectDependenciesReq(packageObject.getJSONArray(DEPENDENCIES), files, requirementsTxtPath));
        }
        return dependencies;
    }

    private DependencyInfo getDependencyByName(File[] files, String name, String version, String requirementsTxtPath) {
        String nameAndVersion1 = name + COMMA + version;
        String nameAndVersion2 = name.replace(COMMA, LOWER_COMMA) + COMMA + version;
        nameAndVersion1 = nameAndVersion1.toLowerCase();
        nameAndVersion2 = nameAndVersion2.toLowerCase();
        for (File file : files) {
            String fileNameLowerCase = file.getName().toLowerCase();
            if (!fileNameLowerCase.startsWith(nameAndVersion1) && !fileNameLowerCase.startsWith(nameAndVersion2)) continue;
            return this.getDependencyFromFile(file, requirementsTxtPath);
        }
        return null;
    }

    private boolean getTree(String requirementsTxtPath) {
        boolean failed;
        try {
            failed = this.processCommand(new String[]{this.pythonPath, M, VIRTUALENV, this.tempDirVirtualenv + ENV}, true);
            if (!failed) {
                String scriptPath;
                failed = PythonDependencyCollector.isWindows() ? this.processCommand(this.getFullCmdInstallation(requirementsTxtPath), true) : ((scriptPath = this.createScript(requirementsTxtPath)) != null ? this.processCommand(new String[]{scriptPath}, true) : true);
            }
        }
        catch (IOException e) {
            this.logger.warn("Cannot install requirements.txt in the virtual environment.");
            failed = true;
        }
        return failed;
    }

    private List<DependencyInfo> collectDependencies(File folder, String requirementsTxtPath) {
        LinkedList<DependencyInfo> result = new LinkedList<DependencyInfo>();
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                for (File regFile : file.listFiles()) {
                    this.addDependencyInfoData(regFile, requirementsTxtPath, result);
                }
                continue;
            }
            this.addDependencyInfoData(file, requirementsTxtPath, result);
        }
        return result;
    }

    private void addDependencyInfoData(File file, String requirementsTxtPath, List<DependencyInfo> dependencies) {
        DependencyInfo dependency = this.getDependencyFromFile(file, requirementsTxtPath);
        if (dependency != null) {
            dependencies.add(dependency);
        }
    }

    private DependencyInfo getDependencyFromFile(File file, String requirementsTxtPath) {
        DependencyInfo dependency = new DependencyInfo();
        String fileName = file.getName();
        String sha1 = this.getSha1(file);
        if (StringUtils.isEmpty((String)sha1)) {
            return null;
        }
        dependency.setArtifactId(fileName);
        dependency.setSha1(sha1);
        dependency.setSystemPath(requirementsTxtPath);
        dependency.setDependencyType(DependencyType.PYTHON);
        return dependency;
    }

    private String getSha1(File file) {
        try {
            return ChecksumUtils.calculateSHA1((File)file);
        }
        catch (IOException e) {
            this.logger.warn("Failed getting. {} File will not be send to Checkmarx server.", (Object)file);
            return EMPTY_STRING;
        }
    }

    private String[] getFullCmdInstallation(String requirementsTxtPath) {
        String[] windowsCommand = null;
        String pipOpt = this.getPipOptions();
        if (StringUtils.isNotEmpty((String)pipOpt)) {
            if (this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
                windowsCommand = new String[]{this.tempDirVirtualenv + SCRIPTS_ACTIVATE, AND, this.pipPath, INSTALL, pipOpt, R_PARAMETER, requirementsTxtPath, F, this.tempDirPackages, AND, this.pipPath, INSTALL, pipOpt, PIPDEPTREE, AND, PIPDEPTREE, JSON_TREE, ARROW, this.tempDirVirtualenv + HIERARCHY_TREE_TXT};
            } else if (this.dependencyFileType == DependenciesFileType.SETUP_PY) {
                windowsCommand = new String[]{this.tempDirVirtualenv + SCRIPTS_ACTIVATE, AND, this.pipPath, INSTALL, pipOpt, requirementsTxtPath, F, this.tempDirPackages, AND, this.pipPath, INSTALL, pipOpt, PIPDEPTREE, AND, PIPDEPTREE, JSON_TREE, ARROW, this.tempDirVirtualenv + HIERARCHY_TREE_TXT};
            }
        } else if (this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
            windowsCommand = new String[]{this.tempDirVirtualenv + SCRIPTS_ACTIVATE, AND, this.pipPath, INSTALL, R_PARAMETER, requirementsTxtPath, F, this.tempDirPackages, AND, this.pipPath, INSTALL, PIPDEPTREE, AND, PIPDEPTREE, JSON_TREE, ARROW, this.tempDirVirtualenv + HIERARCHY_TREE_TXT};
        } else if (this.dependencyFileType == DependenciesFileType.SETUP_PY) {
            windowsCommand = new String[]{this.tempDirVirtualenv + SCRIPTS_ACTIVATE, AND, this.pipPath, INSTALL, requirementsTxtPath, F, this.tempDirPackages, AND, this.pipPath, INSTALL, PIPDEPTREE, AND, PIPDEPTREE, JSON_TREE, ARROW, this.tempDirVirtualenv + HIERARCHY_TREE_TXT};
        }
        return windowsCommand;
    }

    private boolean processCommand(String[] args, boolean withOutput) throws IOException {
        CommandLineProcess commandLineProcess = new CommandLineProcess(this.topLevelFolder, args);
        this.logger.debug("Running Python command: " + Arrays.toString(args));
        if (withOutput) {
            List<String> outLines = commandLineProcess.executeProcess();
            outLines.forEach(arg_0 -> ((Logger)this.logger).debug(arg_0));
        } else {
            commandLineProcess.executeProcessWithoutOutput();
        }
        return commandLineProcess.isErrorInProcess();
    }

    private List<String> commandLineRunner(String rootDirectory, String[] params) {
        try {
            CommandLineProcess commandLineProcess = new CommandLineProcess(rootDirectory, params);
            List<String> lines = commandLineProcess.executeProcess();
            if (!commandLineProcess.isErrorInProcess()) {
                return lines;
            }
            this.logger.warn("error in process after running command {} on {}", (Object)params, (Object)rootDirectory);
        }
        catch (IOException e) {
            this.logger.warn("Error getting results after running command {} on {}, {}", new Object[]{params, rootDirectory, e.getMessage()});
            this.logger.debug("Error: {}", (Object[])e.getStackTrace());
        }
        return Collections.emptyList();
    }

    private Set<String> parsePipFile(List<String> lines) {
        HashSet<String> DependencyLines = new HashSet<String>();
        for (String line : lines) {
            if (!line.contains(" ")) {
                DependencyLines.add(line);
                continue;
            }
            if (!line.contains("==")) continue;
            String artifactAndVersion = line.substring(0, line.indexOf(59));
            DependencyLines.add(artifactAndVersion);
        }
        return DependencyLines;
    }

    private void downloadLineByLine(String requirementsTxtPath) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(requirementsTxtPath)));){
            String line;
            ExecutorService executorService = Executors.newWorkStealingPool(8);
            LinkedList<DownloadDependency> threadsCollection = new LinkedList<DownloadDependency>();
            while ((line = bufferedReader.readLine()) != null) {
                String packageNameToDownload;
                if (!StringUtils.isNotEmpty((String)line)) continue;
                int commentIndex = line.indexOf(COMMENT_SIGN_PYTHON);
                if (commentIndex < 0) {
                    commentIndex = line.length();
                }
                if (!StringUtils.isNotEmpty((String)(packageNameToDownload = line.substring(0, commentIndex)))) continue;
                threadsCollection.add(new DownloadDependency(packageNameToDownload));
            }
            this.runThreadCollection(executorService, threadsCollection);
        }
        catch (IOException e) {
            this.logger.warn("Cannot read the requirements.txt file: {}", (Object)e.getMessage());
        }
    }

    private void runThreadCollection(ExecutorService executorService, Collection<DownloadDependency> threadsCollection) {
        try {
            executorService.invokeAll(threadsCollection);
            executorService.shutdown();
        }
        catch (InterruptedException e) {
            this.logger.warn("One of the threads was interrupted, please try to scan again the project. Error: {}", (Object)e.getMessage());
            this.logger.debug("One of the threads was interrupted, please try to scan again the project. Error: {}", (Object[])e.getStackTrace());
        }
    }

    private void downloadOneDependency(String packageName) {
        int currentCounter = this.counterFolders.incrementAndGet();
        String message = "Failed to download the transitive dependencies of '";
        try {
            if (this.processCommand(new String[]{this.pipPath, DOWNLOAD, packageName, D_PARAMETER, this.tempDirPackages + FORWARD_SLASH + currentCounter}, false)) {
                this.logger.warn(message + packageName + APOSTROPHE);
            }
        }
        catch (IOException e) {
            this.logger.warn("Cannot read the requirements.txt file");
        }
    }

    private String createScript(String requirementsTxtPath) {
        FilesUtils filesUtils = new FilesUtils();
        String path = filesUtils.createTmpFolder(false, "Whitesource_python_resolver");
        String scriptPath = null;
        if (path != null) {
            scriptPath = path + SCRIPT_SH;
            File file = new File(scriptPath);
            try (FileOutputStream fos = new FileOutputStream(file);
                 BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fos));){
                bufferedWriter.write(BIN_BASH);
                bufferedWriter.newLine();
                bufferedWriter.write("source " + this.tempDirVirtualenv + BIN_ACTIVATE);
                bufferedWriter.newLine();
                String pipOpt = this.getPipOptions();
                if (StringUtils.isNotEmpty((String)pipOpt)) {
                    if (this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
                        bufferedWriter.write(this.pipPath + " " + INSTALL + " " + pipOpt + " " + R_PARAMETER + " " + requirementsTxtPath + " " + F + " " + this.tempDirPackages);
                    } else if (this.dependencyFileType == DependenciesFileType.SETUP_PY) {
                        bufferedWriter.write(this.pipPath + " " + INSTALL + pipOpt + " " + " " + " " + requirementsTxtPath + " " + F + " " + this.tempDirPackages);
                    }
                    bufferedWriter.newLine();
                    bufferedWriter.write(this.pipPath + " " + INSTALL + " " + pipOpt + " " + PIPDEPTREE);
                } else {
                    if (this.dependencyFileType == DependenciesFileType.REQUIREMENTS_TXT) {
                        bufferedWriter.write(this.pipPath + " " + INSTALL + " " + R_PARAMETER + " " + requirementsTxtPath + " " + F + " " + this.tempDirPackages);
                    } else if (this.dependencyFileType == DependenciesFileType.SETUP_PY) {
                        bufferedWriter.write(this.pipPath + " " + INSTALL + " " + " " + requirementsTxtPath + " " + F + " " + this.tempDirPackages);
                    }
                    bufferedWriter.newLine();
                    bufferedWriter.write(this.pipPath + " " + INSTALL + " " + PIPDEPTREE);
                }
                bufferedWriter.newLine();
                bufferedWriter.write("pipdeptree --json-tree > " + this.tempDirVirtualenv + HIERARCHY_TREE_TXT);
                file.setExecutable(true);
            }
            catch (IOException e) {
                return null;
            }
        }
        return scriptPath;
    }

    private void runPipEnvInstallCommand(String[] args) {
        try {
            String cmdOutput;
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(args);
            builder.directory(new File(this.topLevelFolder));
            Process process = builder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
            Executors.newSingleThreadExecutor().submit(streamGobbler);
            BufferedReader inputStreamPipEnvInstall = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader errorStreamPipEnvInstall = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((cmdOutput = inputStreamPipEnvInstall.readLine()) != null) {
                this.logger.debug(cmdOutput);
            }
            while ((cmdOutput = errorStreamPipEnvInstall.readLine()) != null) {
                this.logger.debug(cmdOutput);
            }
            int exitCode = 0;
            exitCode = process.waitFor();
            this.logger.debug("Exit Code: {}", (Object)exitCode);
        }
        catch (IOException e) {
            this.logger.warn("IOException: {}", (Object)e.getMessage());
            this.logger.debug("IOException: {}", (Object[])e.getStackTrace());
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted Exception: {}", (Object)e.getMessage());
            this.logger.debug("Interrupted Exception: {}", (Object[])e.getStackTrace());
        }
    }

    private boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }

    class DownloadDependency
    implements Callable<Void> {
        private String packageName;

        public DownloadDependency(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public Void call() {
            PythonDependencyCollector.this.downloadOneDependency(this.packageName);
            return null;
        }
    }
}

