/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.php;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.php.phpModel.PhpModel;
import org.whitesource.agent.dependency.resolver.php.phpModel.PhpPackage;
import org.whitesource.agent.utils.CommandLineProcess;
import org.whitesource.util.CxLogUtil;

public class PhpDependencyResolver
extends AbstractDependencyResolver {
    private static final String COMPOSER_LOCK = "composer.lock";
    private static final String COMPOSER_JSON = "composer.json";
    private static final String PHP_EXTENSION = ".php";
    private static String COMPOSER_BAT;
    private static String COMPOSER;
    private static final String PHP_INCLUDE_NO_DEV = "--no-dev";
    private static final String REQUIRE = "require";
    private static final String REQUIRE_DEV = "require-dev";
    private static final String PHP = "php";
    private static final List<String> PHP_PATTERN_EXTENSION;
    private final Logger logger = CxLogUtil.getLogger(PhpDependencyResolver.class);
    private boolean phpPreStep;
    private boolean includeDevDependencies;

    public PhpDependencyResolver(boolean phpPreStep, boolean includeDevDependencies) {
        this.phpPreStep = phpPreStep;
        this.includeDevDependencies = includeDevDependencies;
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) {
        boolean installSuccess = true;
        Collection<DependencyInfo> dependencyInfos = new LinkedList<DependencyInfo>();
        LinkedList<String> directDependencies = new LinkedList<String>();
        File composerLock = new File(topLevelFolder + "/" + COMPOSER_LOCK);
        if (this.phpPreStep) {
            installSuccess = !this.executePreStepCommand(topLevelFolder);
        } else if (!composerLock.exists()) {
            this.logger.warn("Could not find {} file in {}. Please execute {} {} first.", new Object[]{COMPOSER_LOCK, topLevelFolder, PhpDependencyResolver.getComposer(false), "install"});
        }
        if (installSuccess && composerLock.exists()) {
            try {
                Map requireMap = new HashMap();
                FileInputStream is = new FileInputStream(topLevelFolder + "/" + COMPOSER_JSON);
                String jsonText = IOUtils.toString((InputStream)is);
                JSONObject json = new JSONObject(jsonText);
                if (json.has(REQUIRE)) {
                    JSONObject require = json.getJSONObject(REQUIRE);
                    requireMap = require.toMap();
                }
                if (this.includeDevDependencies && json.has(REQUIRE_DEV)) {
                    JSONObject requireDev = json.getJSONObject(REQUIRE_DEV);
                    Map requireDevMap = requireDev.toMap();
                    requireMap.putAll(requireDevMap);
                }
                if (!requireMap.isEmpty()) {
                    if (requireMap.containsKey(PHP)) {
                        requireMap.remove(PHP);
                    }
                    directDependencies.addAll(requireMap.keySet());
                }
            }
            catch (IOException e) {
                this.logger.error("Didn't succeed to read {} - {} ", (Object)COMPOSER_JSON, (Object)e.getMessage());
            }
        }
        if (!directDependencies.isEmpty()) {
            try {
                String jsondStr = FileUtils.readFileToString((File)new File(topLevelFolder + File.separator + COMPOSER_LOCK), (Charset)StandardCharsets.UTF_8);
                PhpModel phpModel = (PhpModel)new Gson().fromJson(jsondStr, PhpModel.class);
                Collection<PhpPackage> phpPackages = phpModel.getPhpPackages();
                if (this.includeDevDependencies) {
                    phpPackages.addAll(phpModel.getPhpPackagesDev());
                }
                if (!phpPackages.isEmpty()) {
                    dependencyInfos = this.createDependencyInfos(phpPackages, dependencyInfos, directDependencies);
                } else {
                    this.logger.debug("The file {} is empty", (Object)COMPOSER_LOCK);
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
        }
        return new ResolutionResult(dependencyInfos, this.getExcludes(), this.getDependencyType(), topLevelFolder);
    }

    @Override
    protected Collection<String> getExcludes() {
        return PHP_PATTERN_EXTENSION;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return new ArrayList<String>(Arrays.asList(PHP_EXTENSION));
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.PHP;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.PHP.name();
    }

    @Override
    protected String[] getBomPattern() {
        return new String[]{"**/*composer.json"};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return new LinkedList<String>();
    }

    private Collection<DependencyInfo> createDependencyInfos(Collection<PhpPackage> phpPackages, Collection<DependencyInfo> dependencyInfos, Collection<String> directDependencies) {
        DependencyInfo dependencyInfo;
        HashMap<DependencyInfo, Collection<String>> parentToChildMap = new HashMap<DependencyInfo, Collection<String>>();
        HashMap<String, DependencyInfo> packageDependencyMap = new HashMap<String, DependencyInfo>();
        for (PhpPackage phpPackage : phpPackages) {
            dependencyInfo = this.createDependencyInfo(phpPackage);
            if (dependencyInfo != null) {
                parentToChildMap.put(dependencyInfo, phpPackage.getPackageRequire().keySet());
                packageDependencyMap.put(phpPackage.getName(), dependencyInfo);
                continue;
            }
            this.logger.debug("Didn't succeed to create dependencyInfo for {}", (Object)phpPackage.getName());
        }
        if (!packageDependencyMap.isEmpty()) {
            for (String directDependency : directDependencies) {
                dependencyInfo = (DependencyInfo)packageDependencyMap.get(directDependency);
                if (dependencyInfo != null) {
                    this.collectChildren(dependencyInfo, packageDependencyMap, parentToChildMap);
                    dependencyInfos.add(dependencyInfo);
                    continue;
                }
                this.logger.debug("Didn't found {} in map {}", (Object)directDependency, (Object)packageDependencyMap.getClass().getName());
            }
        } else {
            this.logger.debug("The map {} is empty ", (Object)packageDependencyMap.getClass().getName());
        }
        return dependencyInfos;
    }

    private static String getComposer(boolean isWindows) {
        String composerPath = System.getenv("CX_COMPOSER_PATH");
        String string = composerPath = StringUtils.isNotEmpty((String)composerPath) ? composerPath : System.getProperty("CX_COMPOSER_PATH");
        if (StringUtils.isNotEmpty((String)composerPath)) {
            composerPath = composerPath.endsWith(File.separator) ? composerPath : composerPath + File.separator;
            COMPOSER_BAT = composerPath + "composer.bat";
            COMPOSER = composerPath + "composer";
        } else {
            COMPOSER_BAT = "composer.bat";
            COMPOSER = "composer";
        }
        return isWindows ? COMPOSER_BAT : COMPOSER;
    }

    private DependencyInfo createDependencyInfo(PhpPackage phpPackage) {
        String commit;
        String groupId = this.getGroupIdFromName(phpPackage);
        String artifactId = phpPackage.getName();
        String version = phpPackage.getVersion();
        String string = commit = phpPackage.getPackageSource() != null ? phpPackage.getPackageSource().getReference() : null;
        if (StringUtils.isNotBlank((String)version) || StringUtils.isNotBlank((String)commit)) {
            DependencyInfo dependencyInfo = new DependencyInfo(groupId, artifactId, version);
            dependencyInfo.setCommit(commit);
            dependencyInfo.setDependencyType(this.getDependencyType());
            return dependencyInfo;
        }
        this.logger.debug("The parameters version and commit of {} are null", (Object)phpPackage.getName());
        return null;
    }

    private void collectChildren(DependencyInfo dependencyInfo, HashMap<String, DependencyInfo> packageDependencyMap, HashMap<DependencyInfo, Collection<String>> requireDependenciesMap) {
        Collection<String> requires = requireDependenciesMap.get(dependencyInfo);
        if (dependencyInfo.getChildren().isEmpty()) {
            for (String require : requires) {
                DependencyInfo dependencyChild = packageDependencyMap.get(require);
                if (dependencyChild == null) continue;
                dependencyInfo.getChildren().add(dependencyChild);
                this.collectChildren(dependencyChild, packageDependencyMap, requireDependenciesMap);
            }
        }
    }

    private String getGroupIdFromName(PhpPackage phpPackage) {
        String groupId = null;
        if (StringUtils.isNotBlank((String)phpPackage.getName())) {
            String packageName = phpPackage.getName();
            String[] gavCoordinates = packageName.split("/");
            groupId = gavCoordinates[0];
        }
        return groupId;
    }

    private String getArtifactIdFromName(PhpPackage phpPackage) {
        String artifactId = null;
        if (StringUtils.isNotBlank((String)phpPackage.getName())) {
            String packageName = phpPackage.getName();
            String[] gavCoordinates = packageName.split("/");
            artifactId = gavCoordinates[1];
        }
        return artifactId;
    }

    private boolean executePreStepCommand(String topLevelFolder) {
        CharSequence[] command = DependencyCollector.isWindows() ? this.getCommand(PhpDependencyResolver.getComposer(true)) : this.getCommand(PhpDependencyResolver.getComposer(false));
        String commandString = String.join((CharSequence)" ", command);
        File file = new File(topLevelFolder + "/" + COMPOSER_JSON);
        CommandLineProcess composerInstall = null;
        if (file.exists()) {
            this.logger.info("Running install command : {}", (Object)commandString);
            composerInstall = new CommandLineProcess(topLevelFolder, (String[])command);
        }
        try {
            composerInstall.executeProcessWithoutOutput();
        }
        catch (IOException e) {
            this.logger.warn("Could not run {} in folder {} : {}", new Object[]{commandString, topLevelFolder, e.getMessage()});
            return true;
        }
        return composerInstall.isErrorInProcess();
    }

    private String[] getCommand(String firstCommand) {
        String[] command = this.includeDevDependencies ? new String[]{firstCommand, "install"} : new String[]{firstCommand, "install", PHP_INCLUDE_NO_DEV};
        return command;
    }

    static {
        PHP_PATTERN_EXTENSION = Arrays.asList("**/*.php");
    }
}

