/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.maven;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.BomFile;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.maven.MavenPomParser;
import org.whitesource.agent.dependency.resolver.maven.MavenTreeDependencyCollector;

public class MavenDependencyResolver
extends AbstractDependencyResolver {
    private static final String POM_XML = "**/pom.xml";
    private static final List<String> JAVA_EXTENSIONS = Arrays.asList(".java", ".jar", ".war", ".ear", ".car", ".class");
    private static final List<String> MAVEN_EXTENSIONS = Arrays.asList("pom.xml", ".java", ".jar", ".war", ".ear", ".car", ".class");
    private static final String TEST = String.join((CharSequence)File.separator, "src", "test");
    private final boolean mavenAggregateModules;
    private final boolean dependenciesOnly;
    private final MavenTreeDependencyCollector dependencyCollector;

    public MavenDependencyResolver(boolean mavenAggregateModules, String[] mavenIgnoredScopes, boolean dependenciesOnly, boolean ignorePomModules, boolean ignoreFailedModules, boolean runPreStep) {
        this.dependencyCollector = new MavenTreeDependencyCollector(mavenIgnoredScopes, ignorePomModules, ignoreFailedModules, runPreStep);
        this.bomParser = new MavenPomParser();
        this.mavenAggregateModules = mavenAggregateModules;
        this.dependenciesOnly = dependenciesOnly;
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) {
        Collection<AgentProjectInfo> projects = this.dependencyCollector.collectDependencies(topLevelFolder);
        List files = bomFiles.stream().map(this.bomParser::parseBomFile).filter(Objects::nonNull).filter(bom -> !bom.getLocalFileName().contains(TEST)).collect(Collectors.toList());
        HashSet<String> excludes = new HashSet<String>();
        Map<AgentProjectInfo, Path> projectInfoPathMap = projects.stream().collect(Collectors.toMap(projectInfo -> projectInfo, projectInfo -> {
            Optional<BomFile> folderPath = files.stream().filter(file -> projectInfo.getCoordinates().getArtifactId().equals(file.getName())).findFirst();
            if (folderPath.isPresent()) {
                File topFolderFound = new File(folderPath.get().getLocalFileName()).getParentFile();
                if (this.dependenciesOnly) {
                    excludes.addAll(this.normalizeLocalPath(projectFolder, topFolderFound.toString(), JAVA_EXTENSIONS, null));
                }
                return topFolderFound.toPath();
            }
            if (this.dependenciesOnly) {
                excludes.addAll(this.normalizeLocalPath(projectFolder, topLevelFolder.toString(), JAVA_EXTENSIONS, null));
            }
            return Paths.get(topLevelFolder, new String[0]);
        }));
        ResolutionResult resolutionResult = !this.mavenAggregateModules ? new ResolutionResult(projectInfoPathMap, excludes, this.getDependencyType(), topLevelFolder) : new ResolutionResult(projectInfoPathMap.keySet().stream().flatMap(project -> project.getDependencies().stream()).collect(Collectors.toList()), excludes, this.getDependencyType(), topLevelFolder);
        return resolutionResult;
    }

    @Override
    protected Collection<String> getExcludes() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.addAll(this.getLanguageExcludes());
        return excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return MAVEN_EXTENSIONS;
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.MAVEN;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.MAVEN.name();
    }

    @Override
    public String[] getBomPattern() {
        return new String[]{POM_XML};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return new HashSet<String>();
    }
}

