/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.js;

import java.util.ArrayList;
import java.util.List;

public enum JsLibsRegex {
    JQUERY("jquery", (List<String>)new ArrayList<String>(){
        {
            this.add("jquery-(.*?)(\\.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*!? jQuery v(.*?)");
            this.add("\\* jQuery JavaScript Library v(.*?)");
            this.add("\\* jQuery (.*?) - New Wave Javascript");
            this.add("// \\$Id: jquery.js,v (.*?)");
            this.add("/\\*! jQuery v(.*?)");
            this.add("[^a-z]f=\"(.*?)\",.*[^a-z]jquery:f,");
            this.add("[^a-z]m=\"(.*?)\",.*[^a-z]jquery:m,");
            this.add("[^a-z.]jquery:[ ]?\"(.*?)\"");
        }
    }),
    JQUERY_MIGRATE("jquery-migrate", (List<String>)new ArrayList<String>(){
        {
            this.add("jquery-migrate-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*!?(?:\n \\*)? jQuery Migrate(?: -)? v(.*?)");
        }
    }),
    JQUERY_VALIDATOR("jquery-validator", (List<String>)new ArrayList<String>(){
        {
            this.add("jquery.validation-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*!?(?:\n \\*)? jQuery Validation Plugin v(.*?)");
        }
    }),
    JQUERY_MOBILE("jquery-mobile", (List<String>)new ArrayList<String>(){
        {
            this.add("jquery.mobile-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*!?(?:\n \\*)? jQuery Mobile(?: -)? v(.*?)");
        }
    }),
    JQUERY_UI("jquery-ui", null, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}.*jquery\\.ui\\.dialog\\.js");
            this.add("/\\*!?[\n *]+jQuery UI Dialog (.*?)");
            this.add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}\\* Includes: .* dialog\\.js");
            this.add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}.*jquery\\.ui\\.autocomplete\\.js");
            this.add("/\\*!?[\n *]+jQuery UI Autocomplete (.*?)");
            this.add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}\\* Includes: .* autocomplete\\.js");
            this.add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}.*jquery\\.ui\\.tooltip\\.js");
            this.add("/\\*!?[\n *]+jQuery UI Tooltip (.*?)");
        }
    }),
    JQUERY_PRETTY_PHOTO("jquery-prettyPhoto", null, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*[\r\n -]+Class: prettyPhoto(?:.*\n){1,3}[ ]*Version: (.*?)");
            this.add("\\.prettyPhoto[ ]?=[ ]?\\{version:[ ]?(?:'|\")(.*?)(?:'|\")\\}");
        }
    }),
    JPLAYER("jPlayer", null, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*!?[\n *]+jPlayer Plugin for jQuery (?:.*\n){1,10}[ *]+Version: (.*?)");
            this.add("/\\*!? jPlayer (.*?) for jQuery");
        }
    }),
    KNOCKOUT("knockout", (List<String>)new ArrayList<String>(){
        {
            this.add("knockout-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("\\* Knockout JavaScript library v(.*?)");
        }
    }),
    SESSVARS("sessvars", (List<String>)new ArrayList<String>(){
        {
            this.add("sessvars-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("sessvars ver (.*?)");
        }
    }),
    SWFOBJECT("swfobject", (List<String>)new ArrayList<String>(){
        {
            this.add("swfobject_(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("SWFObject v(.*?) ");
        }
    }),
    TINYMCE("tinymce", null, (List<String>)new ArrayList<String>(){
        {
            this.add("// (.*?) \\([0-9\\-]+\\)[\n\r]+.{0,1200}l=.tinymce/geom/Rect.");
        }
    }),
    YUI("yui", (List<String>)new ArrayList<String>(){
        {
            this.add("yui-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/*\nYUI (.*?)");
            this.add("/yui/license.(?:html|txt)\nversion: (.*?)");
        }
    }),
    PROTOTYPEJS("prototypejs", (List<String>)new ArrayList<String>(){
        {
            this.add("prototype-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("Prototype JavaScript framework, version (.*?)");
            this.add("Prototype[ ]?=[ ]?\\{[ \r\n\t]*Version:[ ]?(?:'|\")(.*?)(?:'|\")");
        }
    }),
    EMBER("ember", (List<String>)new ArrayList<String>(){
        {
            this.add("ember-(.*?)(\\.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("Project:   Ember -(?:.*\n){9,11}// Version: v(.*?)");
            this.add("// Version: v(.*?)(.*\n){10,15}(Ember Debug|@module ember|@class ember)");
            this.add("Ember.VERSION[ ]?=[ ]?(?:'|\")(.*?)(?:'|\")");
        }
    }),
    DOJO("dojo", (List<String>)new ArrayList<String>(){
        {
            this.add("dojo-(.*?)(\\.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/dojo.version=\\{major:([0-9]+),minor:([0-9]+),patch:([0-9]+)/$1.$2.$3/");
        }
    }),
    ANGULARJS("angularjs", (List<String>)new ArrayList<String>(){
        {
            this.add("angular(?:js)?-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*[ \n]+AngularJS v(.*?)");
            this.add("http://errors\\.angularjs\\.org/(.*?)/");
        }
    }),
    BACKBONEJS("backbonejs", (List<String>)new ArrayList<String>(){
        {
            this.add("backbone(?:js)?-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("//[ ]+Backbone.js (.*?)");
            this.add("a=t.Backbone={}}a.VERSION=\"(.*?)\"");
        }
    }),
    MUSTACHE("mustache.js", (List<String>)new ArrayList<String>(){
        {
            this.add("mustache(?:js)?-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("name:\"mustache.js\",version:\"(.*?)\"");
            this.add("[^a-z]mustache.version[ ]?=[ ]?(?:'|\")(.*?)(?:'|\")");
            this.add("exports.name[ ]?=[ ]?\"mustache.js\";[\n ]*exports.version[ ]?=[ ]?(?:'|\")(.*?)(?:'|\");");
        }
    }),
    HANDLEBARS("handlebars", (List<String>)new ArrayList<String>(){
        {
            this.add("handlebars(?:js)?-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("Handlebars.VERSION = \"(.*?)\";");
            this.add("Handlebars=\\{VERSION:(?:'|\")(.*?)(?:'|\")");
            this.add("this.Handlebars=\\{\\};[\n\r \t]+\\(function\\([a-z]\\)\\{[a-z].VERSION=(?:'|\")(.*?)(?:'|\")");
            this.add("/\\*+![\\s]+(?:@license)?[\\s]+handlebars v(.*?)");
        }
    }),
    EASYXDM("easyXDM", (List<String>)new ArrayList<String>(){
        {
            this.add("easyXDM-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add(" \\* easyXDM\n \\* http://easyxdm.net/(?:\r|\n|.)+version:\"(.*?)\"");
            this.add("@class easyXDM(?:.|\r|\n)+@version (.*?)(\r|\n)");
        }
    }),
    PLUPLOAD("plupload", (List<String>)new ArrayList<String>(){
        {
            this.add("plupload-(.*?)(.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("\\* Plupload - multi-runtime File Uploader(?:\r|\n)+ \\* v(.*?)");
            this.add("var g=\\{VERSION:\"(.*?)\",.*;window.plupload=g\\}");
        }
    }),
    DOMPURIFY("dompurify", null, (List<String>)new ArrayList<String>(){
        {
            this.add("DOMPurify.version = '(.*?)';");
            this.add("DOMPurify.version=\"(.*?)\"");
            this.add("DOMPurify=.[^\\r\\n]{10,500}\\.version=\"(.*?)\"");
        }
    }),
    REACT("react", null, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*\\*\n +\\* React \\(with addons\\) ?v(.*?)");
            this.add("/\\*\\*\n +\\* React v(.*?)");
            this.add("\"\\./ReactReconciler\":[0-9]+,\"\\./Transaction\":[0-9]+,\"fbjs/lib/invariant\":[0-9]+\\}\\],[0-9]+:\\[function\\(require,module,exports\\)\\{\"use strict\";module\\.exports=\"(.*?)\"\\}");
            this.add("ReactVersion\\.js[\\*! \\\\/\n\r]{0,100}function\\(e,t\\)\\{\"use strict\";e\\.exports=\"(.*?)\"");
            this.add("expected a ReactNode.[\\s\\S]{0,1800}?function\\(e,t\\)\\{\"use strict\";e\\.exports=\"(.*?)\"");
        }
    }),
    FLOWPLAYER("flowplayer", (List<String>)new ArrayList<String>(){
        {
            this.add("flowplayer-(.*?)(\\.min)?\\.js");
        }
    }, null),
    DWR("DWR", null, (List<String>)new ArrayList<String>(){
        {
            this.add(" dwr-(.*?).jar");
        }
    }),
    MOMENTJS("momentjs", null, (List<String>)new ArrayList<String>(){
        {
            this.add("//! moment.js(?:[\n\r]+)//! version : (.*?)");
        }
    }),
    BOOTSTRAP("bootstrap", (List<String>)new ArrayList<String>(){
        {
            this.add("bootstrap-(.*?)(\\.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*!? Bootstrap v(.*?)");
            this.add("\\* Bootstrap v(.*?)");
            this.add("/\\*! Bootstrap v(.*?)");
            this.add("this\\.close\\)};.\\.VERSION=\"(.*?)\"(?:,.\\.TRANSITION_DURATION=150)?,.\\.prototype\\.close");
        }
    }),
    CKEDITOR("ckeditor", (List<String>)new ArrayList<String>(){
        {
            this.add("ckeditor-(.*?)(\\.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("ckeditor..js.{4,20}=\\{timestamp:\"[^\"]+\",version:\"(.*?)");
            this.add("window.CKEDITOR=function\\(\\)\\{var [a-z]=\\{timestamp:\"[^\"]+\",version:\"(.*?)");
        }
    }),
    VUE("vue", (List<String>)new ArrayList<String>(){
        {
            this.add("vue-(.*?)(\\.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/\\*!\\n \\* Vue.js v(.*?)");
            this.add("Vue.version = '(.*?)';");
            this.add("'(.*?)'[^\\n]{0,8000}Vue compiler");
        }
    }),
    EXTJS("extjs", (List<String>)new ArrayList<String>(){
        {
            this.add("/ext-all-(.*?)(\\.min)?\\.js");
            this.add("/ext-all-debug-(.*?)(\\.min)?\\.js");
            this.add("/ext-base-(.*?)(\\.min)?\\.js");
        }
    }, (List<String>)new ArrayList<String>(){
        {
            this.add("/*!\n * Ext JS Library (.*?)");
        }
    });

    private String libName;
    private List<String> fileNameRegex;
    private List<String> fileContentRegex;

    private JsLibsRegex(String libName, List<String> fileNameRegex, List<String> fileContentRegex) {
        this.libName = libName;
        this.fileNameRegex = fileNameRegex;
        this.fileContentRegex = fileContentRegex;
    }

    public String getLibName() {
        return this.libName;
    }

    public List<String> getFileNameRegex() {
        return this.fileNameRegex;
    }

    public List<String> getFileContentRegex() {
        return this.fileContentRegex;
    }
}

