/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.gradle;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.dependency.resolver.gradle.MvnCommand;
import org.whitesource.agent.utils.Cli;
import org.whitesource.agent.utils.CommandLineProcess;
import org.whitesource.util.CxLogUtil;

class GradleCli
extends Cli {
    private final Logger logger = CxLogUtil.getLogger(GradleCli.class);
    protected static final String GRADLE_ASSEMBLE = "assemble";
    protected static final String GRADLE_NO_DAEMON = "--no-daemon";
    private static String GRADLE_COMMAND;
    private static final String GRADLE_COMMAND_W_WINDOWS = "gradlew";
    private static final String GRADLE_COMMAND_W_LINUX = "./gradlew";
    private String topLevelFolderGradlew = null;

    GradleCli() {
    }

    public List<String> runGradleCmd(String rootDirectory, String[] params) {
        block5: {
            try {
                CommandLineProcess commandLineProcess = new CommandLineProcess(rootDirectory, params);
                List<String> lines = commandLineProcess.executeProcess();
                if (commandLineProcess.isErrorInProcess()) {
                    this.setGradleCommandByEnv(params);
                    commandLineProcess = new CommandLineProcess(rootDirectory, params);
                    lines = commandLineProcess.executeProcess();
                    if (!commandLineProcess.isErrorInProcess()) {
                        return lines;
                    }
                    break block5;
                }
                return lines;
            }
            catch (IOException e) {
                if (StringUtils.isNotBlank((String)params[0]) && GradleCli.getGradleCommand().equals(params[0])) {
                    this.setGradleCommandByEnv(params);
                    return this.runGradleCmd(rootDirectory, params);
                }
                this.logger.warn("Error getting dependencies after running {} on {}, {}", new Object[]{params, rootDirectory, e.getMessage()});
                this.logger.debug("Error: {}", (Object[])e.getStackTrace());
            }
        }
        return null;
    }

    private void setGradleCommandByEnv(String[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].equals(GradleCli.getGradleCommand())) continue;
            if (DependencyCollector.isWindows()) {
                params[i] = GRADLE_COMMAND_W_WINDOWS;
                break;
            }
            if (this.topLevelFolderGradlew != null) {
                params[i] = this.topLevelFolderGradlew + "/" + GRADLE_COMMAND_W_WINDOWS;
                break;
            }
            params[i] = GRADLE_COMMAND_W_LINUX;
            break;
        }
    }

    private static String getGradleCommand() {
        String gradlePath = System.getenv("CX_GRADLE_PATH");
        String string = gradlePath = StringUtils.isNotEmpty((String)gradlePath) ? gradlePath : System.getProperty("CX_GRADLE_PATH");
        if (StringUtils.isNotEmpty((String)gradlePath)) {
            gradlePath = gradlePath.endsWith(File.separator) ? gradlePath : gradlePath + File.separator;
            GRADLE_COMMAND = gradlePath + "gradle";
        } else {
            GRADLE_COMMAND = "gradle";
        }
        return GRADLE_COMMAND;
    }

    protected String[] getGradleCommandParams(MvnCommand command, boolean allowDaemon) {
        if (!allowDaemon) {
            return super.getCommandParams(GradleCli.getGradleCommand(), command.name(), GRADLE_NO_DAEMON);
        }
        return super.getCommandParams(GradleCli.getGradleCommand(), command.name());
    }

    public void setTopLevelFolderGradlew(String topLevelFolderGradlew) {
        this.topLevelFolderGradlew = topLevelFolderGradlew;
    }
}

