/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.docker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.dependency.resolver.docker.AbstractParser;
import org.whitesource.util.CxLogUtil;

public class RpmParser
extends AbstractParser {
    private static final Logger logger = CxLogUtil.getLogger(RpmParser.class);
    private static final String RPM_PACKAGE_PATTERN = "{0}.rpm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DependencyInfo> parse(File file) {
        BufferedReader br = null;
        FileReader fr = null;
        LinkedList<DependencyInfo> dependencyInfos = new LinkedList<DependencyInfo>();
        try {
            File[] files;
            for (File directory : files = file.listFiles()) {
                File[] packageDirectories;
                for (File packageDirectory : packageDirectories = directory.listFiles()) {
                    int firstHyphenIndex = packageDirectory.getName().indexOf("-");
                    String packageInfoString = packageDirectory.getName().substring(firstHyphenIndex + 1, packageDirectory.getName().length());
                    int lastIndexOfHyphen = packageInfoString.lastIndexOf("-");
                    packageInfoString = packageInfoString.substring(0, lastIndexOfHyphen) + "." + packageInfoString.substring(lastIndexOfHyphen + 1);
                    DependencyInfo dependencyInfo = null;
                    String packVersion = this.getPackageVersion(packageInfoString);
                    if (packVersion == null) continue;
                    dependencyInfo = new DependencyInfo(null, MessageFormat.format(RPM_PACKAGE_PATTERN, packageInfoString), packVersion);
                    dependencyInfos.add(dependencyInfo);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to parse {} : {}", (Object)file, (Object)e.getMessage());
        }
        finally {
            RpmParser.closeStream(br, fr);
        }
        return dependencyInfos;
    }

    private String getPackageVersion(String packageInfoString) {
        try {
            String firstDotString = packageInfoString.substring(0, packageInfoString.indexOf("."));
            int lastIndexOfHyphen = firstDotString.lastIndexOf("-");
            int lastIndexOfDot = packageInfoString.lastIndexOf(".");
            String packVersion = packageInfoString.substring(lastIndexOfHyphen + 1, lastIndexOfDot);
            if (StringUtils.isNotBlank((String)packVersion)) {
                return packVersion;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to create package version : {}", (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public File findFile(String[] files, String filename) {
        return null;
    }

    public File checkFolders(Collection<String> yumDbFolders, String yumDbFolderPath) {
        if (!yumDbFolders.isEmpty()) {
            for (String folderPath : yumDbFolders) {
                File file = new File(folderPath);
                if (file.listFiles().length <= 0 || !folderPath.contains(yumDbFolderPath)) continue;
                return file;
            }
        }
        return null;
    }
}

