/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.docker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.archiver.ArchiverException;
import org.slf4j.Logger;
import org.whitesource.agent.FileSystemScanner;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.archive.ArchiveExtractor;
import org.whitesource.agent.dependency.resolver.docker.AbstractParser;
import org.whitesource.agent.dependency.resolver.docker.AlpineParser;
import org.whitesource.agent.dependency.resolver.docker.ArchLinuxParser;
import org.whitesource.agent.dependency.resolver.docker.DebianParser;
import org.whitesource.agent.dependency.resolver.docker.DockerImage;
import org.whitesource.agent.dependency.resolver.docker.RpmParser;
import org.whitesource.agent.hash.FileExtensions;
import org.whitesource.agent.utils.FilesScanner;
import org.whitesource.fs.FSAConfiguration;
import org.whitesource.fs.FsUtils;
import org.whitesource.util.CxLogUtil;

public class DockerResolver {
    private static final Logger logger = CxLogUtil.getLogger(DockerResolver.class);
    private static final String WHITE_SOURCE_DOCKER = "WhiteSource-Docker";
    private static final String TEMP_FOLDER = FsUtils.getTmpDir() + File.separator + "WhiteSource-Docker";
    private static final String DOCKER_SAVE_IMAGE_COMMAND = "docker save";
    private static final String O_PARAMETER = "-o";
    private static final String REPOSITORY = "REPOSITORY";
    private static final String SPACES_REGEX = "\\s+";
    private static final String DOCKER_NAME_FORMAT_STRING = "{0} {1} ({2})";
    private static final MessageFormat DOCKER_NAME_FORMAT = new MessageFormat("{0} {1} ({2})");
    private static final String DOCKER_IMAGES = "docker images";
    private static final String DEBIAN_PATTERN = "**/*eipp.log.xz";
    private static final String ARCH_LINUX_PATTERN = "**/*desc";
    private static final String ALPINE_PATTERN = "**/*installed";
    private static final String DEBIAN_PATTERN_AVAILABLE = "**/*available";
    private static final String RPM_PATTERN = "**var" + File.separator + "lib" + File.separator + "yum" + File.separator + "yumdb" + "/**";
    private static final String[] scanIncludes = new String[]{"**/*eipp.log.xz", "**/*desc", "**/*installed", RPM_PATTERN, "**/*available"};
    private static final String[] scanExcludes = new String[0];
    private static final String ARCH_LINUX_DESC_FOLDERS = "var" + File.separator + "lib" + File.separator + "pacman" + File.separator + "local";
    private static final String RPM_YUM_DB_FOLDER_DEFAULT_PATH = "var" + File.separator + "lib" + File.separator + "yum" + File.separator + "yumdb";
    private static final String DEBIAN_LIST_PACKAGES_FILE = File.separator + "eipp.log.xz";
    private static final String ALPINE_LIST_PACKAGES_FILE = File.separator + "installed";
    private static final String DEBIAN_LIST_PACKAGES_FILE_AVAILABLE = File.separator + "available";
    private static final String PACKAGE_LOG_TXT = "packageLog.txt";
    private static final boolean PARTIAL_SHA1_MATCH = false;
    private FSAConfiguration config;

    public DockerResolver(FSAConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AgentProjectInfo> resolveDockerImages() {
        logger.info("Resolving docker images");
        LinkedList<AgentProjectInfo> projects = new LinkedList<AgentProjectInfo>();
        String line = null;
        LinkedList<DockerImage> dockerImages = new LinkedList<DockerImage>();
        Process process = null;
        try {
            Collection<DockerImage> dockerImagesToScan;
            process = Runtime.getRuntime().exec(DOCKER_IMAGES);
            process.waitFor();
            InputStream inputStream = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = br.readLine()) != null) {
                if (line.startsWith(REPOSITORY)) continue;
                String[] dockerImageString = line.split(SPACES_REGEX);
                dockerImages.add(new DockerImage(dockerImageString[0], dockerImageString[1], dockerImageString[2]));
            }
            if (!dockerImages.isEmpty() && !(dockerImagesToScan = this.filterDockerImagesToScan(dockerImages, this.config.getAgent().getDockerIncludes(), this.config.getAgent().getDockerExcludes())).isEmpty()) {
                this.saveDockerImages(dockerImagesToScan, projects);
            }
        }
        catch (IOException e) {
            logger.error("IO exception : ", (Object)e.getMessage());
            logger.debug("IO exception : ", (Object[])e.getStackTrace());
        }
        catch (InterruptedException e) {
            logger.error("Interrupted exception : ", (Object)e.getMessage());
            logger.debug("Interrupted exception : ", (Object[])e.getStackTrace());
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return projects;
    }

    private Collection<DockerImage> filterDockerImagesToScan(Collection<DockerImage> dockerImages, String[] dockerImageIncludes, String[] dockerImageExcludes) {
        logger.info("Filtering docker images list by includes and excludes lists");
        LinkedList<DockerImage> dockerImagesToScan = new LinkedList<DockerImage>();
        List<String> imageIncludesList = Arrays.asList(dockerImageIncludes);
        List<String> imageExcludesList = Arrays.asList(dockerImageExcludes);
        for (DockerImage dockerImage : dockerImages) {
            Pattern p;
            Matcher m;
            String dockerImageString = dockerImage.getRepository() + " " + dockerImage.getTag() + " " + dockerImage.getId();
            for (String imageInclude : imageIncludesList) {
                if (!StringUtils.isNotBlank((String)imageInclude) || !(m = (p = Pattern.compile(imageInclude)).matcher(dockerImageString)).find()) continue;
                dockerImagesToScan.add(dockerImage);
            }
            for (String imageExcludes : imageExcludesList) {
                if (!StringUtils.isNotBlank((String)imageExcludes) || !(m = (p = Pattern.compile(imageExcludes)).matcher(dockerImageString)).find()) continue;
                dockerImagesToScan.remove(dockerImage);
            }
        }
        return dockerImagesToScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDockerImages(Collection<DockerImage> dockerImages, Collection<AgentProjectInfo> projects) throws IOException {
        Process process = null;
        logger.info("Saving {} docker images", (Object)dockerImages.size());
        for (DockerImage dockerImage : dockerImages) {
            logger.debug("Saving image {} {}", (Object)dockerImage.getRepository(), (Object)dockerImage.getTag());
            AgentProjectInfo projectInfo = new AgentProjectInfo();
            projectInfo.setCoordinates(new Coordinates(null, MessageFormat.format(DOCKER_NAME_FORMAT_STRING, dockerImage.getId(), dockerImage.getRepository(), dockerImage.getTag()), null));
            projects.add(projectInfo);
            File imageTarFile = new File(TEMP_FOLDER, dockerImage.getRepository() + ".tar");
            File imageExtractionDir = new File(TEMP_FOLDER, dockerImage.getRepository());
            imageExtractionDir.mkdirs();
            try {
                Collection<DependencyInfo> debianDependencyInfos;
                process = Runtime.getRuntime().exec("docker save " + dockerImage.getId() + " " + O_PARAMETER + " " + imageTarFile.getPath());
                process.waitFor();
                ArchiveExtractor archiveExtractor = new ArchiveExtractor(this.config.getAgent().getArchiveIncludes(), this.config.getAgent().getArchiveExcludes(), this.config.getAgent().getIncludes());
                archiveExtractor.extractDockerImageLayers(imageTarFile, imageExtractionDir);
                FilesScanner filesScanner = new FilesScanner();
                String[] fileNames = filesScanner.getDirectoryContent(imageExtractionDir.getParent(), scanIncludes, scanExcludes, true, false);
                for (int i = 0; i < fileNames.length; ++i) {
                    fileNames[i] = imageExtractionDir.getParent() + File.separator + fileNames[i];
                }
                AbstractParser parser = new DebianParser();
                File file = parser.findFile(fileNames, DEBIAN_LIST_PACKAGES_FILE);
                if (file != null) {
                    file = this.getPackagesLogFile(file, archiveExtractor);
                }
                this.parseProjectInfo(projectInfo, parser, file);
                file = parser.findFile(fileNames, DEBIAN_LIST_PACKAGES_FILE_AVAILABLE);
                if (file != null) {
                    this.parseProjectInfo(projectInfo, parser, file);
                }
                if ((debianDependencyInfos = this.mergeDependencyInfos(projectInfo)) != null && !debianDependencyInfos.isEmpty()) {
                    projectInfo.getDependencies().clear();
                    projectInfo.getDependencies().addAll(debianDependencyInfos);
                }
                logger.info("Found {} Debian Packages", (Object)debianDependencyInfos.size());
                parser = new ArchLinuxParser();
                file = parser.findFile(fileNames, ARCH_LINUX_DESC_FOLDERS);
                int archLinuxPackages = this.parseProjectInfo(projectInfo, parser, file);
                logger.info("Found {} Arch linux Packages", (Object)archLinuxPackages);
                parser = new AlpineParser();
                file = parser.findFile(fileNames, ALPINE_LIST_PACKAGES_FILE);
                int alpinePackages = this.parseProjectInfo(projectInfo, parser, file);
                logger.info("Found {} Alpine Packages", (Object)alpinePackages);
                RpmParser rpmParser = new RpmParser();
                LinkedList<String> yumDbFoldersPath = new LinkedList<String>();
                RpmParser.findFolder(imageExtractionDir, "yumdb", yumDbFoldersPath);
                File yumDbFolder = rpmParser.checkFolders(yumDbFoldersPath, RPM_YUM_DB_FOLDER_DEFAULT_PATH);
                int rpmPackages = this.parseProjectInfo(projectInfo, rpmParser, yumDbFolder);
                logger.info("Found {} Rpm Packages", (Object)rpmPackages);
                String extractPath = imageExtractionDir.getPath();
                HashSet<String> setDirs = new HashSet<String>();
                setDirs.add(extractPath);
                HashMap<String, Set<String>> appPathsToDependencyDirs = new HashMap<String, Set<String>>();
                appPathsToDependencyDirs.put("defaultKey", setDirs);
                List<DependencyInfo> dependencyInfos = new FileSystemScanner(this.config.getResolver(), this.config.getAgent(), false).createProjects(Arrays.asList(extractPath), appPathsToDependencyDirs, false, this.config.getAgent().getIncludes(), this.config.getAgent().getExcludes(), this.config.getAgent().getGlobCaseSensitive(), this.config.getAgent().getArchiveExtractionDepth(), FileExtensions.ARCHIVE_INCLUDES, FileExtensions.ARCHIVE_EXCLUDES, false, this.config.getAgent().isFollowSymlinks(), this.config.getAgent().getExcludedCopyrights(), false, this.config.getAgent().getPythonRequirementsFileIncludes());
                projectInfo.getDependencies().addAll(dependencyInfos);
            }
            catch (IOException e) {
                logger.error("Error exporting image {}: {}", (Object)dockerImage.getRepository(), (Object)e.getMessage());
                logger.debug("Error exporting image {}", (Object)dockerImage.getRepository(), (Object)e);
            }
            catch (ArchiverException e) {
                logger.error("Error extracting {}: {}", (Object)imageTarFile, (Object)e.getMessage());
                logger.debug("Error extracting tar archive", (Throwable)e);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                process.destroy();
                this.deleteDockerArchiveFiles(imageTarFile, imageExtractionDir);
            }
        }
    }

    private Collection<DependencyInfo> mergeDependencyInfos(AgentProjectInfo projectInfo) {
        HashedMap infoMap = new HashedMap();
        LinkedList<DependencyInfo> dependencyInfos = new LinkedList<DependencyInfo>();
        if (projectInfo != null) {
            Collection dependencies = projectInfo.getDependencies();
            for (DependencyInfo dependencyInfo : dependencies) {
                infoMap.putIfAbsent(dependencyInfo.getArtifactId(), dependencyInfo);
            }
        }
        for (Map.Entry entry : infoMap.entrySet()) {
            if (entry.getValue() == null) continue;
            dependencyInfos.add((DependencyInfo)entry.getValue());
        }
        return dependencyInfos;
    }

    private File getPackagesLogFile(File file, ArchiveExtractor archiveExtractor) {
        archiveExtractor.unXz(file, file.getParent() + File.separator + PACKAGE_LOG_TXT);
        return new File(file.getParent() + File.separator + PACKAGE_LOG_TXT);
    }

    private int parseProjectInfo(AgentProjectInfo projectInfo, AbstractParser parser, File file) {
        if (file != null) {
            Collection<DependencyInfo> packageManagerPackages = parser.parse(file);
            if (!packageManagerPackages.isEmpty()) {
                projectInfo.getDependencies().addAll(packageManagerPackages);
            }
            return packageManagerPackages.size();
        }
        return 0;
    }

    private void deleteDockerArchiveFiles(File imageTarFile, File imageTarExtractDir) {
        FileUtils.deleteQuietly((File)imageTarFile);
        FileUtils.deleteQuietly((File)imageTarExtractDir);
    }
}

