/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.docker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.dependency.resolver.docker.AbstractParser;
import org.whitesource.agent.dependency.resolver.docker.Package;
import org.whitesource.util.CxLogUtil;

public class DebianParser
extends AbstractParser {
    private final Logger logger = CxLogUtil.getLogger(DebianParser.class);
    private static final String PACKAGE = "Package";
    private static final String VERSION = "Version";
    private static final String ARCHITECTURE = "Architecture";
    private static final String DEBIAN_PACKAGE_PATTERN = "{0}_{1}_{2}.deb";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Collection<DependencyInfo> parse(File file) {
        BufferedReader br = null;
        FileReader fr = null;
        LinkedList<DependencyInfo> dependencyInfos = new LinkedList<DependencyInfo>();
        try {
            fr = new FileReader(file.getAbsoluteFile());
            br = new BufferedReader(fr);
            String line = null;
            Package packageInfo = new Package();
            while ((line = br.readLine()) != null) {
                if (!line.isEmpty()) {
                    String[] lineSplit = line.split(":");
                    String dependencyParameter = lineSplit[1].trim();
                    switch (lineSplit[0]) {
                        case "Package": {
                            packageInfo.setPackageName(dependencyParameter);
                            break;
                        }
                        case "Version": {
                            if (packageInfo.getPackageName() == null) break;
                            packageInfo.setVersion(dependencyParameter);
                            break;
                        }
                        case "Architecture": {
                            if (packageInfo.getPackageName() == null) break;
                            packageInfo.setArchitecture(dependencyParameter);
                            break;
                        }
                    }
                    continue;
                }
                if (packageInfo.getPackageName() == null) continue;
                DependencyInfo dependencyInfo = this.createDependencyInfo(packageInfo);
                packageInfo = new Package();
                dependencyInfos.add(dependencyInfo);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Error getting package data", (Object)e.getMessage());
            DebianParser.closeStream(br, fr);
        }
        catch (IOException e2) {
            this.logger.error("Error getting package data", (Object)e2.getMessage());
            {
                catch (Throwable throwable) {
                    DebianParser.closeStream(br, fr);
                    throw throwable;
                }
            }
            DebianParser.closeStream(br, fr);
        }
        DebianParser.closeStream(br, fr);
        return dependencyInfos;
    }

    @Override
    public File findFile(String[] files, String filename) {
        for (String filepath : files) {
            if (!filepath.endsWith(filename)) continue;
            return new File(filepath);
        }
        return null;
    }

    private DependencyInfo createDependencyInfo(Package packageInfo) {
        DependencyInfo dependencyInfo = null;
        if (StringUtils.isNotBlank((String)packageInfo.getPackageName()) && StringUtils.isNotBlank((String)packageInfo.getVersion()) && StringUtils.isNotBlank((String)packageInfo.getArchitecture())) {
            dependencyInfo = packageInfo.getVersion().contains("+") ? new DependencyInfo(null, MessageFormat.format(DEBIAN_PACKAGE_PATTERN, packageInfo.getPackageName(), packageInfo.getVersion().substring(0, packageInfo.getVersion().lastIndexOf("+")), packageInfo.getArchitecture()), packageInfo.getVersion()) : new DependencyInfo(null, MessageFormat.format(DEBIAN_PACKAGE_PATTERN, packageInfo.getPackageName(), packageInfo.getVersion(), packageInfo.getArchitecture()), packageInfo.getVersion());
        }
        if (dependencyInfo != null) {
            return dependencyInfo;
        }
        return null;
    }
}

