/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.whitesource.util.CxLogUtil;

public class BomFile {
    private final String name;
    private final String version;
    private String groupId;
    private String sha1;
    private String fileName;
    private final String localFileName;
    private final Map<String, String> dependencies;
    private Map<String, String> optionalDependencies;
    private String resolved;
    private boolean scopedPackage;
    public static String DUMMY_PARAMETER_SCOPE_PACKAGE = "{dummyParameterOfScopePackage}";
    private final Logger logger = CxLogUtil.getLogger(BomFile.class);
    private static final String NPM_REGISTRY = "registry.npmjs.org";
    private static final String NPM_REGISTRY1 = "npm/registry/";
    private static final String SCOPED_PACKAGE = "@";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";

    public BomFile(String name, String version, String sha1, String fileName, String localFileName, Map<String, String> dependencies, Map<String, String> optionalDependencies, String resolved) {
        this.name = name;
        this.version = version;
        this.sha1 = sha1;
        this.fileName = fileName;
        this.localFileName = localFileName;
        this.dependencies = dependencies;
        this.optionalDependencies = optionalDependencies;
        this.resolved = resolved;
        this.scopedPackage = false;
        this.groupId = null;
    }

    public BomFile(String groupId, String artifactId, String version, String bomPath) {
        this(artifactId, version, null, null, bomPath, null, null, null);
        this.groupId = groupId;
    }

    public boolean isValid() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.name, this.version});
    }

    public String getName() {
        return this.name;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public static String getUniqueDependencyName(String name, String version) {
        return name + SCOPED_PACKAGE + version.replace("v", "");
    }

    public String getUniqueDependencyName() {
        return BomFile.getUniqueDependencyName(this.name, this.version);
    }

    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public Map<String, String> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    public String getRegistryPackageUrl() {
        String registryPackageUrl = null;
        if (StringUtils.isEmpty((CharSequence)this.resolved)) {
            this.logger.debug("resolved url in file is empty");
            return "";
        }
        this.logger.debug("resolved url in file = " + this.resolved);
        if (this.resolved.contains("git+") || this.resolved.contains("github:")) {
            this.logger.info("This configuration - " + this.name + " (remote repository packages) is not supported by WhiteSource. Please use direct URL package references.");
            return "";
        }
        if (this.resolved.contains(SCOPED_PACKAGE) || this.resolved.indexOf(NPM_REGISTRY) == -1) {
            int npmRegistryIndex = this.resolved.indexOf(NPM_REGISTRY1);
            registryPackageUrl = this.resolved.substring(0, this.resolved.indexOf(this.name, npmRegistryIndex) + this.name.length());
            int lastSlashIndex = registryPackageUrl.lastIndexOf(47);
            registryPackageUrl = registryPackageUrl.substring(0, lastSlashIndex) + DUMMY_PARAMETER_SCOPE_PACKAGE + registryPackageUrl.substring(lastSlashIndex + 1);
            this.scopedPackage = true;
        } else {
            String urlName = "/" + this.name + "/";
            registryPackageUrl = this.resolved.substring(0, this.resolved.indexOf(urlName) + urlName.length());
            if ((registryPackageUrl = registryPackageUrl + this.version).startsWith(HTTPS)) {
                String urlWithoutHttps = registryPackageUrl.substring(HTTPS.length());
                registryPackageUrl = HTTP + urlWithoutHttps;
            }
        }
        this.logger.debug("resolved url in link = " + registryPackageUrl);
        return registryPackageUrl;
    }

    public boolean isScopedPackage() {
        return this.scopedPackage;
    }

    public String toString() {
        return String.join((CharSequence)".", this.getGroupId(), this.getName(), this.getVersion());
    }
}

