/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.IBomParser;
import org.whitesource.agent.dependency.resolver.ResolutionResult;

public abstract class AbstractDependencyResolver {
    protected static final String GLOB_PATTERN = "**/";
    protected static final String fileSeparator = System.getProperty("file.separator");
    protected IBomParser bomParser;

    protected abstract ResolutionResult resolveDependencies(String var1, String var2, Set<String> var3) throws FileNotFoundException;

    protected abstract Collection<String> getExcludes();

    protected abstract DependencyType getDependencyType();

    protected abstract String getDependencyTypeName();

    protected abstract String[] getBomPattern();

    protected abstract Collection<String> getLanguageExcludes();

    protected boolean printResolvedFolder() {
        return true;
    }

    public abstract Collection<String> getSourceFileExtensions();

    protected List<String> normalizeLocalPath(String parentFolder, String topFolderFound, Collection<String> excludes, String folderToIgnore) {
        String normalizedRoot = new File(parentFolder).getPath();
        topFolderFound = normalizedRoot.equals(topFolderFound) ? topFolderFound.replace(normalizedRoot, "").replace("\\", "/") : topFolderFound.replace(parentFolder, "").replace("\\", "/");
        if (topFolderFound.length() > 0) {
            topFolderFound = topFolderFound.substring(1, topFolderFound.length()) + "/";
        }
        String finalRes = topFolderFound;
        if (StringUtils.isBlank((String)folderToIgnore)) {
            return excludes.stream().map(exclude -> finalRes + exclude).collect(Collectors.toList());
        }
        return excludes.stream().map(exclude -> finalRes + folderToIgnore + "/" + exclude).collect(Collectors.toList());
    }
}

