/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.archive;

import com.github.junrar.Junrar;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.FileHeader;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.archiver.tar.TarBZip2UnArchiver;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.tar.TarUnArchiver;
import org.codehaus.plexus.archiver.xz.XZUnArchiver;
import org.redline_rpm.ReadableChannelWrapper;
import org.redline_rpm.Scanner;
import org.redline_rpm.Util;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Format;
import org.redline_rpm.header.Header;
import org.slf4j.Logger;
import org.whitesource.agent.utils.FilesScanner;
import org.whitesource.agent.utils.Pair;
import org.whitesource.fs.FsUtils;
import org.whitesource.util.CxLogUtil;

public class ArchiveExtractor {
    public static final String LAYER_TAR = "**/*layer.tar";
    private final Logger logger = CxLogUtil.getLogger(ArchiveExtractor.class);
    public static final int LONG_BOUND = 100000;
    public static final String DEPTH = "_depth_";
    public static final String DEPTH_REGEX = "_depth_[0-9]";
    public static final String GLOB_PREFIX = "glob:";
    public static final String NULL_HEADER = "mainheader is null";
    private final String JAVA_TEMP_DIR = FsUtils.getTmpDir();
    private final String WHITESOURCE_TEMP_FOLDER = "WhiteSource-ArchiveExtractor";
    public static final List<String> ZIP_EXTENSIONS = Arrays.asList("jar", "war", "ear", "egg", "zip", "whl", "sca", "sda", "nupkg");
    public static final List<String> GEM_EXTENSIONS = Collections.singletonList("gem");
    public static final List<String> TAR_EXTENSIONS = Arrays.asList("tar.gz", "tar", "tgz", "tar.bz2", "tar.xz", "xz");
    public static final List<String> RPM_EXTENSIONS = Collections.singletonList("rpm");
    public static final List<String> RAR_EXTENSIONS = Collections.singletonList("rar");
    public static final String ZIP_EXTENSION_PATTERN = ArchiveExtractor.initializePattern(ZIP_EXTENSIONS);
    public static final String GEM_EXTENSION_PATTERN = ArchiveExtractor.initializePattern(GEM_EXTENSIONS);
    public static final String TAR_EXTENSION_PATTERN = ArchiveExtractor.initializePattern(TAR_EXTENSIONS);
    public static final String RPM_EXTENSION_PATTERN = ArchiveExtractor.initializePattern(RPM_EXTENSIONS);
    public static final String RAR_EXTENSION_PATTERN = ArchiveExtractor.initializePattern(RAR_EXTENSIONS);
    public static final String RUBY_DATA_FILE = "data.tar.gz";
    public static final String TAR_SUFFIX = ".tar";
    public static final String GZ_SUFFIX = ".gz";
    public static final String BZ_SUFFIX = ".bz2";
    public static final String XZ_SUFFIX = ".xz";
    public static final String LZMA = "lzma";
    public static final String CPIO = ".cpio";
    public static final String TGZ_SUFFIX = ".tgz";
    public static final String TAR_GZ_SUFFIX = ".tar.gz";
    public static final String TAR_BZ2_SUFFIX = ".tar.bz2";
    public static final String UN_ARCHIVER_LOGGER = "unArchiverLogger";
    public static final String GLOB_PATTERN_PREFIX = "**/*.";
    public static final String PATTERN_PREFIX = ".*\\.";
    public static final String XZ_UN_ARCHIVER_FILE_NAME = "compressedFile.tar";
    private final String[] archiveIncludesPattern;
    private final String[] archiveExcludesPattern;
    private final String[] filesExcludes;
    private String randomString;
    private String tempFolderNoDepth;
    private boolean fastUnpack = false;

    private static String initializePattern(List<String> archiveExtensions) {
        StringBuilder sb = new StringBuilder();
        for (String archiveExtension : archiveExtensions) {
            sb.append(PATTERN_PREFIX);
            sb.append(archiveExtension);
            sb.append("|");
        }
        return sb.toString().substring(0, sb.toString().lastIndexOf("|"));
    }

    public ArchiveExtractor(String[] archiveIncludes, String[] archiveExcludes, String[] filesExcludes, boolean fastUnpack) {
        this(archiveIncludes, archiveExcludes, filesExcludes);
        this.fastUnpack = fastUnpack;
    }

    public ArchiveExtractor(String[] archiveIncludes, String[] archiveExcludes, String[] filesExcludes) {
        this.archiveIncludesPattern = archiveIncludes.length > 0 && StringUtils.isNotBlank((String)archiveIncludes[0]) ? archiveIncludes : this.createArchivesArray();
        this.archiveExcludesPattern = archiveExcludes;
        this.filesExcludes = filesExcludes;
    }

    private String getTempFolder(String scannerBaseDir) {
        String creationDate = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String tempFolder = this.JAVA_TEMP_DIR.endsWith(File.separator) ? this.JAVA_TEMP_DIR + "WhiteSource-ArchiveExtractor" + File.separator + creationDate : this.JAVA_TEMP_DIR + File.separator + "WhiteSource-ArchiveExtractor" + File.separator + creationDate;
        String destDirectory = tempFolder + "_" + this.randomString;
        int separatorIndex = scannerBaseDir.lastIndexOf(File.separator);
        if (separatorIndex != -1) {
            destDirectory = destDirectory + scannerBaseDir.substring(separatorIndex, scannerBaseDir.length());
            try {
                destDirectory = new File(destDirectory).getCanonicalPath().toString();
            }
            catch (IOException e) {
                this.logger.warn("Error getting the absolute file name ", (Throwable)e);
            }
        }
        return destDirectory;
    }

    public String extractArchives(String scannerBaseDir, int archiveExtractionDepth, List<String> archiveDirectories) {
        this.randomString = String.valueOf(ThreadLocalRandom.current().nextLong(0L, 100000L));
        this.tempFolderNoDepth = this.getTempFolder(scannerBaseDir);
        this.logger.debug("Base directory is {}, extraction depth is set to {}", (Object)scannerBaseDir, (Object)archiveExtractionDepth);
        HashMap<String, Map<String, String>> allFiles = new HashMap<String, Map<String, String>>();
        for (int curLevel = 0; curLevel < archiveExtractionDepth; ++curLevel) {
            String folderToScan = curLevel == 0 ? scannerBaseDir : this.getDepthFolder(curLevel - 1);
            String folderToExtract = this.getDepthFolder(curLevel);
            Pair<String[], String> retrieveFilesWithFolder = this.getSearchedFileNames(folderToScan);
            if (retrieveFilesWithFolder == null || retrieveFilesWithFolder.getKey().length <= 0) break;
            String[] fileNames = retrieveFilesWithFolder.getKey();
            folderToScan = retrieveFilesWithFolder.getValue();
            Pair<String, Collection<String>> filesFound = new Pair<String, Collection<String>>(folderToScan, Arrays.stream(fileNames).collect(Collectors.toList()));
            Map<String, String> foundFiles = this.fastUnpack ? this.handleArchiveFilesFast(folderToExtract, filesFound) : this.handleArchiveFiles(folderToExtract, filesFound);
            allFiles.put(String.valueOf(curLevel), foundFiles);
        }
        if (!allFiles.isEmpty()) {
            String parentDirectory = new File(this.tempFolderNoDepth).getParent();
            archiveDirectories.add(parentDirectory);
            return parentDirectory;
        }
        return null;
    }

    public void extractDockerImageLayers(File imageTarFile, File imageExtractionDir) {
        FilesScanner filesScanner = new FilesScanner();
        boolean success = false;
        if (imageTarFile.getName().endsWith(TAR_SUFFIX)) {
            success = this.unTar(imageTarFile.getName().toLowerCase(), imageExtractionDir.getAbsolutePath(), imageTarFile.getPath());
            boolean deleted = imageTarFile.delete();
            if (!deleted) {
                this.logger.warn("Was not able to delete {} (docker image TAR file)", (Object)imageTarFile.getName());
            }
        }
        if (success) {
            String[] fileNames;
            for (String filename : fileNames = filesScanner.getDirectoryContent(imageExtractionDir.getAbsolutePath(), new String[]{LAYER_TAR}, new String[0], true, false)) {
                File layerToExtract = new File(imageExtractionDir + File.separator + filename);
                this.extractDockerImageLayers(layerToExtract, layerToExtract.getParentFile());
            }
        } else {
            this.logger.warn("Was not able to extract {} (docker image TAR file)", (Object)imageTarFile.getName());
        }
    }

    private String getDepthFolder(int depth) {
        return this.tempFolderNoDepth + DEPTH + depth;
    }

    private String[] createArchivesArray() {
        ArrayList<String> archiveExtensions = new ArrayList<String>();
        archiveExtensions.addAll(ZIP_EXTENSIONS);
        archiveExtensions.addAll(GEM_EXTENSIONS);
        archiveExtensions.addAll(TAR_EXTENSIONS);
        String[] archiveIncludesPattern = new String[archiveExtensions.size()];
        int i = 0;
        for (String extension : archiveExtensions) {
            archiveIncludesPattern[i++] = GLOB_PATTERN_PREFIX + extension;
        }
        return archiveIncludesPattern;
    }

    private Pair<String[], String> getSearchedFileNames(String fileOrFolderToScan) {
        String[] foundFiles = null;
        File file = new File(fileOrFolderToScan);
        if (file.exists()) {
            FilesScanner filesScanner = new FilesScanner();
            if (file.isDirectory()) {
                foundFiles = filesScanner.getDirectoryContent(fileOrFolderToScan, this.archiveIncludesPattern, this.archiveExcludesPattern, false, false);
                String folderToScan = fileOrFolderToScan;
                return new Pair<String[], String>(foundFiles, folderToScan);
            }
            boolean included = filesScanner.isIncluded(file, this.archiveIncludesPattern, this.archiveExcludesPattern, false, false);
            if (included) {
                String folderToScan = file.getParent();
                String relativeFilePath = new File(folderToScan).toURI().relativize(new File(file.getAbsolutePath()).toURI()).getPath();
                foundFiles = new String[]{relativeFilePath};
                return new Pair<String[], String>(foundFiles, folderToScan);
            }
            filesScanner = null;
        }
        return null;
    }

    private Map<String, String> handleArchiveFiles(String baseFolderToExtract, Pair<String, Collection<String>> fileNames) {
        HashMap<String, String> founded = new HashMap<String, String>();
        for (String fileName : fileNames.getValue()) {
            String archivePath = Paths.get(fileNames.getKey(), fileName).toString();
            String unpackFolder = Paths.get(baseFolderToExtract, FilenameUtils.removeExtension((String)fileName)).toString();
            Pair<String, String> dataToUnpack = new Pair<String, String>(archivePath, unpackFolder);
            Pair<String, String> foundArchive = this.getUnpackedResult(dataToUnpack);
            if (foundArchive == null) continue;
            founded.put(foundArchive.getKey(), foundArchive.getValue());
        }
        return founded;
    }

    private Map<String, String> handleArchiveFilesFast(String baseFolderToExtract, Pair<String, Collection<String>> fileNames) {
        Collection dataToUnpack = fileNames.getValue().stream().map(fileName -> {
            String archivePath = Paths.get((String)fileNames.getKey(), fileName).toString();
            String unpackFolder = Paths.get(baseFolderToExtract, FilenameUtils.removeExtension((String)fileName)).toString();
            return new Pair<String, String>(archivePath, unpackFolder);
        }).collect(Collectors.toList());
        return this.processCollections(dataToUnpack);
    }

    public Map<String, String> processCollections(Collection<Pair> unitsOfWork) {
        int numberOfThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads);
        ArrayList handles = new ArrayList();
        ArrayList callableList = new ArrayList();
        unitsOfWork.stream().forEach(unitOfWork -> callableList.add(() -> this.getUnpackedResult((Pair<String, String>)unitOfWork)));
        for (Callable callable : callableList) {
            Future future = executorService.submit(callable);
            handles.add(future);
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (Future future : handles) {
            try {
                Pair dataToUnpack = (Pair)future.get();
                results.put((String)dataToUnpack.getKey(), (String)dataToUnpack.getValue());
            }
            catch (InterruptedException e) {
                this.logger.warn("Error: {}", (Object)e.getMessage());
            }
            catch (ExecutionException e) {
                this.logger.warn("Error: {}", (Object)e.getMessage());
            }
        }
        executorService.shutdownNow();
        return results;
    }

    private Pair<String, String> getUnpackedResult(Pair<String, String> dataToUnpack) {
        boolean foundArchive = false;
        String innerDir = dataToUnpack.getValue();
        String fileKey = dataToUnpack.getKey();
        String lowerCaseFileName = fileKey.toLowerCase();
        if (lowerCaseFileName.matches(ZIP_EXTENSION_PATTERN)) {
            foundArchive = this.unZip(innerDir, fileKey);
        } else if (lowerCaseFileName.matches(GEM_EXTENSION_PATTERN)) {
            foundArchive = this.unTar(lowerCaseFileName, innerDir, fileKey);
            innerDir = innerDir + File.separator + RUBY_DATA_FILE;
            foundArchive = this.unTar(RUBY_DATA_FILE, innerDir + this.randomString, innerDir);
            innerDir = innerDir + this.randomString;
        } else if (lowerCaseFileName.matches(TAR_EXTENSION_PATTERN)) {
            foundArchive = this.unTar(lowerCaseFileName, innerDir, fileKey);
        } else if (lowerCaseFileName.matches(RPM_EXTENSION_PATTERN)) {
            foundArchive = this.handleRpmFile(innerDir, fileKey);
        } else if (lowerCaseFileName.matches(RAR_EXTENSION_PATTERN)) {
            foundArchive = this.extractRarFile(innerDir, fileKey);
        } else {
            this.logger.warn("Error: {} is unsupported archive type", (Object)fileKey);
        }
        if (foundArchive) {
            Pair<String, String> resultArchive = new Pair<String, String>(lowerCaseFileName, innerDir);
            return resultArchive;
        }
        return null;
    }

    private boolean extractRarFile(String innerDir, String fileKey) {
        File destDir = new File(innerDir);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try {
            Junrar.extract((String)fileKey, (String)innerDir);
            boolean foundArchive = true;
        }
        catch (Exception e) {
            this.logger.warn("Error extracting file {}: {}", (Object)fileKey, (Object)e.getMessage());
            try {
                if (e.getMessage().contains(NULL_HEADER) && new ZipFile(fileKey) instanceof ZipFile) {
                    this.logger.info("Retrying extraction  {}", (Object)fileKey);
                    boolean bl = this.unZip(innerDir, fileKey);
                }
            }
            catch (Exception e1) {
                this.logger.warn("Error extracting file {}: {}", (Object)fileKey, (Object)e.getMessage());
                boolean bl = false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unZip(String innerDir, String archiveFile) {
        boolean success = true;
        try {
            ZipFile zipFile = new ZipFile(archiveFile);
            List fileHeaderList = zipFile.getFileHeaders();
            List matchers = Arrays.stream(this.filesExcludes).map(fileExclude -> FileSystems.getDefault().getPathMatcher(GLOB_PREFIX + fileExclude)).collect(Collectors.toList());
            for (int i = 0; i < fileHeaderList.size(); ++i) {
                FileHeader fileHeader = (FileHeader)fileHeaderList.get(i);
                String fileName = fileHeader.getFileName();
                if (this.filesExcludes.length > 0) {
                    Predicate<PathMatcher> matchesExcludes = pathMatcher -> pathMatcher.matches(Paths.get(innerDir, fileName));
                    if (!matchers.stream().noneMatch(matchesExcludes)) continue;
                    zipFile.extractFile(fileHeader, innerDir);
                    continue;
                }
                zipFile.extractFile(fileHeader, innerDir);
            }
        }
        catch (Exception e) {
            success = false;
            this.logger.warn("Error extracting file {}: {}", (Object)archiveFile, (Object)e.getMessage());
            this.logger.debug("Error extracting file {}: {}", (Object)archiveFile, (Object)e.getStackTrace());
        }
        finally {
            Object zipFile = null;
        }
        return success;
    }

    private boolean unTar(String fileName, String innerDir, String archiveFile) {
        boolean success = true;
        TarUnArchiver unArchiver = new TarUnArchiver();
        try {
            File destDir = new File(innerDir);
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            if (fileName.endsWith(TAR_GZ_SUFFIX) || fileName.endsWith(TGZ_SUFFIX)) {
                unArchiver = new TarGZipUnArchiver();
            } else if (fileName.endsWith(TAR_BZ2_SUFFIX)) {
                unArchiver = new TarBZip2UnArchiver();
            } else if (fileName.endsWith(XZ_SUFFIX)) {
                String destFileUrl = destDir.getCanonicalPath() + "\\" + XZ_UN_ARCHIVER_FILE_NAME;
                success = this.unXz(new File(archiveFile), destFileUrl);
                archiveFile = destFileUrl;
            }
            if (success) {
                unArchiver.setSourceFile(new File(archiveFile));
                unArchiver.setDestDirectory(destDir);
                unArchiver.extract();
            }
        }
        catch (Exception e) {
            success = false;
            this.logger.warn("Error extracting file {}: {}", (Object)fileName, (Object)e.getMessage());
        }
        return success;
    }

    public boolean unXz(File srcFileToArchive, String destFilePath) {
        boolean success = true;
        try {
            XZUnArchiver XZUnArchiver2 = new XZUnArchiver();
            XZUnArchiver2.setSourceFile(srcFileToArchive);
            XZUnArchiver2.setDestFile(new File(destFilePath));
            XZUnArchiver2.extract();
        }
        catch (Exception e) {
            success = false;
            this.logger.warn("Failed to extract Xz file : {} - {}", (Object)srcFileToArchive.getPath(), (Object)e.getMessage());
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRpmFile(String innerDir, String archiveFile) {
        boolean success = true;
        File rpmFile = new File(archiveFile);
        FileInputStream rpmFIS = null;
        try {
            rpmFIS = new FileInputStream(rpmFile.getPath());
        }
        catch (FileNotFoundException e) {
            success = false;
            this.logger.warn("File not found: {}", (Object)archiveFile);
        }
        Format format = null;
        ReadableByteChannel channel = Channels.newChannel(rpmFIS);
        ReadableChannelWrapper channelWrapper = new ReadableChannelWrapper(channel);
        try {
            format = new Scanner().run(channelWrapper);
        }
        catch (IOException e) {
            success = false;
            this.logger.warn("Error reading RPM file {}: {}", (Object)archiveFile, (Object)e.getCause());
        }
        if (format != null) {
            Header header = format.getHeader();
            FileOutputStream cpioOS = null;
            FileOutputStream cpioEntryOutputStream = null;
            CpioArchiveInputStream cpioIn = null;
            File cpioFile = null;
            try {
                CpioArchiveEntry cpioEntry;
                InputStream inputStream;
                AbstractHeader.Entry pcEntry = header.getEntry((AbstractHeader.Tag)Header.HeaderTag.PAYLOADCOMPRESSOR);
                String[] pc = (String[])pcEntry.getValues();
                if (pc[0].equals(LZMA)) {
                    try {
                        inputStream = new LZMACompressorInputStream((InputStream)rpmFIS);
                    }
                    catch (Exception e) {
                        throw new IOException("Failed to load LZMA compression stream", e);
                    }
                } else {
                    inputStream = Util.openPayloadStream((Header)header, (InputStream)rpmFIS);
                }
                cpioFile = new File(rpmFile.getPath() + CPIO);
                cpioOS = new FileOutputStream(cpioFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)cpioOS);
                File extractDestination = new File(innerDir);
                extractDestination.mkdirs();
                cpioIn = new CpioArchiveInputStream((InputStream)new FileInputStream(cpioFile));
                while ((cpioEntry = cpioIn.getNextEntry()) != null) {
                    String innerExtractionDir;
                    String entryName = cpioEntry.getName();
                    String lowercaseName = entryName.toLowerCase();
                    File file = new File(extractDestination, this.getFileName(entryName));
                    cpioEntryOutputStream = new FileOutputStream(file);
                    IOUtils.copy((InputStream)cpioIn, (OutputStream)cpioEntryOutputStream);
                    if (lowercaseName.matches(TAR_EXTENSION_PATTERN)) {
                        innerExtractionDir = innerDir + File.separator + entryName + this.randomString;
                        this.unTar(file.getName(), innerExtractionDir, file.getPath());
                    } else if (lowercaseName.matches(ZIP_EXTENSION_PATTERN)) {
                        innerExtractionDir = innerDir + File.separator + entryName + this.randomString;
                        this.unZip(innerExtractionDir, file.getPath());
                    }
                    this.closeResource(cpioEntryOutputStream);
                }
                this.closeResource(cpioEntryOutputStream);
                this.closeResource((Closeable)cpioIn);
                this.closeResource(cpioOS);
                this.deleteFile(cpioFile);
            }
            catch (IOException e) {
                this.logger.error("Error unpacking rpm file {}: {}", (Object)rpmFile.getName(), (Object)e.getMessage());
            }
            finally {
                this.closeResource(cpioEntryOutputStream);
                this.closeResource((Closeable)cpioIn);
                this.closeResource(cpioOS);
                this.deleteFile(cpioFile);
            }
        }
        return success;
    }

    private void deleteFile(File cpioFile) {
        try {
            FileUtils.forceDelete((File)cpioFile);
        }
        catch (IOException e) {
            this.logger.warn("Error deleting cpio file {}: {}", (Object)cpioFile.getName(), (Object)e.getMessage());
        }
    }

    private void closeResource(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                this.logger.warn("Error closing file {}: {}", (Object)resource.toString(), (Object)e.getMessage());
            }
        }
    }

    private String getFileName(String name) {
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1, name.length());
        } else if (name.contains("\\")) {
            name = name.substring(name.lastIndexOf("\\") + 1, name.length());
        }
        return name;
    }
}

