/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.whitesource.agent.api.model.ChecksumType;
import org.whitesource.agent.api.model.CopyrightInfo;
import org.whitesource.agent.api.model.DependencyHintsInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.hash.ChecksumUtils;
import org.whitesource.agent.hash.HashAlgorithm;
import org.whitesource.agent.hash.HashCalculator;
import org.whitesource.agent.hash.HintUtils;
import org.whitesource.util.CxLogUtil;

public class DependencyInfoFactory {
    private final Logger logger = CxLogUtil.getLogger(DependencyInfoFactory.class);
    private static final String COPYRIGHT = "copyright";
    private static final String COPYRIGHT_SYMBOL = "(c)";
    private static final String COPYRIGHT_ASCII_SYMBOL = "\u00a9";
    private static final List<String> COPYRIGHT_TEXTS = Arrays.asList("copyright (c)", "copyright(c)", "(c) copyright", "(c)copyright", "copyright", "(c)", "\u00a9");
    private static final String ALL_RIGHTS_RESERVED = "all rights reserved";
    private static final String COPYRIGHT_ALPHA_CHAR_REGEX = ".*[a-zA-Z]+.*";
    private static final String CONTAINS_YEAR_REGEX = ".*(\\d\\d\\d\\d)+.*";
    private static final String JAVA_SCRIPT_REGEX = ".*\\.js";
    private static final List<Character> MATH_SYMBOLS = Arrays.asList(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('='), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('^'));
    private static final int MAX_VALID_CHAR_VALUE = 127;
    private static final int MAX_INVALID_CHARS = 2;
    private static final String DEFINE = "define";
    private static final String TODO_PATTERN = "todo:.*|todo .*";
    private static final String CODE_LINE_SUFFIX = ".*:|.*;|.*\\{|.*}|.*\\[|.*]|.*>";
    private static final Map<String, String> commentStartEndMap = new HashMap<String, String>();
    private final Collection<String> excludedCopyrights;
    private final boolean partialSha1Match;
    private boolean calculateHints;
    private boolean calculateMd5;

    public DependencyInfoFactory() {
        this.excludedCopyrights = new ArrayList<String>();
        this.partialSha1Match = false;
    }

    public DependencyInfoFactory(Collection<String> excludedCopyrights, boolean partialSha1Match) {
        this.excludedCopyrights = excludedCopyrights;
        this.partialSha1Match = partialSha1Match;
    }

    public DependencyInfoFactory(Collection<String> excludedCopyrights, boolean partialSha1Match, boolean calculateHints, boolean calculateMd5) {
        this(excludedCopyrights, partialSha1Match);
        this.calculateHints = calculateHints;
        this.calculateMd5 = calculateMd5;
    }

    public DependencyInfo createDependencyInfo(File basedir, String filename) {
        DependencyInfo dependency;
        try {
            File dependencyFile = new File(basedir, filename);
            String sha1 = ChecksumUtils.calculateSHA1((File)dependencyFile);
            dependency = new DependencyInfo(sha1);
            dependency.setArtifactId(dependencyFile.getName());
            dependency.setFilename(dependencyFile.getName());
            try {
                dependency.setSystemPath(dependencyFile.getCanonicalPath());
            }
            catch (IOException e) {
                dependency.setSystemPath(dependencyFile.getAbsolutePath());
            }
            if (this.calculateHints) {
                DependencyHintsInfo hints = HintUtils.getHints((String)dependencyFile.getPath());
                dependency.setHints(hints);
            }
            if (this.calculateMd5) {
                String md5 = ChecksumUtils.calculateHash((File)dependencyFile, (HashAlgorithm)HashAlgorithm.MD5);
                dependency.addChecksum(ChecksumType.MD5, md5);
            }
            if (filename.toLowerCase().matches(JAVA_SCRIPT_REGEX)) {
                try {
                    Map javaScriptChecksums = new HashCalculator().calculateJavaScriptHashes(dependencyFile);
                    for (Map.Entry entry : javaScriptChecksums.entrySet()) {
                        dependency.addChecksum((ChecksumType)entry.getKey(), (String)entry.getValue());
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Failed to calculate javaScript hash for file: {}, error: {}", (Object)dependencyFile.getPath(), (Object)e.getMessage());
                    this.logger.debug("Failed to calculate javaScript hash for file: {}, error: {}", (Object)dependencyFile.getPath(), (Object)e.getStackTrace());
                }
            }
            ChecksumUtils.calculateOtherPlatformSha1((DependencyInfo)dependency, (File)dependencyFile);
            ChecksumUtils.calculateSuperHash((DependencyInfo)dependency, (File)dependencyFile);
        }
        catch (IOException e) {
            this.logger.warn("Failed to create dependency " + filename + " to dependency list: {}", (Object)e.getMessage());
            dependency = null;
        }
        return dependency;
    }

    private Collection<CopyrightInfo> extractCopyrights(File file) {
        ArrayList<CopyrightInfo> copyrights = new ArrayList<CopyrightInfo>();
        try {
            boolean commentBlock = false;
            Iterator iterator = FileUtils.readLines((File)file).iterator();
            int lineIndex = 1;
            while (iterator.hasNext()) {
                String line = ((String)iterator.next()).trim();
                if (!commentBlock) {
                    for (Map.Entry<String, String> entry : commentStartEndMap.entrySet()) {
                        String commentStart = entry.getKey();
                        String commentEnd = entry.getValue();
                        if (line.startsWith(commentStart)) {
                            if (line.contains(commentEnd)) {
                                int commentLength;
                                commentBlock = false;
                                int endIndex = line.indexOf(commentEnd);
                                if (endIndex >= (commentLength = commentStart.length())) {
                                    line = line.substring(commentLength, endIndex);
                                    break;
                                }
                                line = "";
                                break;
                            }
                            commentBlock = true;
                            break;
                        }
                        if (!line.contains(commentStart)) continue;
                        int startIndex = line.indexOf(commentStart);
                        if (line.contains(commentEnd)) {
                            int endIndex = line.indexOf(commentEnd);
                            if (startIndex >= endIndex) break;
                            commentBlock = false;
                            line = line.substring(startIndex, endIndex);
                            break;
                        }
                        commentBlock = true;
                        line = line.substring(startIndex);
                        break;
                    }
                }
                String lowerCaseLine = line.toLowerCase();
                if ((commentBlock || line.startsWith("//") || line.startsWith("#")) && (lowerCaseLine.contains(COPYRIGHT) || lowerCaseLine.contains(COPYRIGHT_SYMBOL) || lowerCaseLine.contains(COPYRIGHT_ASCII_SYMBOL))) {
                    String copyright;
                    String lowercaseCopyright;
                    if (lowerCaseLine.contains(COPYRIGHT_SYMBOL) && this.isMathExpression(lowerCaseLine) || lowerCaseLine.contains(COPYRIGHT_ASCII_SYMBOL) && this.hasInvalidAsciiChars(lowerCaseLine) || (line = this.cleanLine(line)).toLowerCase().matches(TODO_PATTERN)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(line);
                    boolean continuedToNextLine = false;
                    if (iterator.hasNext()) {
                        String copyrightOwner = null;
                        lowerCaseLine = line.toLowerCase();
                        for (String copyrightText : COPYRIGHT_TEXTS) {
                            if (!lowerCaseLine.startsWith(copyrightText)) continue;
                            copyrightOwner = line.substring(copyrightText.length()).trim();
                            break;
                        }
                        if (copyrightOwner != null && !copyrightOwner.matches(COPYRIGHT_ALPHA_CHAR_REGEX)) {
                            for (String commentEnd : commentStartEndMap.values()) {
                                if (!line.contains(commentEnd)) continue;
                                commentBlock = false;
                                break;
                            }
                            if (commentBlock) {
                                String nextLine = this.cleanLine((String)iterator.next());
                                sb.append(" ");
                                sb.append(nextLine);
                                continuedToNextLine = true;
                                line = nextLine;
                            }
                        }
                    }
                    if ((lowercaseCopyright = (copyright = sb.toString()).toLowerCase()).contains(ALL_RIGHTS_RESERVED)) {
                        int startIndex = lowercaseCopyright.indexOf(ALL_RIGHTS_RESERVED);
                        int endIndex = startIndex + ALL_RIGHTS_RESERVED.length();
                        copyright = endIndex == copyright.length() ? copyright.substring(0, startIndex).trim() : copyright.substring(0, startIndex).trim() + " " + copyright.substring(endIndex).trim();
                    }
                    copyrights.add(new CopyrightInfo(copyright, lineIndex));
                    if (continuedToNextLine) {
                        ++lineIndex;
                    }
                }
                for (String commentEnd : commentStartEndMap.values()) {
                    if (!line.contains(commentEnd)) continue;
                    commentBlock = false;
                    break;
                }
                ++lineIndex;
            }
        }
        catch (FileNotFoundException e) {
            this.logger.warn("File not found: " + file.getPath());
        }
        catch (IOException e) {
            this.logger.warn("Error reading file: " + file.getPath());
        }
        this.removeRedundantCopyrights(copyrights);
        return copyrights;
    }

    private void removeRedundantCopyrights(Collection<CopyrightInfo> copyrights) {
        Iterator<CopyrightInfo> iterator;
        if (copyrights.size() > 1) {
            boolean hasCopyrightWithYear = false;
            for (CopyrightInfo copyright : copyrights) {
                if (!copyright.getCopyright().matches(CONTAINS_YEAR_REGEX)) continue;
                hasCopyrightWithYear = true;
                break;
            }
            if (hasCopyrightWithYear) {
                iterator = copyrights.iterator();
                while (iterator.hasNext()) {
                    CopyrightInfo copyrightInfo = iterator.next();
                    String copyright = copyrightInfo.getCopyright();
                    if (copyright.matches(CONTAINS_YEAR_REGEX) || copyright.toLowerCase().contains(COPYRIGHT_SYMBOL)) continue;
                    iterator.remove();
                }
            }
        }
        HashSet<String> copyTexts = new HashSet<String>();
        iterator = copyrights.iterator();
        while (iterator.hasNext()) {
            String lowerCaseCopyright = iterator.next().getCopyright().toLowerCase();
            if (copyTexts.contains(lowerCaseCopyright)) {
                iterator.remove();
                continue;
            }
            copyTexts.add(lowerCaseCopyright);
        }
    }

    private boolean containsExcludedCopyright(DependencyInfo dependencyInfo) {
        for (CopyrightInfo copyrightInfo : dependencyInfo.getCopyrights()) {
            String lowerCaseCopyright = copyrightInfo.getCopyright().toLowerCase();
            for (String excludedCopyright : this.excludedCopyrights) {
                if (!lowerCaseCopyright.contains(excludedCopyright.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMathExpression(String line) {
        char c;
        int i;
        String cleanLine = this.cleanLine(line).trim();
        boolean mathExpression = false;
        if (cleanLine.startsWith(DEFINE)) {
            return true;
        }
        if (cleanLine.matches(CODE_LINE_SUFFIX)) {
            return true;
        }
        int index = cleanLine.indexOf(COPYRIGHT_SYMBOL);
        for (i = index + 1; i < cleanLine.length(); ++i) {
            c = cleanLine.charAt(i);
            if (c == '(' || c == ')' || c == ' ') continue;
            if (!MATH_SYMBOLS.contains(Character.valueOf(c))) break;
            mathExpression = true;
            break;
        }
        if (mathExpression) {
            for (i = index - 1; i >= 0; --i) {
                c = cleanLine.charAt(i);
                if (c == '(' || c == ')' || c == ' ') continue;
                if (!MATH_SYMBOLS.contains(Character.valueOf(c))) break;
                mathExpression = true;
                break;
            }
        }
        return mathExpression;
    }

    private boolean hasInvalidAsciiChars(String line) {
        String cleanLine = this.cleanLine(line).trim();
        int invalidChars = 0;
        for (int i = 0; i < cleanLine.length(); ++i) {
            char c = cleanLine.charAt(i);
            if (c > '\u007f' || c == '?') {
                ++invalidChars;
            }
            if (invalidChars != 2) continue;
            return true;
        }
        return false;
    }

    private String cleanLine(String line) {
        return line.replace("/**", "").replace("/*", "").replace("*", "").replace("#", "").replace("/", "").replace("\\t", "").replace("\\n", "").trim();
    }

    private void deleteFile(File file) {
        if (file != null) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        commentStartEndMap.put("/*", "*/");
        commentStartEndMap.put("/**", "*/");
        commentStartEndMap.put("<!--", "-->");
        commentStartEndMap.put("\"\"\"", "\"\"\"");
        commentStartEndMap.put("=begin", "=end");
        commentStartEndMap.put("##", "##");
    }
}

