/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.report;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(String resource, File destination) throws IOException {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int len;
            is = FileUtils.class.getResourceAsStream("/" + resource);
            fos = new FileOutputStream(destination);
            byte[] buffer = new byte[10240];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(is);
            FileUtils.close(fos);
            throw throwable;
        }
        FileUtils.close(is);
        FileUtils.close(fos);
    }

    public static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void packDirectory(File dir, ZipOutputStream zos) throws IOException {
        byte[] buffer = new byte[65536];
        try {
            FileUtils.traverseAndWrite(dir, zos, new StringBuilder(), true, buffer);
        }
        finally {
            FileUtils.close(zos);
        }
    }

    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean success = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                success = success && FileUtils.deleteRecursive(f);
            }
        }
        return success && path.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traverseAndWrite(File file, ZipOutputStream zos, StringBuilder pathBuilder, boolean isFirst, byte[] buffer) throws IOException {
        if (!isFirst) {
            pathBuilder.append(file.getName());
            if (!file.isFile()) {
                pathBuilder.append('/');
            }
        }
        if (file.isFile()) {
            String path = pathBuilder.toString();
            ZipEntry zipEntry = new ZipEntry(path);
            zipEntry.setTime(file.lastModified());
            zos.putNextEntry(zipEntry);
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                int read;
                do {
                    read = ((InputStream)input).read(buffer);
                    zos.write(buffer, 0, Math.max(read, 0));
                } while (read == buffer.length);
            }
            finally {
                FileUtils.close(input);
            }
        } else {
            File[] files = file.listFiles();
            if (files != null) {
                int length = pathBuilder.length();
                for (File innerFile : files) {
                    FileUtils.traverseAndWrite(innerFile, zos, pathBuilder, false, buffer);
                    pathBuilder.setLength(length);
                }
            }
        }
    }

    private FileUtils() {
    }
}

