/*
 * Decompiled with CFR 0.152.
 */
package fr.dutra.tools.maven.deptree.core;

import fr.dutra.tools.maven.deptree.core.AbstractLineBasedParser;
import fr.dutra.tools.maven.deptree.core.Node;
import fr.dutra.tools.maven.deptree.core.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DotParser
extends AbstractLineBasedParser {
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private Node root;

    @Override
    public Node parse(Reader reader) throws ParseException {
        try {
            this.lines = this.splitLines(reader);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        if (this.lines.isEmpty()) {
            return null;
        }
        this.parseFirstLine();
        if (this.root != null) {
            while (this.lineIndex < this.lines.size() - 1) {
                this.parseLine();
                ++this.lineIndex;
            }
        }
        return this.root;
    }

    private void parseFirstLine() {
        Node node;
        String str = StringUtils.substringBetween((String)((String)this.lines.get(0)), (String)"\"");
        String[] tokens = StringUtils.split((String)str, (char)':');
        if (tokens.length != 4) {
            throw new IllegalStateException("Wrong number of tokens: " + tokens.length + " for first line (4 expected)");
        }
        this.root = node = new Node(tokens[0], tokens[1], tokens[2], null, tokens[3], null, null, false);
        this.nodes.put(str, node);
        ++this.lineIndex;
    }

    private void parseLine() {
        String parentArtifact;
        String line = (String)this.lines.get(this.lineIndex);
        if (line.contains("->")) {
            parentArtifact = StringUtils.substringBetween((String)line, (String)"\"");
        } else {
            parentArtifact = this.extractActiveProjectArtifact();
            line = (String)this.lines.get(this.lineIndex);
        }
        Node parent = this.nodes.get(parentArtifact);
        if (parent == null) {
            throw new IllegalStateException("Cannot find parent artifact: " + parentArtifact);
        }
        String childArtifact = line.contains("active project artifact:") ? this.extractActiveProjectArtifact() : StringUtils.substringBetween((String)line, (String)"-> \"", (String)"\" ;");
        Node child = this.parseArtifactString(childArtifact);
        parent.addChildNode(child);
        this.nodes.put(childArtifact, child);
    }
}

